/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASTNode
implements TreeNode {
    private static final Logger log = LoggerFactory.getLogger(ASTNode.class);
    private final ASTNode parent;
    private final ExprNode exprNode;
    private final ArrayList children = new ArrayList(2);

    public ASTNode(ASTNode parent, ExprNode exprNode) {
        this.exprNode = exprNode;
        this.parent = parent == null ? this : parent;
        try {
            if (exprNode.isLeaf()) {
                return;
            }
            BranchNode branch = (BranchNode)exprNode;
            List exprNodes = branch.getChildren();
            for (int ii = 0; ii < exprNodes.size(); ++ii) {
                ExprNode child = (ExprNode)exprNodes.get(ii);
                this.children.add(new ASTNode(this, child));
            }
        }
        catch (Exception e) {
            log.warn("Unexpected exception: parent=" + parent + ", exprNode=" + exprNode, (Throwable)e);
        }
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return !this.exprNode.isLeaf();
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode child) {
        return this.children.indexOf(child);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.children.size() <= 0;
    }

    public String toString() {
        return this.exprNode.toString();
    }

    public ExprNode getExprNode() {
        return this.exprNode;
    }
}

