/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.security.PermitAll;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.common.utils.i18n.Labeler;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.api.security.UserEntry;
import org.nuxeo.ecm.core.api.security.UserVisiblePermission;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.security.PermissionActionListManager;
import org.nuxeo.ecm.webapp.security.PermissionListManager;
import org.nuxeo.ecm.webapp.security.PrincipalListManager;
import org.nuxeo.ecm.webapp.security.SecurityActions;
import org.nuxeo.ecm.webapp.security.SecurityData;
import org.nuxeo.ecm.webapp.security.SecurityDataConverter;
import org.nuxeo.ecm.webapp.security.UIPermissionService;
import org.nuxeo.ecm.webapp.table.cell.AbstractTableCell;
import org.nuxeo.ecm.webapp.table.cell.IconTableCell;
import org.nuxeo.ecm.webapp.table.cell.PermissionsTableCell;
import org.nuxeo.ecm.webapp.table.cell.SelectionTableCell;
import org.nuxeo.ecm.webapp.table.cell.UserTableCell;
import org.nuxeo.ecm.webapp.table.header.CheckBoxColHeader;
import org.nuxeo.ecm.webapp.table.header.TableColHeader;
import org.nuxeo.ecm.webapp.table.model.UserPermissionsTableModel;
import org.nuxeo.ecm.webapp.table.row.UserPermissionsTableRow;
import org.nuxeo.runtime.api.Framework;

@Name(value="securityActions")
@Scope(value=ScopeType.CONVERSATION)
public class SecurityActionsBean
extends InputController
implements SecurityActions,
Serializable {
    private static final long serialVersionUID = -7190826911734958662L;
    private static final Log log = LogFactory.getLog(SecurityActionsBean.class);
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected PermissionActionListManager permissionActionListManager;
    @In(create=true)
    protected PermissionListManager permissionListManager;
    @In(create=true)
    protected PrincipalListManager principalListManager;
    @In(create=true)
    protected transient UserManager userManager;
    @In(create=true)
    protected NuxeoPrincipal currentUser;
    protected static final String[] SEED_PERMISSIONS_TO_CHECK = new String[]{"WriteSecurity", "ReadSecurity"};
    private static final Labeler labeler = new Labeler("label.security.permission");
    protected String[] CACHED_PERMISSION_TO_CHECK;
    protected SecurityData securityData;
    protected boolean obsoleteSecurityData = true;
    protected UserPermissionsTableModel tableModel;
    protected transient List<String> cachedValidatedUserAndGroups;
    protected transient List<String> cachedDeletedUserAndGroups;
    private Boolean blockRightInheritance;
    protected String selectedEntry;
    protected List<String> selectedEntries;

    @Override
    @Observer(value={"userAllDocumentTypesSelectionChanged"}, create=false)
    @BypassInterceptors
    public void resetSecurityData() {
        this.obsoleteSecurityData = true;
        this.blockRightInheritance = null;
    }

    @Override
    public void rebuildSecurityData() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        try {
            if (null != currentDocument) {
                ACP acp;
                if (null == this.securityData) {
                    this.securityData = new SecurityData();
                    this.securityData.setDocumentType(currentDocument.getType());
                }
                if (null != (acp = this.documentManager.getACP(currentDocument.getRef()))) {
                    SecurityDataConverter.convertToSecurityData(acp, this.securityData);
                } else {
                    this.securityData.clear();
                }
                this.reconstructTableModel();
                if (this.blockRightInheritance == null) {
                    this.blockRightInheritance = false;
                }
                this.obsoleteSecurityData = false;
            }
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    @Destroy
    @Remove
    @PermitAll
    public void destroy() {
        log.debug((Object)"Removing Seam action listener...");
    }

    protected UserPermissionsTableModel reconstructTableModel() throws ClientException {
        ArrayList<TableColHeader> headers = new ArrayList<TableColHeader>();
        TableColHeader header = new CheckBoxColHeader("label.content.header.selection", "c0", false);
        headers.add(header);
        header = new TableColHeader("label.content.header.type", "c4");
        headers.add(header);
        header = new TableColHeader("label.username", "c1");
        headers.add(header);
        header = new TableColHeader("label.security.grantedPerms", "c2");
        headers.add(header);
        header = new TableColHeader("label.security.deniedPerms", "c3");
        headers.add(header);
        ArrayList<UserPermissionsTableRow> rows = new ArrayList<UserPermissionsTableRow>();
        for (String user : this.getCurrentDocumentUsers()) {
            UserPermissionsTableRow row = this.createDataTableRow(user);
            if (row == null) continue;
            rows.add(row);
        }
        this.tableModel = new UserPermissionsTableModel((List<TableColHeader>)headers, (List<UserPermissionsTableRow>)rows);
        return this.tableModel;
    }

    protected UserPermissionsTableRow createDataTableRow(String user) throws ClientException {
        List<String> deniedPerms;
        ArrayList<AbstractTableCell> cells = new ArrayList<AbstractTableCell>();
        if (user.equals("Everyone") && (deniedPerms = this.securityData.getCurrentDocDeny().get(user)) != null && deniedPerms.contains("Everything")) {
            this.blockRightInheritance = true;
            return null;
        }
        cells.add(new SelectionTableCell(false));
        String principalType = this.principalListManager.getPrincipalType(user);
        IconTableCell iconTableCell = new IconTableCell(this.getIconPathMap().get(principalType));
        iconTableCell.setIconAlt(this.getIconAltMap().get(principalType));
        cells.add(iconTableCell);
        cells.add(new UserTableCell(user, principalType));
        cells.add(new PermissionsTableCell(user, this.securityData.getCurrentDocGrant().get(user)));
        cells.add(new PermissionsTableCell(user, this.securityData.getCurrentDocDeny().get(user)));
        return new UserPermissionsTableRow(user, cells);
    }

    @Override
    public UserPermissionsTableModel getDataTableModel() throws ClientException {
        if (this.obsoleteSecurityData) {
            this.rebuildSecurityData();
        }
        return this.tableModel;
    }

    @Override
    public SecurityData getSecurityData() throws ClientException {
        if (this.obsoleteSecurityData) {
            this.rebuildSecurityData();
        }
        return this.securityData;
    }

    @Override
    public String updateSecurityOnDocument() throws ClientException {
        try {
            List<UserEntry> modifiableEntries = SecurityDataConverter.convertToUserEntries(this.securityData);
            ACP acp = this.currentDocument.getACP();
            if (null == acp) {
                acp = new ACPImpl();
            }
            acp.setRules(modifiableEntries.toArray(new UserEntry[0]));
            this.currentDocument.setACP(acp, true);
            this.documentManager.save();
            Events.instance().raiseEvent("documentSecurityChanged", new Object[0]);
            this.rebuildSecurityData();
            return null;
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public String addPermission(String principalName, String permissionName, boolean grant) throws ClientException {
        boolean removed;
        if (this.securityData == null) {
            try {
                this.securityData = this.getSecurityData();
            }
            catch (ClientException e) {
                log.error((Object)e);
                return null;
            }
        }
        String grantPerm = permissionName;
        String denyPerm = permissionName;
        List<UserVisiblePermission> uvps = this.getVisibleUserPermissions(this.securityData.getDocumentType());
        if (uvps != null) {
            for (UserVisiblePermission uvp : uvps) {
                if (!uvp.getId().equals(permissionName)) continue;
                grantPerm = uvp.getPermission();
                denyPerm = uvp.getDenyPermission();
                break;
            }
        } else {
            log.debug((Object)"no entry for documentType in visibleUserPermissions this should never happend, using default mapping ...");
        }
        if (grant) {
            removed = this.securityData.removeModifiablePrivilege(principalName, denyPerm, !grant);
            if (!removed) {
                removed = this.securityData.removeModifiablePrivilege(principalName, grantPerm, !grant);
            }
            if (!removed) {
                this.securityData.addModifiablePrivilege(principalName, grantPerm, grant);
            }
        } else {
            removed = this.securityData.removeModifiablePrivilege(principalName, grantPerm, !grant);
            if (!removed) {
                removed = this.securityData.removeModifiablePrivilege(principalName, denyPerm, !grant);
            }
            if (!removed) {
                this.securityData.addModifiablePrivilege(principalName, denyPerm, grant);
            }
        }
        try {
            this.reconstructTableModel();
        }
        catch (ClientException e) {
            log.error((Object)"Error whil reconstructing security data", (Throwable)e);
        }
        return null;
    }

    @Override
    public String addPermission() throws ClientException {
        String permissionName = this.permissionListManager.getSelectedPermission();
        boolean grant = this.permissionActionListManager.getSelectedGrant().equals("Grant");
        return this.addPermission(this.selectedEntry, permissionName, grant);
    }

    @Override
    public String addPermissions() throws ClientException {
        if (this.selectedEntries == null || this.selectedEntries.isEmpty()) {
            String message = ComponentUtils.translate((FacesContext)FacesContext.getCurrentInstance(), (String)"error.rightsManager.noUsersSelected");
            FacesMessages.instance().add(message, new Object[0]);
            return null;
        }
        String permissionName = this.permissionListManager.getSelectedPermission();
        boolean grant = this.permissionActionListManager.getSelectedGrant().equals("Grant");
        for (String principalName : this.selectedEntries) {
            this.addPermission(principalName, permissionName, grant);
        }
        return null;
    }

    @Override
    public String addPermissionAndUpdate() throws ClientException {
        this.addPermission();
        this.updateSecurityOnDocument();
        return null;
    }

    @Override
    public String addPermissionsAndUpdate() throws ClientException {
        this.addPermissions();
        this.updateSecurityOnDocument();
        this.selectedEntries = null;
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("message.updated.rights"), new Object[0]);
        return null;
    }

    @Override
    public String saveSecurityUpdates() throws ClientException {
        this.updateSecurityOnDocument();
        this.selectedEntries = null;
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("message.updated.rights"), new Object[0]);
        return null;
    }

    @Override
    public String removePermission() {
        this.securityData.removeModifiablePrivilege(this.selectedEntry, this.permissionListManager.getSelectedPermission(), this.permissionActionListManager.getSelectedGrant().equals("Grant"));
        try {
            this.reconstructTableModel();
        }
        catch (ClientException e) {
            log.error((Object)"Error whil reconstructing security data", (Throwable)e);
        }
        return null;
    }

    @Override
    public String removePermissionAndUpdate() throws ClientException {
        this.removePermission();
        if (!this.checkPermissions()) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("message.updated.rights"), new Object[0]);
            return null;
        }
        this.updateSecurityOnDocument();
        return null;
    }

    @Override
    public String removePermissions() throws ClientException {
        for (String user : this.getDataTableModel().getSelectedUsers()) {
            this.securityData.removeModifiablePrivilege(user);
            if (this.checkPermissions()) continue;
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("message.error.removeRight"), new Object[0]);
            return null;
        }
        this.reconstructTableModel();
        return null;
    }

    @Override
    public String removePermissionsAndUpdate() throws ClientException {
        for (String user : this.getDataTableModel().getSelectedUsers()) {
            this.securityData.removeModifiablePrivilege(user);
            if (this.checkPermissions()) continue;
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("message.error.removeRight"), new Object[0]);
            return null;
        }
        this.updateSecurityOnDocument();
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("message.updated.rights"), new Object[0]);
        return null;
    }

    @Override
    public boolean getCanAddSecurityRules() throws ClientException {
        return this.documentManager.hasPermission(this.currentDocument.getRef(), "WriteSecurity");
    }

    @Override
    public boolean getCanRemoveSecurityRules() throws ClientException {
        try {
            return this.documentManager.hasPermission(this.currentDocument.getRef(), "WriteSecurity") && !this.getDataTableModel().getSelectedRows().isEmpty();
        }
        catch (Exception e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<UserVisiblePermission> getVisibleUserPermissions(String documentType) throws ClientException {
        try {
            return ((PermissionProvider)Framework.getLocalService(PermissionProvider.class)).getUserVisiblePermissionDescriptors(documentType);
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ClientException("Unable to get PermissionProvider", t);
        }
    }

    @Override
    public List<SelectItem> getSettablePermissions() throws ClientException {
        String documentType = this.navigationContext.getCurrentDocument().getType();
        UIPermissionService service = (UIPermissionService)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.webapp.security.UIPermissionService"));
        String[] settablePermissions = service.getUIPermissions(documentType);
        if (settablePermissions == null || settablePermissions.length == 0) {
            List<UserVisiblePermission> visiblePerms = this.getVisibleUserPermissions(documentType);
            settablePermissions = new String[visiblePerms.size()];
            int idx = 0;
            for (UserVisiblePermission uvp : visiblePerms) {
                settablePermissions[idx] = uvp.getId();
                ++idx;
            }
        }
        ArrayList<SelectItem> permissions = new ArrayList<SelectItem>();
        for (String perm : settablePermissions) {
            String label = labeler.makeLabel(perm);
            SelectItem it = new SelectItem((Object)perm, (String)this.resourcesAccessor.getMessages().get(label));
            permissions.add(it);
        }
        return permissions;
    }

    @PrePassivate
    public void saveState() {
        log.info((Object)"PrePassivate");
    }

    @PostActivate
    public void readState() {
        log.info((Object)"PostActivate");
    }

    @Override
    public Map<String, String> getIconAltMap() {
        return this.principalListManager.iconAlt;
    }

    @Override
    public Map<String, String> getIconPathMap() {
        return this.principalListManager.iconPath;
    }

    @Override
    public Boolean getBlockRightInheritance() {
        return this.blockRightInheritance;
    }

    @Override
    public void setBlockRightInheritance(Boolean blockRightInheritance) throws ClientException {
        if (blockRightInheritance.booleanValue()) {
            this.securityData.addModifiablePrivilege("Everyone", "Everything", false);
            Principal currentUser = FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
            if (this.securityData.getCurrentDocumentUsers() != null && !this.securityData.getCurrentDocumentUsers().contains(currentUser.getName())) {
                this.securityData.addModifiablePrivilege(currentUser.getName(), "Everything", true);
                List adminGroups = this.userManager.getAdministratorsGroups();
                for (String adminGroup : adminGroups) {
                    this.securityData.addModifiablePrivilege(adminGroup, "Everything", true);
                }
            }
        } else {
            this.securityData.removeModifiablePrivilege("Everyone", "Everything", false);
        }
        this.updateSecurityOnDocument();
        this.resetSecurityData();
    }

    @Override
    public Boolean displayInheritedPermissions() throws ClientException {
        return this.getDisplayInheritedPermissions();
    }

    @Override
    public boolean getDisplayInheritedPermissions() throws ClientException {
        if (this.blockRightInheritance == null) {
            this.rebuildSecurityData();
        }
        if (this.blockRightInheritance.booleanValue()) {
            return false;
        }
        return !this.securityData.getParentDocumentsUsers().isEmpty();
    }

    @Override
    public List<String> getCurrentDocumentUsers() throws ClientException {
        List<String> currentUsers = this.securityData.getCurrentDocumentUsers();
        return this.validateUserGroupList(currentUsers);
    }

    @Override
    public List<String> getParentDocumentsUsers() throws ClientException {
        List<String> parentUsers = this.securityData.getParentDocumentsUsers();
        return this.validateUserGroupList(parentUsers);
    }

    private List<String> validateUserGroupList(List<String> usersGroups2Validate) throws ClientException {
        ArrayList<String> returnList = new ArrayList<String>();
        for (String entry : usersGroups2Validate) {
            if (entry.equals("Everyone")) {
                returnList.add(entry);
                continue;
            }
            if (this.isUserGroupInCache(entry).booleanValue()) {
                returnList.add(entry);
                continue;
            }
            if (this.isUserGroupInDeletedCache(entry).booleanValue()) continue;
            if (this.userManager.getPrincipal(entry) != null) {
                returnList.add(entry);
                this.addUserGroupInCache(entry);
                continue;
            }
            if (this.userManager.getGroup(entry) != null) {
                returnList.add(entry);
                this.addUserGroupInCache(entry);
                continue;
            }
            this.addUserGroupInDeletedCache(entry);
        }
        return returnList;
    }

    private Boolean isUserGroupInCache(String entry) {
        if (this.cachedValidatedUserAndGroups == null) {
            return false;
        }
        return this.cachedValidatedUserAndGroups.contains(entry);
    }

    private void addUserGroupInCache(String entry) {
        if (this.cachedValidatedUserAndGroups == null) {
            this.cachedValidatedUserAndGroups = new ArrayList<String>();
        }
        this.cachedValidatedUserAndGroups.add(entry);
    }

    private Boolean isUserGroupInDeletedCache(String entry) {
        if (this.cachedDeletedUserAndGroups == null) {
            return false;
        }
        return this.cachedDeletedUserAndGroups.contains(entry);
    }

    private void addUserGroupInDeletedCache(String entry) {
        if (this.cachedDeletedUserAndGroups == null) {
            this.cachedDeletedUserAndGroups = new ArrayList<String>();
        }
        this.cachedDeletedUserAndGroups.add(entry);
    }

    private boolean checkPermissions() throws ClientException {
        ArrayList<String> principals = new ArrayList<String>();
        principals.add(this.currentUser.getName());
        principals.addAll(this.currentUser.getAllGroups());
        ACP acp = this.currentDocument.getACP();
        new SecurityDataConverter();
        List<UserEntry> modifiableEntries = SecurityDataConverter.convertToUserEntries(this.securityData);
        if (null == acp) {
            acp = new ACPImpl();
        }
        acp.setRules(modifiableEntries.toArray(new UserEntry[0]));
        boolean access = acp.getAccess(principals.toArray(new String[0]), this.getPermissionsToCheck()).toBoolean();
        if (!access) {
            this.rebuildSecurityData();
        }
        return access;
    }

    protected String[] getPermissionsToCheck() throws ClientException {
        if (this.CACHED_PERMISSION_TO_CHECK == null) {
            try {
                PermissionProvider pprovider = (PermissionProvider)Framework.getService(PermissionProvider.class);
                LinkedList<String> aggregatedPerms = new LinkedList<String>();
                for (String seedPerm : SEED_PERMISSIONS_TO_CHECK) {
                    aggregatedPerms.add(seedPerm);
                    String[] compoundPerms = pprovider.getPermissionGroups(seedPerm);
                    if (compoundPerms == null) continue;
                    aggregatedPerms.addAll(Arrays.asList(compoundPerms));
                }
                this.CACHED_PERMISSION_TO_CHECK = aggregatedPerms.toArray(new String[aggregatedPerms.size()]);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
        return this.CACHED_PERMISSION_TO_CHECK;
    }

    @Override
    public String getSelectedEntry() {
        return this.selectedEntry;
    }

    @Override
    public void setSelectedEntry(String selectedEntry) {
        this.selectedEntry = selectedEntry;
    }

    @Override
    public List<String> getSelectedEntries() {
        return this.selectedEntries;
    }

    @Override
    public void setSelectedEntries(List<String> selectedEntries) {
        this.selectedEntries = selectedEntries;
    }
}

