/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyManagerImpl
implements HierarchyManager {
    private static Logger log = LoggerFactory.getLogger((Class)HierarchyManagerImpl.class);
    private static final Name EMPTY_NAME = NameFactoryImpl.getInstance().create("", "");
    protected final NodeId rootNodeId;
    protected final ItemStateManager provider;
    protected final PathResolver resolver;

    public HierarchyManagerImpl(NodeId rootNodeId, ItemStateManager provider, PathResolver resolver) {
        this.rootNodeId = rootNodeId;
        this.provider = provider;
        this.resolver = resolver;
    }

    public NodeId getRootNodeId() {
        return this.rootNodeId;
    }

    public String safeGetJCRPath(Path path) {
        try {
            return this.resolver.getJCRPath(path);
        }
        catch (NamespaceException e) {
            log.error("failed to convert {} to a JCR path", (Object)path);
            return path.toString();
        }
    }

    public String safeGetJCRPath(ItemId id) {
        try {
            return this.safeGetJCRPath(this.getPath(id));
        }
        catch (RepositoryException re) {
            log.error(id + ": failed to determine path to");
            return id.toString();
        }
    }

    private ItemId resolvePath(Path path, ItemState state, int next, boolean denotesNode) throws ItemStateException {
        this.beforeResolvePath(path, state, next);
        Path.Element[] elements = path.getElements();
        if (elements.length == next) {
            return state.getId();
        }
        Path.Element elem = elements[next];
        Name name = elem.getName();
        int index = elem.getIndex();
        if (index == 0) {
            index = 1;
        }
        NodeState parentState = (NodeState)state;
        if (next == elements.length - 1) {
            if (denotesNode) {
                if (parentState.hasChildNodeEntry(name, index)) {
                    NodeState.ChildNodeEntry nodeEntry = this.getChildNodeEntry(parentState, name, index);
                    return nodeEntry.getId();
                }
            } else if (parentState.hasPropertyName(name) && index <= 1) {
                return new PropertyId(parentState.getNodeId(), name);
            }
            return null;
        }
        if (parentState.hasChildNodeEntry(name, index)) {
            NodeState.ChildNodeEntry nodeEntry = this.getChildNodeEntry(parentState, name, index);
            NodeId childId = nodeEntry.getId();
            return this.resolvePath(path, this.getItemState(childId), next + 1, denotesNode);
        }
        return null;
    }

    protected ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        return this.provider.getItemState(id);
    }

    protected boolean hasItemState(ItemId id) {
        return this.provider.hasItemState(id);
    }

    protected NodeId getParentId(ItemState state) {
        return state.getParentId();
    }

    protected NodeState.ChildNodeEntry getChildNodeEntry(NodeState parent, NodeId id) {
        return parent.getChildNodeEntry(id);
    }

    protected NodeState.ChildNodeEntry getChildNodeEntry(NodeState parent, Name name, int index) {
        return parent.getChildNodeEntry(name, index);
    }

    protected ItemId resolvePath(Path path, ItemId id, int next, boolean denotesNode) throws RepositoryException {
        try {
            return this.resolvePath(path, this.getItemState(id), next, denotesNode);
        }
        catch (NoSuchItemStateException e) {
            String msg = "failed to retrieve state of intermediary node";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
        catch (ItemStateException e) {
            String msg = "failed to retrieve state of intermediary node";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
    }

    protected void beforeResolvePath(Path path, ItemState state, int next) {
    }

    protected void buildPath(PathBuilder builder, ItemState state) throws ItemStateException, RepositoryException {
        if (state.getId().equals(this.rootNodeId)) {
            builder.addRoot();
            return;
        }
        NodeId parentId = this.getParentId(state);
        if (parentId == null) {
            String msg = "failed to build path of " + state.getId() + ": orphaned item";
            log.debug(msg);
            throw new ItemNotFoundException(msg);
        }
        NodeState parent = (NodeState)this.getItemState(parentId);
        this.buildPath(builder, parent);
        if (state.isNode()) {
            NodeState nodeState = (NodeState)state;
            NodeId id = nodeState.getNodeId();
            NodeState.ChildNodeEntry entry = this.getChildNodeEntry(parent, id);
            if (entry == null) {
                String msg = "failed to build path of " + state.getId() + ": " + parent.getNodeId() + " has no child entry for " + id;
                log.debug(msg);
                throw new ItemNotFoundException(msg);
            }
            if (entry.getIndex() == 1) {
                builder.addLast(entry.getName());
            } else {
                builder.addLast(entry.getName(), entry.getIndex());
            }
        } else {
            PropertyState propState = (PropertyState)state;
            Name name = propState.getName();
            builder.addLast(name);
        }
    }

    public ItemId resolvePath(Path path) throws RepositoryException {
        if (path.denotesRoot()) {
            return this.rootNodeId;
        }
        if (!path.isCanonical()) {
            String msg = "path is not canonical";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        ItemId id = this.resolvePath(path, this.rootNodeId, 1, true);
        return id != null ? id : this.resolvePath(path, this.rootNodeId, 1, false);
    }

    public NodeId resolveNodePath(Path path) throws RepositoryException {
        return (NodeId)this.resolvePath(path, this.rootNodeId, 1, true);
    }

    public PropertyId resolvePropertyPath(Path path) throws RepositoryException {
        return (PropertyId)this.resolvePath(path, this.rootNodeId, 1, false);
    }

    public Path getPath(ItemId id) throws ItemNotFoundException, RepositoryException {
        if (id.equals(this.rootNodeId)) {
            return PathFactoryImpl.getInstance().getRootPath();
        }
        PathBuilder builder = new PathBuilder();
        try {
            this.buildPath(builder, this.getItemState(id));
            return builder.getPath();
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "failed to build path of " + id;
            log.debug(msg);
            throw new ItemNotFoundException(msg, (Throwable)((Object)nsise));
        }
        catch (ItemStateException ise) {
            String msg = "failed to build path of " + id;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)ise));
        }
        catch (MalformedPathException mpe) {
            String msg = "failed to build path of " + id;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
    }

    public Name getName(ItemId itemId) throws ItemNotFoundException, RepositoryException {
        if (itemId.denotesNode()) {
            NodeState parentState;
            NodeId nodeId = (NodeId)itemId;
            try {
                NodeState nodeState = (NodeState)this.getItemState(nodeId);
                NodeId parentId = this.getParentId(nodeState);
                if (parentId == null) {
                    return EMPTY_NAME;
                }
                parentState = (NodeState)this.getItemState(parentId);
            }
            catch (NoSuchItemStateException nsis) {
                String msg = "failed to resolve name of " + nodeId;
                log.debug(msg);
                throw new ItemNotFoundException(nodeId.toString());
            }
            catch (ItemStateException ise) {
                String msg = "failed to resolve name of " + nodeId;
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)((Object)ise));
            }
            NodeState.ChildNodeEntry entry = this.getChildNodeEntry(parentState, nodeId);
            if (entry == null) {
                String msg = "failed to resolve name of " + nodeId;
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            return entry.getName();
        }
        return ((PropertyId)itemId).getName();
    }

    public int getDepth(ItemId id) throws ItemNotFoundException, RepositoryException {
        if (id.equals(this.rootNodeId)) {
            return 0;
        }
        try {
            ItemState state = this.getItemState(id);
            NodeId parentId = this.getParentId(state);
            int depth = 0;
            while (parentId != null) {
                ++depth;
                state = this.getItemState(parentId);
                parentId = this.getParentId(state);
            }
            return depth;
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "failed to determine depth of " + id;
            log.debug(msg);
            throw new ItemNotFoundException(msg, (Throwable)((Object)nsise));
        }
        catch (ItemStateException ise) {
            String msg = "failed to determine depth of " + id;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)ise));
        }
    }

    public int getRelativeDepth(NodeId ancestorId, ItemId descendantId) throws ItemNotFoundException, RepositoryException {
        if (ancestorId.equals(descendantId)) {
            return 0;
        }
        int depth = 1;
        try {
            ItemState state = this.getItemState(descendantId);
            NodeId parentId = this.getParentId(state);
            while (parentId != null) {
                if (parentId.equals(ancestorId)) {
                    return depth;
                }
                ++depth;
                state = this.getItemState(parentId);
                parentId = this.getParentId(state);
            }
            return -1;
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "failed to determine depth of " + descendantId + " relative to " + ancestorId;
            log.debug(msg);
            throw new ItemNotFoundException(msg, (Throwable)((Object)nsise));
        }
        catch (ItemStateException ise) {
            String msg = "failed to determine depth of " + descendantId + " relative to " + ancestorId;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)ise));
        }
    }

    public boolean isAncestor(NodeId nodeId, ItemId itemId) throws ItemNotFoundException, RepositoryException {
        if (nodeId.equals(itemId)) {
            return false;
        }
        try {
            ItemState state = this.getItemState(itemId);
            NodeId parentId = this.getParentId(state);
            while (parentId != null) {
                if (parentId.equals(nodeId)) {
                    return true;
                }
                state = this.getItemState(parentId);
                parentId = this.getParentId(state);
            }
            return false;
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "failed to determine degree of relationship of " + nodeId + " and " + itemId;
            log.debug(msg);
            throw new ItemNotFoundException(msg, (Throwable)((Object)nsise));
        }
        catch (ItemStateException ise) {
            String msg = "failed to determine degree of relationship of " + nodeId + " and " + itemId;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)ise));
        }
    }
}

