/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemPathUtil;
import org.apache.jackrabbit.core.fs.RandomAccessOutputStream;
import org.apache.jackrabbit.core.fs.db.DbFileSystem;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseFileSystem
implements FileSystem {
    private static Logger log = LoggerFactory.getLogger((Class)DbFileSystem.class);
    protected static final String SCHEMA_OBJECT_PREFIX_VARIABLE = "${schemaObjectPrefix}";
    protected boolean initialized = false;
    protected String schema = "default";
    protected String schemaObjectPrefix = "";
    protected static final int INITIAL_BUFFER_SIZE = 8192;
    protected Connection con;
    protected static final int SLEEP_BEFORE_RECONNECT = 10000;
    private HashMap preparedStatements = new HashMap();
    protected String selectExistSQL;
    protected String selectFileExistSQL;
    protected String selectFolderExistSQL;
    protected String selectChildCountSQL;
    protected String selectDataSQL;
    protected String selectLastModifiedSQL;
    protected String selectLengthSQL;
    protected String selectFileNamesSQL;
    protected String selectFolderNamesSQL;
    protected String selectFileAndFolderNamesSQL;
    protected String deleteFileSQL;
    protected String deleteFolderSQL;
    protected String insertFileSQL;
    protected String insertFolderSQL;
    protected String updateDataSQL;
    protected String updateLastModifiedSQL;
    protected String copyFileSQL;
    protected String copyFilesSQL;

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix.toUpperCase();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DatabaseFileSystem) {
            DatabaseFileSystem other = (DatabaseFileSystem)obj;
            if ((this.schema != null ? this.schema.equals(other.schema) : other.schema == null) && (this.schemaObjectPrefix != null ? this.schemaObjectPrefix.equals(other.schemaObjectPrefix) : other.schemaObjectPrefix == null)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public void init() throws FileSystemException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        try {
            this.initConnection();
            this.prepareSchemaObjectPrefix();
            this.checkSchema();
            this.buildSQLStatements();
            this.initPreparedStatements();
            this.verifyRootExists();
            this.initialized = true;
        }
        catch (Exception e) {
            String msg = "failed to initialize file system";
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
    }

    public void close() throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            Iterator it = this.preparedStatements.values().iterator();
            while (it.hasNext()) {
                this.closeStatement((PreparedStatement)it.next());
            }
            this.preparedStatements.clear();
            this.closeConnection(this.con);
        }
        catch (SQLException e) {
            String msg = "error closing file system";
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
        finally {
            this.initialized = false;
        }
    }

    public void createFolder(String folderPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (this.exists(folderPath)) {
            throw new FileSystemException("file system entry already exists: " + folderPath);
        }
        this.createDeepFolder(folderPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        String parentDir = FileSystemPathUtil.getParentDir(filePath);
        String name = FileSystemPathUtil.getName(filePath);
        int count = 0;
        String string = this.deleteFileSQL;
        synchronized (string) {
            try {
                Statement stmt = this.executeStmt(this.deleteFileSQL, new Object[]{parentDir, name});
                count = stmt.getUpdateCount();
            }
            catch (SQLException e) {
                String msg = "failed to delete file: " + filePath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, e);
            }
        }
        if (count == 0) {
            throw new FileSystemException("no such file: " + filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFolder(String folderPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (folderPath.equals("/")) {
            throw new FileSystemException("cannot delete root");
        }
        String parentDir = FileSystemPathUtil.getParentDir(folderPath);
        String name = FileSystemPathUtil.getName(folderPath);
        int count = 0;
        String string = this.deleteFolderSQL;
        synchronized (string) {
            try {
                Statement stmt = this.executeStmt(this.deleteFolderSQL, new Object[]{parentDir, name, folderPath, folderPath + "/" + "%"});
                count = stmt.getUpdateCount();
            }
            catch (SQLException e) {
                String msg = "failed to delete folder: " + folderPath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, e);
            }
        }
        if (count == 0) {
            throw new FileSystemException("no such folder: " + folderPath);
        }
    }

    public boolean exists(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        String parentDir = FileSystemPathUtil.getParentDir(path);
        String name = FileSystemPathUtil.getName(path);
        String string = this.selectExistSQL;
        synchronized (string) {
            boolean bl;
            ResultSet rs = null;
            try {
                Statement stmt = this.executeStmt(this.selectExistSQL, new Object[]{parentDir, name});
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to check existence of file system entry: " + path;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    public boolean isFile(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        String parentDir = FileSystemPathUtil.getParentDir(path);
        String name = FileSystemPathUtil.getName(path);
        String string = this.selectFileExistSQL;
        synchronized (string) {
            boolean bl;
            ResultSet rs = null;
            try {
                Statement stmt = this.executeStmt(this.selectFileExistSQL, new Object[]{parentDir, name});
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to check existence of file: " + path;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    public boolean isFolder(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        String parentDir = FileSystemPathUtil.getParentDir(path);
        String name = FileSystemPathUtil.getName(path);
        String string = this.selectFolderExistSQL;
        synchronized (string) {
            boolean bl;
            ResultSet rs = null;
            try {
                Statement stmt = this.executeStmt(this.selectFolderExistSQL, new Object[]{parentDir, name});
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to check existence of folder: " + path;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    public long lastModified(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        String parentDir = FileSystemPathUtil.getParentDir(path);
        String name = FileSystemPathUtil.getName(path);
        String string = this.selectLastModifiedSQL;
        synchronized (string) {
            long l;
            ResultSet rs = null;
            try {
                Statement stmt = this.executeStmt(this.selectLastModifiedSQL, new Object[]{parentDir, name});
                rs = stmt.getResultSet();
                if (!rs.next()) {
                    throw new FileSystemException("no such file system entry: " + path);
                }
                l = rs.getLong(1);
                this.closeResultSet(rs);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to determine lastModified of file system entry: " + path;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            return l;
        }
    }

    public long length(String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        String parentDir = FileSystemPathUtil.getParentDir(filePath);
        String name = FileSystemPathUtil.getName(filePath);
        String string = this.selectLengthSQL;
        synchronized (string) {
            long l;
            ResultSet rs = null;
            try {
                Statement stmt = this.executeStmt(this.selectLengthSQL, new Object[]{parentDir, name});
                rs = stmt.getResultSet();
                if (!rs.next()) {
                    throw new FileSystemException("no such file: " + filePath);
                }
                l = rs.getLong(1);
                this.closeResultSet(rs);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to determine length of file: " + filePath;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        if (!this.exists(path)) {
            throw new FileSystemException("no such file system entry: " + path);
        }
        String string = this.selectChildCountSQL;
        synchronized (string) {
            boolean bl;
            ResultSet rs;
            block10: {
                rs = null;
                Statement stmt = this.executeStmt(this.selectChildCountSQL, new Object[]{path});
                rs = stmt.getResultSet();
                if (rs.next()) break block10;
                boolean bl2 = false;
                this.closeResultSet(rs);
                return bl2;
            }
            try {
                int count = rs.getInt(1);
                if (FileSystemPathUtil.denotesRoot(path)) {
                    --count;
                }
                bl = count > 0;
                this.closeResultSet(rs);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to determine child count of file system entry: " + path;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    public String[] list(String folderPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (!this.isFolder(folderPath)) {
            throw new FileSystemException("no such folder: " + folderPath);
        }
        String string = this.selectFileAndFolderNamesSQL;
        synchronized (string) {
            String[] stringArray;
            ResultSet rs = null;
            try {
                Statement stmt = this.executeStmt(this.selectFileAndFolderNamesSQL, new Object[]{folderPath});
                rs = stmt.getResultSet();
                ArrayList<String> names = new ArrayList<String>();
                while (rs.next()) {
                    String name = rs.getString(1);
                    if (name.length() == 0 && FileSystemPathUtil.denotesRoot(folderPath)) continue;
                    names.add(name);
                }
                stringArray = names.toArray(new String[names.size()]);
                this.closeResultSet(rs);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to list child entries of folder: " + folderPath;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            return stringArray;
        }
    }

    public String[] listFiles(String folderPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (!this.isFolder(folderPath)) {
            throw new FileSystemException("no such folder: " + folderPath);
        }
        String string = this.selectFileNamesSQL;
        synchronized (string) {
            String[] stringArray;
            ResultSet rs = null;
            try {
                Statement stmt = this.executeStmt(this.selectFileNamesSQL, new Object[]{folderPath});
                rs = stmt.getResultSet();
                ArrayList<String> names = new ArrayList<String>();
                while (rs.next()) {
                    names.add(rs.getString(1));
                }
                stringArray = names.toArray(new String[names.size()]);
                this.closeResultSet(rs);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to list file entries of folder: " + folderPath;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            return stringArray;
        }
    }

    public String[] listFolders(String folderPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (!this.isFolder(folderPath)) {
            throw new FileSystemException("no such folder: " + folderPath);
        }
        String string = this.selectFolderNamesSQL;
        synchronized (string) {
            String[] stringArray;
            ResultSet rs = null;
            try {
                Statement stmt = this.executeStmt(this.selectFolderNamesSQL, new Object[]{folderPath});
                rs = stmt.getResultSet();
                ArrayList<String> names = new ArrayList<String>();
                while (rs.next()) {
                    String name = rs.getString(1);
                    if (name.length() == 0 && FileSystemPathUtil.denotesRoot(folderPath)) continue;
                    names.add(name);
                }
                stringArray = names.toArray(new String[names.size()]);
                this.closeResultSet(rs);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to list folder entries of folder: " + folderPath;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        String parentDir = FileSystemPathUtil.getParentDir(filePath);
        String name = FileSystemPathUtil.getName(filePath);
        int count = 0;
        String string = this.updateLastModifiedSQL;
        synchronized (string) {
            try {
                Statement stmt = this.executeStmt(this.updateLastModifiedSQL, new Object[]{new Long(System.currentTimeMillis()), parentDir, name});
                count = stmt.getUpdateCount();
            }
            catch (SQLException e) {
                String msg = "failed to touch file: " + filePath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, e);
            }
        }
        if (count == 0) {
            throw new FileSystemException("no such file: " + filePath);
        }
    }

    public InputStream getInputStream(String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        String parentDir = FileSystemPathUtil.getParentDir(filePath);
        String name = FileSystemPathUtil.getName(filePath);
        String string = this.selectDataSQL;
        synchronized (string) {
            try {
                Statement stmt = this.executeStmt(this.selectDataSQL, new Object[]{parentDir, name});
                final ResultSet rs = stmt.getResultSet();
                if (!rs.next()) {
                    throw new FileSystemException("no such file: " + filePath);
                }
                InputStream in = rs.getBinaryStream(1);
                return new FilterInputStream(in){

                    public void close() throws IOException {
                        super.close();
                        DatabaseFileSystem.this.closeResultSet(rs);
                    }
                };
            }
            catch (SQLException e) {
                String msg = "failed to retrieve data of file: " + filePath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, e);
            }
        }
    }

    public OutputStream getOutputStream(final String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        final String parentDir = FileSystemPathUtil.getParentDir(filePath);
        final String name = FileSystemPathUtil.getName(filePath);
        if (!this.isFolder(parentDir)) {
            throw new FileSystemException("path not found: " + parentDir);
        }
        if (this.isFolder(filePath)) {
            throw new FileSystemException("path denotes folder: " + filePath);
        }
        try {
            TransientFileFactory fileFactory = TransientFileFactory.getInstance();
            final File tmpFile = fileFactory.createTransientFile("bin", null, null);
            return new FilterOutputStream(new FileOutputStream(tmpFile)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    block13: {
                        super.close();
                        InputStream in = null;
                        try {
                            if (DatabaseFileSystem.this.isFile(filePath)) {
                                String string = DatabaseFileSystem.this.updateDataSQL;
                                synchronized (string) {
                                    long length = tmpFile.length();
                                    in = new FileInputStream(tmpFile);
                                    DatabaseFileSystem.this.executeStmt(DatabaseFileSystem.this.updateDataSQL, new Object[]{new SizedInputStream(in, length), new Long(System.currentTimeMillis()), new Long(length), parentDir, name});
                                    break block13;
                                }
                            }
                            String string = DatabaseFileSystem.this.insertFileSQL;
                            synchronized (string) {
                                long length = tmpFile.length();
                                in = new FileInputStream(tmpFile);
                                DatabaseFileSystem.this.executeStmt(DatabaseFileSystem.this.insertFileSQL, new Object[]{parentDir, name, new SizedInputStream(in, length), new Long(System.currentTimeMillis()), new Long(length)});
                            }
                        }
                        catch (Exception e) {
                            throw new IOException(e.getMessage());
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                            tmpFile.delete();
                        }
                    }
                }
            };
        }
        catch (Exception e) {
            String msg = "failed to open output stream to file: " + filePath;
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessOutputStream getRandomAccessOutputStream(final String filePath) throws FileSystemException, UnsupportedOperationException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        final String parentDir = FileSystemPathUtil.getParentDir(filePath);
        final String name = FileSystemPathUtil.getName(filePath);
        if (!this.isFolder(parentDir)) {
            throw new FileSystemException("path not found: " + parentDir);
        }
        if (this.isFolder(filePath)) {
            throw new FileSystemException("path denotes folder: " + filePath);
        }
        try {
            TransientFileFactory fileFactory = TransientFileFactory.getInstance();
            final File tmpFile = fileFactory.createTransientFile("bin", null, null);
            if (this.isFile(filePath)) {
                InputStream in = this.getInputStream(filePath);
                FileOutputStream out = new FileOutputStream(tmpFile);
                try {
                    int read;
                    byte[] ba = new byte[8192];
                    while ((read = in.read(ba, 0, ba.length)) != -1) {
                        ((OutputStream)out).write(ba, 0, read);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                    in.close();
                }
            }
            return new RandomAccessOutputStream(){
                private final RandomAccessFile raf;
                {
                    this.raf = new RandomAccessFile(tmpFile, "rw");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    block13: {
                        this.raf.close();
                        InputStream in = null;
                        try {
                            if (DatabaseFileSystem.this.isFile(filePath)) {
                                String string = DatabaseFileSystem.this.updateDataSQL;
                                synchronized (string) {
                                    long length = tmpFile.length();
                                    in = new FileInputStream(tmpFile);
                                    DatabaseFileSystem.this.executeStmt(DatabaseFileSystem.this.updateDataSQL, new Object[]{new SizedInputStream(in, length), new Long(System.currentTimeMillis()), new Long(length), parentDir, name});
                                    break block13;
                                }
                            }
                            String string = DatabaseFileSystem.this.insertFileSQL;
                            synchronized (string) {
                                long length = tmpFile.length();
                                in = new FileInputStream(tmpFile);
                                DatabaseFileSystem.this.executeStmt(DatabaseFileSystem.this.insertFileSQL, new Object[]{parentDir, name, new SizedInputStream(in, length), new Long(System.currentTimeMillis()), new Long(length)});
                            }
                        }
                        catch (Exception e) {
                            throw new IOException(e.getMessage());
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                            tmpFile.delete();
                        }
                    }
                }

                public void seek(long position) throws IOException {
                    this.raf.seek(position);
                }

                public void write(int b) throws IOException {
                    this.raf.write(b);
                }

                public void flush() {
                }

                public void write(byte[] b) throws IOException {
                    this.raf.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    this.raf.write(b, off, len);
                }
            };
        }
        catch (Exception e) {
            String msg = "failed to open output stream to file: " + filePath;
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
    }

    public void copy(String srcPath, String destPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(srcPath);
        FileSystemPathUtil.checkFormat(destPath);
        if (this.isFolder(srcPath)) {
            this.copyDeepFolder(srcPath, destPath);
        } else {
            this.copyFile(srcPath, destPath);
        }
    }

    public void move(String srcPath, String destPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(srcPath);
        FileSystemPathUtil.checkFormat(destPath);
        this.copy(srcPath, destPath);
        if (this.isFile(srcPath)) {
            this.deleteFile(srcPath);
        } else {
            this.deleteFolder(srcPath);
        }
    }

    protected void initConnection() throws Exception {
        this.con = this.getConnection();
        if (!this.con.getAutoCommit()) {
            this.con.setAutoCommit(true);
        }
    }

    protected Connection getConnection() throws Exception {
        throw new UnsupportedOperationException("Override in a subclass!");
    }

    protected void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    protected synchronized boolean reestablishConnection() {
        Iterator it = this.preparedStatements.values().iterator();
        while (it.hasNext()) {
            this.closeStatement((PreparedStatement)it.next());
        }
        try {
            this.closeConnection(this.con);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        try {
            this.initConnection();
            this.initPreparedStatements();
            return true;
        }
        catch (Exception e) {
            log.error("failed to re-establish connection", (Throwable)e);
            return false;
        }
    }

    protected Statement executeStmt(String sql, Object[] params) throws SQLException {
        int trials = 2;
        block2: while (true) {
            PreparedStatement stmt = (PreparedStatement)this.preparedStatements.get(sql);
            try {
                for (int i = 0; i < params.length; ++i) {
                    if (params[i] instanceof SizedInputStream) {
                        SizedInputStream in = (SizedInputStream)params[i];
                        stmt.setBinaryStream(i + 1, (InputStream)in, (int)in.getSize());
                        continue;
                    }
                    stmt.setObject(i + 1, params[i]);
                }
                stmt.execute();
                this.resetStatement(stmt);
                return stmt;
            }
            catch (SQLException se) {
                if (--trials == 0) {
                    throw se;
                }
                log.warn("execute failed, about to reconnect...", (Object)se.getMessage());
                if (this.reestablishConnection()) {
                    int i = 0;
                    while (true) {
                        SizedInputStream in;
                        if (i >= params.length) continue block2;
                        if (params[i] instanceof SizedInputStream && (in = (SizedInputStream)params[i]).isConsumed()) {
                            throw se;
                        }
                        ++i;
                    }
                }
                throw se;
            }
            break;
        }
    }

    protected void prepareSchemaObjectPrefix() throws Exception {
        DatabaseMetaData metaData = this.con.getMetaData();
        String legalChars = metaData.getExtraNameCharacters();
        legalChars = legalChars + "ABCDEFGHIJKLMNOPQRSTUVWXZY0123456789_";
        String prefix = this.schemaObjectPrefix.toUpperCase();
        StringBuffer escaped = new StringBuffer();
        for (int i = 0; i < prefix.length(); ++i) {
            char c = prefix.charAt(i);
            if (legalChars.indexOf(c) == -1) {
                escaped.append("_x");
                String hex = Integer.toHexString(c);
                escaped.append("0000".toCharArray(), 0, 4 - hex.length());
                escaped.append(hex);
                escaped.append("_");
                continue;
            }
            escaped.append(c);
        }
        this.schemaObjectPrefix = escaped.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSchema() throws Exception {
        boolean schemaExists;
        DatabaseMetaData metaData = this.con.getMetaData();
        String tableName = this.schemaObjectPrefix + "FSENTRY";
        if (metaData.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        } else if (metaData.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        }
        ResultSet rs = metaData.getTables(null, null, tableName, null);
        try {
            schemaExists = rs.next();
        }
        finally {
            rs.close();
        }
        if (!schemaExists) {
            InputStream in = DatabaseFileSystem.class.getResourceAsStream(this.schema + ".ddl");
            if (in == null) {
                String msg = "Configuration error: unknown schema '" + this.schema + "'";
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            Statement stmt = this.con.createStatement();
            try {
                String sql = reader.readLine();
                while (sql != null) {
                    if (!sql.startsWith("#") && sql.length() > 0) {
                        sql = Text.replace((String)sql, (String)SCHEMA_OBJECT_PREFIX_VARIABLE, (String)this.schemaObjectPrefix);
                        stmt.executeUpdate(sql);
                    }
                    sql = reader.readLine();
                }
            }
            finally {
                this.closeStream(in);
                this.closeStatement(stmt);
            }
        }
    }

    protected void buildSQLStatements() {
        this.insertFileSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, ?, ?, ?, ?)";
        this.insertFolderSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, ?, ?, 0)";
        this.updateDataSQL = "update " + this.schemaObjectPrefix + "FSENTRY " + "set FSENTRY_DATA = ?, FSENTRY_LASTMOD = ?, FSENTRY_LENGTH = ? " + "where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_DATA is not null";
        this.updateLastModifiedSQL = "update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_LASTMOD = ? " + "where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_DATA is not null";
        this.selectExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ?";
        this.selectFileExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.selectFolderExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is null";
        this.selectFileNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_DATA is not null";
        this.selectFolderNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_DATA is null";
        this.selectFileAndFolderNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?";
        this.selectChildCountSQL = "select count(FSENTRY_NAME) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?  ";
        this.selectDataSQL = "select FSENTRY_DATA from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.selectLastModifiedSQL = "select FSENTRY_LASTMOD from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ?";
        this.selectLengthSQL = "select FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.deleteFileSQL = "delete from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.deleteFolderSQL = "delete from " + this.schemaObjectPrefix + "FSENTRY where " + "(FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is null) " + "or (FSENTRY_PATH = ?) " + "or (FSENTRY_PATH like ?) ";
        this.copyFileSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "select ?, ?, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.copyFilesSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "select ?, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_DATA is not null";
    }

    protected void initPreparedStatements() throws SQLException {
        this.preparedStatements.put(this.selectExistSQL, this.con.prepareStatement(this.selectExistSQL));
        this.preparedStatements.put(this.selectFileExistSQL, this.con.prepareStatement(this.selectFileExistSQL));
        this.preparedStatements.put(this.selectFolderExistSQL, this.con.prepareStatement(this.selectFolderExistSQL));
        this.preparedStatements.put(this.selectChildCountSQL, this.con.prepareStatement(this.selectChildCountSQL));
        this.preparedStatements.put(this.selectDataSQL, this.con.prepareStatement(this.selectDataSQL));
        this.preparedStatements.put(this.selectLastModifiedSQL, this.con.prepareStatement(this.selectLastModifiedSQL));
        this.preparedStatements.put(this.selectLengthSQL, this.con.prepareStatement(this.selectLengthSQL));
        this.preparedStatements.put(this.selectFileNamesSQL, this.con.prepareStatement(this.selectFileNamesSQL));
        this.preparedStatements.put(this.selectFolderNamesSQL, this.con.prepareStatement(this.selectFolderNamesSQL));
        this.preparedStatements.put(this.selectFileAndFolderNamesSQL, this.con.prepareStatement(this.selectFileAndFolderNamesSQL));
        this.preparedStatements.put(this.deleteFileSQL, this.con.prepareStatement(this.deleteFileSQL));
        this.preparedStatements.put(this.deleteFolderSQL, this.con.prepareStatement(this.deleteFolderSQL));
        this.preparedStatements.put(this.insertFileSQL, this.con.prepareStatement(this.insertFileSQL));
        this.preparedStatements.put(this.insertFolderSQL, this.con.prepareStatement(this.insertFolderSQL));
        this.preparedStatements.put(this.updateDataSQL, this.con.prepareStatement(this.updateDataSQL));
        this.preparedStatements.put(this.updateLastModifiedSQL, this.con.prepareStatement(this.updateLastModifiedSQL));
        this.preparedStatements.put(this.copyFileSQL, this.con.prepareStatement(this.copyFileSQL));
        this.preparedStatements.put(this.copyFilesSQL, this.con.prepareStatement(this.copyFilesSQL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyRootExists() throws Exception {
        String string = this.selectFolderExistSQL;
        synchronized (string) {
            ResultSet rs;
            block7: {
                rs = null;
                try {
                    Statement stmt = this.executeStmt(this.selectFolderExistSQL, new Object[]{"/", ""});
                    rs = stmt.getResultSet();
                    if (!rs.next()) break block7;
                    this.closeResultSet(rs);
                }
                catch (SQLException e) {
                    try {
                        String msg = "failed to check existence of file system root entry";
                        log.error(msg, (Throwable)e);
                        throw new FileSystemException(msg, e);
                    }
                    catch (Throwable throwable) {
                        this.closeResultSet(rs);
                        throw throwable;
                    }
                }
                return;
            }
            this.closeResultSet(rs);
        }
        this.createDeepFolder("/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDeepFolder(String folderPath) throws FileSystemException {
        String parentDir = FileSystemPathUtil.getParentDir(folderPath);
        String name = FileSystemPathUtil.getName(folderPath);
        if (!FileSystemPathUtil.denotesRoot(folderPath) && !this.exists(parentDir)) {
            this.createDeepFolder(parentDir);
        }
        String string = this.insertFolderSQL;
        synchronized (string) {
            try {
                this.executeStmt(this.insertFolderSQL, new Object[]{parentDir, name, new Long(System.currentTimeMillis())});
            }
            catch (SQLException e) {
                String msg = "failed to create folder entry: " + folderPath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDeepFolder(String srcPath, String destPath) throws FileSystemException {
        if (!this.exists(destPath)) {
            this.createDeepFolder(destPath);
        }
        String[] names = this.listFolders(srcPath);
        for (int i = 0; i < names.length; ++i) {
            String src = FileSystemPathUtil.denotesRoot(srcPath) ? srcPath + names[i] : srcPath + "/" + names[i];
            String dest = FileSystemPathUtil.denotesRoot(destPath) ? destPath + names[i] : destPath + "/" + names[i];
            this.copyDeepFolder(src, dest);
        }
        String string = this.copyFilesSQL;
        synchronized (string) {
            try {
                this.executeStmt(this.copyFilesSQL, new Object[]{destPath, srcPath});
            }
            catch (SQLException e) {
                String msg = "failed to copy file entries from " + srcPath + " to " + destPath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(String srcPath, String destPath) throws FileSystemException {
        String srcParentDir = FileSystemPathUtil.getParentDir(srcPath);
        String srcName = FileSystemPathUtil.getName(srcPath);
        String destParentDir = FileSystemPathUtil.getParentDir(destPath);
        String destName = FileSystemPathUtil.getName(destPath);
        if (!this.exists(destParentDir)) {
            this.createDeepFolder(destParentDir);
        }
        if (this.isFile(destPath)) {
            this.deleteFile(destPath);
        }
        int count = 0;
        String string = this.copyFileSQL;
        synchronized (string) {
            try {
                Statement stmt = this.executeStmt(this.copyFileSQL, new Object[]{destParentDir, destName, srcParentDir, srcName});
                count = stmt.getUpdateCount();
            }
            catch (SQLException e) {
                String msg = "failed to copy file from " + srcPath + " to " + destPath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, e);
            }
        }
        if (count == 0) {
            throw new FileSystemException("no such file: " + srcPath);
        }
    }

    protected void resetStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.clearParameters();
                stmt.clearWarnings();
            }
            catch (SQLException se) {
                log.error("failed resetting PreparedStatement", (Throwable)se);
            }
        }
    }

    protected void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException se) {
                log.error("failed closing ResultSet", (Throwable)se);
            }
        }
    }

    protected void closeStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException se) {
                log.error("failed closing Statement", (Throwable)se);
            }
        }
    }

    class SizedInputStream
    extends FilterInputStream {
        private final long size;
        private boolean consumed;

        SizedInputStream(InputStream in, long size) {
            super(in);
            this.consumed = false;
            this.size = size;
        }

        long getSize() {
            return this.size;
        }

        boolean isConsumed() {
            return this.consumed;
        }

        public int read() throws IOException {
            this.consumed = true;
            return super.read();
        }

        public long skip(long n) throws IOException {
            this.consumed = true;
            return super.skip(n);
        }

        public int read(byte[] b) throws IOException {
            this.consumed = true;
            return super.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.consumed = true;
            return super.read(b, off, len);
        }
    }
}

