/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeIdIterator;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.ExecutablePreparedQuery;
import org.apache.jackrabbit.core.query.OnWorkspaceInconsistency;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.qom.QueryObjectModelTree;
import org.apache.jackrabbit.core.state.NodeStateIterator;

public abstract class AbstractQueryHandler
implements QueryHandler {
    private QueryHandlerContext context;
    private OnWorkspaceInconsistency owi = OnWorkspaceInconsistency.FAIL;

    public final void init(QueryHandlerContext context) throws IOException {
        this.context = context;
        this.doInit();
    }

    protected abstract void doInit() throws IOException;

    public QueryHandlerContext getContext() {
        return this.context;
    }

    public synchronized void updateNodes(NodeIdIterator remove, NodeStateIterator add) throws RepositoryException, IOException {
        while (remove.hasNext()) {
            this.deleteNode(remove.nextNodeId());
        }
        while (add.hasNext()) {
            this.addNode(add.nextNodeState());
        }
    }

    public ExecutablePreparedQuery createExecutablePreparedQuery(SessionImpl session, ItemManager itemMgr, QueryObjectModelTree qomTree) throws InvalidQueryException {
        throw new UnsupportedOperationException("This query handler does not support prepared queries");
    }

    public OnWorkspaceInconsistency getOnWorkspaceInconsistencyHandler() {
        return this.owi;
    }

    public void setOnWorkspaceInconsistency(String name) {
        this.owi = OnWorkspaceInconsistency.fromString(name);
    }

    public String getOnWorkspaceInconsistency() {
        return this.owi.getName();
    }
}

