/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.core.query.lucene.NamePathResolverImpl;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.namespace.AbstractNamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedNamespaceMappings
extends AbstractNamespaceResolver
implements NamespaceMappings {
    private static Logger log = LoggerFactory.getLogger((Class)NamespaceMappings.class);
    private final File storage;
    private final NameResolver nameResolver;
    private Map prefixToURI = new HashMap();
    private Map uriToPrefix = new HashMap();
    private int prefixCount;

    public FileBasedNamespaceMappings(File file) throws IOException {
        this.storage = file;
        this.load();
        this.nameResolver = NamePathResolverImpl.create(this);
    }

    public synchronized String getURI(String prefix) throws NamespaceException {
        if (!this.prefixToURI.containsKey(prefix)) {
            throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
        }
        return (String)this.prefixToURI.get(prefix);
    }

    public synchronized String getPrefix(String uri) throws NamespaceException {
        String prefix = (String)this.uriToPrefix.get(uri);
        if (prefix == null) {
            while (this.prefixToURI.get(String.valueOf(this.prefixCount)) != null) {
                ++this.prefixCount;
            }
            prefix = String.valueOf(this.prefixCount);
            this.prefixToURI.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
            log.debug("adding new namespace mapping: " + prefix + " -> " + uri);
            try {
                this.store();
            }
            catch (IOException e) {
                throw new NamespaceException("Could not obtain a prefix for uri: " + uri, (Throwable)e);
            }
        }
        return prefix;
    }

    public String translatePropertyName(Name qName) throws IllegalNameException {
        try {
            return this.nameResolver.getJCRName(qName);
        }
        catch (NamespaceException e) {
            throw new IllegalNameException("Internal error.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        if (this.storage.exists()) {
            FileInputStream in = new FileInputStream(this.storage);
            try {
                Properties props = new Properties();
                log.debug("loading namespace mappings...");
                props.load(in);
                Iterator<Object> iter = props.keySet().iterator();
                while (iter.hasNext()) {
                    String prefix = (String)iter.next();
                    String uri = props.getProperty(prefix);
                    log.debug(prefix + " -> " + uri);
                    this.prefixToURI.put(prefix, uri);
                    this.uriToPrefix.put(uri, prefix);
                }
                this.prefixCount = props.size();
                log.debug("namespace mappings loaded.");
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws IOException {
        Properties props = new Properties();
        Iterator iter = this.prefixToURI.keySet().iterator();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            String uri = (String)this.prefixToURI.get(prefix);
            props.setProperty(prefix, uri);
        }
        OutputStream out = new FileOutputStream(this.storage);
        try {
            out = new BufferedOutputStream(out);
            props.store(out, null);
        }
        finally {
            out.close();
        }
    }
}

