/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;

class NamespaceContext
implements NamespaceResolver {
    private final NamespaceContext parent;
    private final Map prefixToURI;
    private final Map uriToPrefix;

    public NamespaceContext(NamespaceContext parent, Map mappings) {
        this.parent = parent;
        this.prefixToURI = new HashMap();
        this.uriToPrefix = new HashMap();
        Iterator iterator = mappings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry mapping = iterator.next();
            this.prefixToURI.put(mapping.getKey(), mapping.getValue());
            this.uriToPrefix.put(mapping.getValue(), mapping.getKey());
        }
    }

    public NamespaceContext getParent() {
        return this.parent;
    }

    public String getURI(String prefix) throws NamespaceException {
        String uri = (String)this.prefixToURI.get(prefix);
        if (uri != null) {
            return uri;
        }
        if (this.parent != null) {
            return this.parent.getURI(prefix);
        }
        throw new NamespaceException("Unknown prefix: " + prefix);
    }

    public String getPrefix(String uri) throws NamespaceException {
        String prefix = (String)this.uriToPrefix.get(uri);
        if (prefix != null) {
            return prefix;
        }
        if (this.parent != null) {
            return this.parent.getPrefix(uri);
        }
        throw new NamespaceException("Unknown URI: " + uri);
    }
}

