/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ui.wizard;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.validation.Form;
import org.nuxeo.ecm.webengine.forms.validation.ValidationException;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.ui.wizard.WizardPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardSession
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected Object data;
    protected ValidationException error;
    protected WizardPage lastPage;
    protected Map<String, WizardPage> pages;
    protected WizardPage[] orderedPages;

    public WizardSession(String wizardId, WizardPage[] pages) {
        if (pages == null || pages.length == 0) {
            throw new WebException("Wizard has no pages!");
        }
        this.id = wizardId;
        this.lastPage = pages[0];
        this.pages = new HashMap<String, WizardPage>();
        for (int i = 0; i < pages.length; ++i) {
            WizardPage p = pages[i];
            p.setIndex(i);
            this.pages.put(p.getId(), p);
        }
        this.orderedPages = pages;
    }

    public WizardPage pushPage(String pageId) {
        WizardPage page = this.pages.get(pageId);
        if (page == null) {
            throw new WebResourceNotFoundException("No such wizard page: " + pageId);
        }
        if (this.lastPage == null) {
            this.lastPage = page;
        } else {
            page.prev = this.lastPage;
            this.lastPage = page;
        }
        return page;
    }

    public WizardPage popPage() {
        if (this.lastPage == null) {
            return null;
        }
        WizardPage page = this.lastPage;
        this.lastPage = page.prev;
        page.prev = null;
        return page;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public WizardPage getPage() {
        return this.lastPage;
    }

    public WizardPage getPage(String id) {
        return this.pages.get(id);
    }

    public String getPageAt(int index) {
        return index < this.orderedPages.length ? this.orderedPages[index].getId() : null;
    }

    public String getId() {
        return this.id;
    }

    public void setError(ValidationException e) {
        this.error = e;
    }

    public ValidationException removeError() {
        ValidationException e = this.error;
        this.error = null;
        return e;
    }

    public <T extends Form> T getForm(Class<T> formType) {
        WizardPage p = this.lastPage;
        while (p != null) {
            if (formType == p.getFormType()) {
                return (T)p.getForm();
            }
            p = p.prev;
        }
        return null;
    }
}

