/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jbpm;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;

public class AbstractWorkflowOperation {
    protected String getI18nLabel(String label, Locale locale) {
        if (label == null) {
            label = "";
        }
        return I18NUtils.getMessageString((String)"messages", (String)label, null, (Locale)locale);
    }

    protected String getDocumentLink(DocumentViewCodecManager documentViewCodecManager, DocumentModel doc, boolean includeWorkflowTab) throws ClientException {
        String viewId = this.getDefaultViewFor(doc);
        HashMap parameters = Maps.newHashMap();
        if (includeWorkflowTab) {
            parameters.put("tabId", "TAB_CONTENT_JBPM");
        }
        DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)new DocumentLocationImpl(doc), viewId, (Map)parameters);
        return documentViewCodecManager.getUrlFromDocumentView("docpath", (DocumentView)docView, false, null);
    }

    protected String getDefaultViewFor(DocumentModel doc) {
        TypeInfo type = (TypeInfo)doc.getAdapter(TypeInfo.class);
        if (type == null) {
            return null;
        }
        return type.getDefaultView();
    }
}

