/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactory;
import org.nuxeo.ecm.directory.DirectoryFactoryDescriptor;
import org.nuxeo.ecm.directory.DirectoryFactoryProxy;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class DirectoryServiceImpl
extends DefaultComponent
implements DirectoryService {
    private static final Log log = LogFactory.getLog(DirectoryServiceImpl.class);
    private Map<String, DirectoryFactory> factories;
    private Map<String, List<DirectoryFactory>> factoriesByDirectoryName;

    public void applicationStarted(ComponentContext context) throws Exception {
        if (Framework.isTestModeSet()) {
            return;
        }
        for (Directory dir : this.getDirectories()) {
            dir.getName();
        }
    }

    public Directory getDirectory(String name) throws DirectoryException {
        DirectoryFactory factory;
        List<DirectoryFactory> potentialFactories = this.factoriesByDirectoryName.get(name);
        if (potentialFactories == null) {
            return null;
        }
        Directory dir = null;
        Iterator<DirectoryFactory> i$ = potentialFactories.iterator();
        while (i$.hasNext() && null == (dir = (factory = i$.next()).getDirectory(name))) {
        }
        return dir;
    }

    private Directory getDirectoryOrFail(String name) throws DirectoryException {
        Directory dir = this.getDirectory(name);
        if (null == dir) {
            throw new DirectoryException(String.format("no directory registered with name '%s'", name));
        }
        return dir;
    }

    public List<Directory> getDirectories() throws DirectoryException {
        ArrayList<Directory> directoryList = new ArrayList<Directory>();
        for (DirectoryFactory factory : this.factories.values()) {
            List list = factory.getDirectories();
            directoryList.addAll(list);
        }
        return directoryList;
    }

    public void activate(ComponentContext context) throws Exception {
        this.factories = new HashMap<String, DirectoryFactory>();
        this.factoriesByDirectoryName = new HashMap<String, List<DirectoryFactory>>();
    }

    public void deactivate(ComponentContext context) throws Exception {
        for (DirectoryFactory factory : this.factories.values()) {
            factory.shutdown();
        }
        this.factories = null;
        this.factoriesByDirectoryName = null;
    }

    public void registerExtension(Extension extension) throws Exception {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            DirectoryFactoryDescriptor factoryDescriptor = (DirectoryFactoryDescriptor)contrib;
            String factoryName = factoryDescriptor.getFactoryName();
            this.factories.put(factoryName, new DirectoryFactoryProxy(factoryName));
            log.debug((Object)("registered factory: " + factoryName));
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            DirectoryFactoryDescriptor factoryDescriptor = (DirectoryFactoryDescriptor)contrib;
            String factoryName = factoryDescriptor.getFactoryName();
            DirectoryFactory factoryToRemove = this.factories.get(factoryName);
            if (factoryToRemove == null) {
                log.warn((Object)("factory: " + factoryName + "was not registered"));
                return;
            }
            factoryToRemove.shutdown();
            for (List<DirectoryFactory> potentialFactories : this.factoriesByDirectoryName.values()) {
                potentialFactories.remove(factoryToRemove);
            }
            this.factories.remove(factoryName);
            log.debug((Object)("unregistered factory: " + factoryName));
        }
    }

    public void registerDirectory(String directoryName, DirectoryFactory factory) {
        List<DirectoryFactory> existingFactories = this.factoriesByDirectoryName.get(directoryName);
        if (existingFactories == null) {
            existingFactories = new ArrayList<DirectoryFactory>();
            this.factoriesByDirectoryName.put(directoryName, existingFactories);
        }
        existingFactories.remove(factory);
        existingFactories.add(0, factory);
    }

    public void unregisterDirectory(String directoryName, DirectoryFactory factory) {
        List<DirectoryFactory> existingFactories = this.factoriesByDirectoryName.get(directoryName);
        if (existingFactories != null) {
            existingFactories.remove(factory);
        }
    }

    public List<String> getDirectoryNames() throws DirectoryException {
        List<Directory> directories = this.getDirectories();
        ArrayList<String> directoryNames = new ArrayList<String>();
        for (Directory directory : directories) {
            directoryNames.add(directory.getName());
        }
        return directoryNames;
    }

    public String getDirectorySchema(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getSchema();
    }

    public String getDirectoryIdField(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getIdField();
    }

    public String getDirectoryPasswordField(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getPasswordField();
    }

    public Session open(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getSession();
    }

    public String getParentDirectoryName(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getParentDirectory();
    }
}

