/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.taskmgmt.exe;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.instantiation.Delegation;
import org.jbpm.instantiation.UserCodeInterceptorConfig;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.security.SecurityHelper;
import org.jbpm.svc.Services;
import org.jbpm.taskmgmt.TaskInstanceFactory;
import org.jbpm.taskmgmt.def.AssignmentHandler;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.jbpm.taskmgmt.exe.Assignable;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.log.TaskCreateLog;
import org.jbpm.util.Clock;

public class TaskMgmtInstance
extends ModuleInstance {
    private static final long serialVersionUID = 1L;
    TaskMgmtDefinition taskMgmtDefinition = null;
    Map swimlaneInstances = null;
    Set taskInstances = null;
    Collection taskInstanceVariableUpdates = null;

    public TaskMgmtInstance() {
    }

    public TaskMgmtInstance(TaskMgmtDefinition taskMgmtDefinition) {
        this.taskMgmtDefinition = taskMgmtDefinition;
    }

    public TaskInstance createTaskInstance() {
        return this.createTaskInstance(null, (ExecutionContext)null);
    }

    public TaskInstance createTaskInstance(Task task) {
        return this.createTaskInstance(task, (ExecutionContext)null);
    }

    public TaskInstance createTaskInstance(Token token) {
        return this.createTaskInstance(null, new ExecutionContext(token));
    }

    public TaskInstance createTaskInstance(Task task, Token token) {
        ExecutionContext executionContext = new ExecutionContext(token);
        executionContext.setTask(task);
        return this.createTaskInstance(task, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInstance createTaskInstance(Task task, ExecutionContext executionContext) {
        TaskInstance taskInstance = this.instantiateNewTaskInstance(executionContext);
        this.addTaskInstance(taskInstance);
        if (task != null) {
            taskInstance.setTask(task);
        }
        Services.assignId(taskInstance);
        if (executionContext != null) {
            Token token = executionContext.getToken();
            taskInstance.setToken(token);
            taskInstance.setProcessInstance(token.getProcessInstance());
            taskInstance.initializeVariables();
            if (task != null && task.getDueDate() != null) {
                Date dueDate;
                Date baseDate;
                String dueDateString = task.getDueDate();
                String durationString = null;
                if (dueDateString.startsWith("#")) {
                    String baseDateEL = dueDateString.substring(0, dueDateString.indexOf("}") + 1);
                    Object result = JbpmExpressionEvaluator.evaluate(baseDateEL, executionContext);
                    if (result instanceof Date) {
                        baseDate = (Date)result;
                    } else if (result instanceof Calendar) {
                        baseDate = ((Calendar)result).getTime();
                    } else {
                        throw new JbpmException("Invalid basedate type: " + baseDateEL + " is of type " + result.getClass().getName() + ". Only Date and Calendar are supported");
                    }
                    int endOfELIndex = dueDateString.indexOf("}");
                    if (endOfELIndex < dueDateString.length() - 1) {
                        char durationSeparator = dueDateString.substring(endOfELIndex + 1).trim().charAt(0);
                        if (durationSeparator != '+' && durationSeparator != '-') {
                            throw new JbpmException("Invalid duedate, + or - missing after EL");
                        }
                        durationString = dueDateString.substring(endOfELIndex + 1).trim();
                    }
                } else {
                    baseDate = Clock.getCurrentTime();
                    durationString = dueDateString;
                }
                if (durationString == null || durationString.length() == 0) {
                    dueDate = baseDate;
                } else {
                    BusinessCalendar businessCalendar = new BusinessCalendar();
                    dueDate = businessCalendar.add(baseDate, new Duration(durationString));
                }
                taskInstance.setDueDate(dueDate);
            }
            try {
                Object result;
                String description;
                executionContext.setTask(task);
                executionContext.setTaskInstance(taskInstance);
                executionContext.setEventSource(task);
                if (task != null && (description = task.getDescription()) != null && description.indexOf("#{") != -1 && (result = JbpmExpressionEvaluator.evaluate(description, executionContext)) != null) {
                    taskInstance.setDescription(result.toString());
                }
                taskInstance.create(executionContext);
                if (task != null) {
                    taskInstance.assign(executionContext);
                }
            }
            finally {
                executionContext.setTask(null);
                executionContext.setTaskInstance(null);
                executionContext.setEventSource(null);
            }
            token.addLog(new TaskCreateLog(taskInstance, taskInstance.getActorId()));
        } else {
            taskInstance.create();
        }
        return taskInstance;
    }

    public SwimlaneInstance getInitializedSwimlaneInstance(ExecutionContext executionContext, Swimlane swimlane) {
        SwimlaneInstance swimlaneInstance;
        if (this.swimlaneInstances == null) {
            this.swimlaneInstances = new HashMap();
        }
        if ((swimlaneInstance = (SwimlaneInstance)this.swimlaneInstances.get(swimlane.getName())) == null) {
            swimlaneInstance = new SwimlaneInstance(swimlane);
            this.addSwimlaneInstance(swimlaneInstance);
            this.performAssignment(swimlane.getAssignmentDelegation(), swimlane.getActorIdExpression(), swimlane.getPooledActorsExpression(), swimlaneInstance, executionContext);
        }
        return swimlaneInstance;
    }

    public void performAssignment(Delegation assignmentDelegation, String actorIdExpression, String pooledActorsExpression, Assignable assignable, ExecutionContext executionContext) {
        try {
            if (assignmentDelegation != null) {
                this.performAssignmentDelegation(assignmentDelegation, assignable, executionContext);
            } else {
                if (actorIdExpression != null) {
                    this.performAssignmentActorIdExpr(actorIdExpression, assignable, executionContext);
                }
                if (pooledActorsExpression != null) {
                    this.performAssignmentPooledActorsExpr(pooledActorsExpression, assignable, executionContext);
                }
            }
        }
        catch (Exception exception) {
            GraphElement graphElement = executionContext.getEventSource();
            if (graphElement != null) {
                graphElement.raiseException(exception, executionContext);
            }
            throw new DelegationException(exception, executionContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performAssignmentDelegation(Delegation assignmentDelegation, Assignable assignable, ExecutionContext executionContext) throws Exception {
        ClassLoader surroundingClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JbpmConfiguration.getProcessClassLoader(executionContext.getProcessDefinition()));
            AssignmentHandler assignmentHandler = (AssignmentHandler)assignmentDelegation.instantiate();
            if (UserCodeInterceptorConfig.userCodeInterceptor != null) {
                UserCodeInterceptorConfig.userCodeInterceptor.executeAssignment(assignmentHandler, assignable, executionContext);
            } else {
                assignmentHandler.assign(assignable, executionContext);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(surroundingClassLoader);
        }
    }

    void performAssignmentActorIdExpr(String actorIdExpression, Assignable assignable, ExecutionContext executionContext) {
        Object result = null;
        String actorId = null;
        try {
            result = JbpmExpressionEvaluator.evaluate(actorIdExpression, executionContext);
            if (result == null) {
                throw new JbpmException("actor-id expression '" + actorIdExpression + "' returned null");
            }
            actorId = (String)result;
        }
        catch (ClassCastException e) {
            throw new JbpmException("actor-id expression '" + actorIdExpression + "' didn't resolve to a java.lang.String: '" + result + "' (" + result.getClass().getName() + ")");
        }
        assignable.setActorId(actorId);
    }

    void performAssignmentPooledActorsExpr(String pooledActorsExpression, Assignable assignable, ExecutionContext executionContext) {
        String[] pooledActors = null;
        Object result = JbpmExpressionEvaluator.evaluate(pooledActorsExpression, executionContext);
        if (result == null) {
            throw new JbpmException("pooled-actors expression '" + pooledActorsExpression + "' returned null");
        }
        if (result instanceof String[]) {
            pooledActors = (String[])result;
        } else if (result instanceof Collection) {
            Collection collection = (Collection)result;
            pooledActors = collection.toArray(new String[collection.size()]);
        } else if (result instanceof String) {
            ArrayList<String> pooledActorList = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer((String)result, ",");
            while (tokenizer.hasMoreTokens()) {
                pooledActorList.add(tokenizer.nextToken().trim());
            }
            pooledActors = pooledActorList.toArray(new String[pooledActorList.size()]);
        } else {
            throw new JbpmException("pooled-actors expression '" + pooledActorsExpression + "' didn't resolve to a comma separated String, a Collection or a String[]: '" + result + "' (" + result.getClass().getName() + ")");
        }
        assignable.setPooledActors(pooledActors);
    }

    public TaskInstance createStartTaskInstance() {
        TaskInstance taskInstance = null;
        Task startTask = this.taskMgmtDefinition.getStartTask();
        if (startTask != null) {
            Token rootToken = this.processInstance.getRootToken();
            ExecutionContext executionContext = new ExecutionContext(rootToken);
            taskInstance = this.createTaskInstance(startTask, executionContext);
            taskInstance.setActorId(SecurityHelper.getAuthenticatedActorId());
        }
        return taskInstance;
    }

    TaskInstance instantiateNewTaskInstance(ExecutionContext executionContext) {
        TaskInstanceFactory taskInstanceFactory = (TaskInstanceFactory)JbpmConfiguration.Configs.getObject("jbpm.task.instance.factory");
        if (taskInstanceFactory == null) {
            throw new JbpmException("jbpm.task.instance.factory was not configured in jbpm.cfg.xml");
        }
        return taskInstanceFactory.createTaskInstance(executionContext);
    }

    public boolean hasBlockingTaskInstances(Token token) {
        boolean hasBlockingTasks = false;
        if (this.taskInstances != null) {
            Iterator iter = this.taskInstances.iterator();
            while (iter.hasNext() && !hasBlockingTasks) {
                TaskInstance taskInstance = (TaskInstance)iter.next();
                if (taskInstance.hasEnded() || !taskInstance.isBlocking() || token == null || !token.equals(taskInstance.getToken())) continue;
                hasBlockingTasks = true;
            }
        }
        return hasBlockingTasks;
    }

    public boolean hasUnfinishedTasks(Token token) {
        return this.getUnfinishedTasks(token).size() > 0;
    }

    public Collection getUnfinishedTasks(Token token) {
        ArrayList<TaskInstance> unfinishedTasks = new ArrayList<TaskInstance>();
        if (this.taskInstances != null) {
            for (TaskInstance task : this.taskInstances) {
                if (task.hasEnded() || token == null || !token.equals(task.getToken())) continue;
                unfinishedTasks.add(task);
            }
        }
        return unfinishedTasks;
    }

    public boolean hasSignallingTasks(ExecutionContext executionContext) {
        return this.getSignallingTasks(executionContext).size() > 0;
    }

    public Collection getSignallingTasks(ExecutionContext executionContext) {
        ArrayList<TaskInstance> signallingTasks = new ArrayList<TaskInstance>();
        if (this.taskInstances != null) {
            for (TaskInstance taskInstance : this.taskInstances) {
                if (!taskInstance.isSignalling() || !executionContext.getToken().equals(taskInstance.getToken())) continue;
                signallingTasks.add(taskInstance);
            }
        }
        return signallingTasks;
    }

    public Collection getTaskInstances() {
        return this.taskInstances;
    }

    public void addTaskInstance(TaskInstance taskInstance) {
        if (this.taskInstances == null) {
            this.taskInstances = new HashSet();
        }
        this.taskInstances.add(taskInstance);
        taskInstance.setTaskMgmtInstance(this);
    }

    public void removeTaskInstance(TaskInstance taskInstance) {
        if (this.taskInstances != null) {
            this.taskInstances.remove(taskInstance);
        }
    }

    public Map getSwimlaneInstances() {
        return this.swimlaneInstances;
    }

    public void addSwimlaneInstance(SwimlaneInstance swimlaneInstance) {
        if (this.swimlaneInstances == null) {
            this.swimlaneInstances = new HashMap();
        }
        this.swimlaneInstances.put(swimlaneInstance.getName(), swimlaneInstance);
        swimlaneInstance.setTaskMgmtInstance(this);
    }

    public SwimlaneInstance getSwimlaneInstance(String swimlaneName) {
        return this.swimlaneInstances != null ? this.swimlaneInstances.get(swimlaneName) : null;
    }

    public SwimlaneInstance createSwimlaneInstance(String swimlaneName) {
        Swimlane swimlane;
        Swimlane swimlane2 = swimlane = this.taskMgmtDefinition != null ? this.taskMgmtDefinition.getSwimlane(swimlaneName) : null;
        if (swimlane != null) {
            return this.createSwimlaneInstance(swimlane);
        }
        throw new JbpmException("couldn't create swimlane instance for non-existing swimlane " + swimlaneName);
    }

    public SwimlaneInstance createSwimlaneInstance(Swimlane swimlane) {
        if (this.swimlaneInstances == null) {
            this.swimlaneInstances = new HashMap();
        }
        SwimlaneInstance swimlaneInstance = new SwimlaneInstance(swimlane);
        try {
            swimlaneInstance.setTaskMgmtInstance(this);
            Class<?> persistentMapClass = this.swimlaneInstances.getClass();
            Field mapField = persistentMapClass.getDeclaredField("map");
            mapField.setAccessible(true);
            this.swimlaneInstances.size();
            this.swimlaneInstances.put(swimlaneInstance.getName(), swimlaneInstance);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return swimlaneInstance;
    }

    public TaskMgmtDefinition getTaskMgmtDefinition() {
        return this.taskMgmtDefinition;
    }

    public void suspend(Token token) {
        if (token == null) {
            throw new JbpmException("can't suspend task instances for token null");
        }
        if (this.taskInstances != null) {
            for (TaskInstance taskInstance : this.taskInstances) {
                if (!token.equals(taskInstance.getToken()) || !taskInstance.isOpen()) continue;
                taskInstance.suspend();
            }
        }
    }

    public void resume(Token token) {
        if (token == null) {
            throw new JbpmException("can't suspend task instances for token null");
        }
        if (this.taskInstances != null) {
            for (TaskInstance taskInstance : this.taskInstances) {
                if (!token.equals(taskInstance.getToken()) || !taskInstance.isOpen()) continue;
                taskInstance.resume();
            }
        }
    }

    void notifyVariableUpdate(TaskInstance taskInstance) {
        if (this.taskInstanceVariableUpdates == null) {
            this.taskInstanceVariableUpdates = new HashSet();
        }
        this.taskInstanceVariableUpdates.add(taskInstance);
    }

    public Collection getTaskInstancesWithVariableUpdates() {
        return this.taskInstanceVariableUpdates;
    }

    public void endAll() {
        if (this.taskInstances != null) {
            for (TaskInstance taskInstance : this.taskInstances) {
                if (taskInstance.hasEnded()) continue;
                taskInstance.end();
            }
        }
    }

    public void removeSignalling(Token token) {
        if (this.taskInstances != null) {
            for (TaskInstance taskInstance : this.taskInstances) {
                if (token == null || !token.equals(taskInstance.getToken())) continue;
                taskInstance.setSignalling(false);
            }
        }
    }
}

