/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.BinaryManagerDescriptor;
import org.nuxeo.ecm.core.storage.sql.BinaryManagerStatus;
import org.nuxeo.ecm.core.storage.sql.BinaryScrambler;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class DefaultBinaryManager
implements BinaryManager {
    private static final Log log = LogFactory.getLog(DefaultBinaryManager.class);
    public static final String DEFAULT_DIGEST = "MD5";
    public static final int DEFAULT_DEPTH = 2;
    public static final String DEFAULT_PATH = "binaries";
    public static final String DATA = "data";
    public static final String TMP = "tmp";
    public static final String CONFIG_FILE = "config.xml";
    protected File storageDir;
    protected File tmpDir;
    protected String repositoryName;
    protected BinaryManagerDescriptor descriptor;
    protected BinaryGarbageCollector garbageCollector;
    public static final int MIN_BUF_SIZE = 8192;
    public static final int MAX_BUF_SIZE = 65536;
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    @Override
    public void initialize(RepositoryDescriptor repositoryDescriptor) throws IOException {
        File base;
        String path = repositoryDescriptor.binaryStorePath;
        if (path == null || path.trim().length() == 0) {
            path = DEFAULT_PATH;
        }
        path = Framework.expandVars((String)path);
        if ((path = path.trim()).startsWith("/") || path.startsWith("\\") || path.contains("://") || path.contains(":\\")) {
            base = new File(path);
        } else {
            File home = Environment.getDefault().getData();
            base = new File(home, path);
            File oldBase = new File(Framework.getRuntime().getHome().getPath(), path);
            if (oldBase.exists()) {
                log.warn((Object)("Old binaries path used (NXP-5370). Please move " + oldBase + " to " + base));
                base = oldBase;
            }
        }
        log.info((Object)("Repository '" + repositoryDescriptor.name + "' using " + (this.getClass().equals(DefaultBinaryManager.class) ? "" : this.getClass().getSimpleName() + " and ") + "binary store: " + base));
        this.storageDir = new File(base, DATA);
        this.tmpDir = new File(base, TMP);
        this.storageDir.mkdirs();
        this.tmpDir.mkdirs();
        this.descriptor = this.getDescriptor(new File(base, CONFIG_FILE));
        this.createGarbageCollector();
    }

    public File getStorageDir() {
        return this.storageDir;
    }

    protected BinaryManagerDescriptor getDescriptor(File configFile) throws IOException {
        BinaryManagerDescriptor desc;
        if (configFile.exists()) {
            XMap xmap = new XMap();
            xmap.register(BinaryManagerDescriptor.class);
            try {
                desc = (BinaryManagerDescriptor)xmap.load((InputStream)new FileInputStream(configFile));
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
        } else {
            desc = new BinaryManagerDescriptor();
            desc.digest = DEFAULT_DIGEST;
            desc.depth = 2;
            desc.write(configFile);
        }
        return desc;
    }

    protected BinaryScrambler getBinaryScrambler() {
        return NullBinaryScrambler.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Binary getBinary(InputStream in) throws IOException {
        File tmp = File.createTempFile("create_", ".tmp", this.tmpDir);
        try {
            String digest;
            FileOutputStream out = new FileOutputStream(tmp);
            try {
                digest = this.storeAndDigest(in, out);
            }
            finally {
                in.close();
                ((OutputStream)out).close();
            }
            File file = this.getFileForDigest(digest, true);
            tmp.renameTo(file);
            if (!file.exists()) {
                throw new IOException("Could not create file: " + file);
            }
            Binary binary = this.getBinaryScrambler().getUnscrambledBinary(file, digest, this.repositoryName);
            return binary;
        }
        finally {
            tmp.delete();
        }
    }

    @Override
    public Binary getBinary(String digest) {
        File file = this.getFileForDigest(digest, false);
        if (file == null || !file.exists()) {
            return null;
        }
        return this.getBinaryScrambler().getUnscrambledBinary(file, digest, this.repositoryName);
    }

    public File getFileForDigest(String digest, boolean createDir) {
        int depth = this.descriptor.depth;
        if (digest.length() < 2 * depth) {
            return null;
        }
        StringBuilder buf = new StringBuilder(3 * depth - 1);
        for (int i = 0; i < depth; ++i) {
            if (i != 0) {
                buf.append(File.separatorChar);
            }
            buf.append(digest.substring(2 * i, 2 * i + 2));
        }
        File dir = new File(this.storageDir, buf.toString());
        if (createDir) {
            dir.mkdirs();
        }
        return new File(dir, digest);
    }

    protected String storeAndDigest(InputStream in, OutputStream out) throws IOException {
        int n;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(this.descriptor.digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw (IOException)new IOException().initCause(e);
        }
        int size = in.available();
        if (size == 0) {
            size = 65536;
        } else if (size < 8192) {
            size = 8192;
        } else if (size > 65536) {
            size = 65536;
        }
        byte[] buf = new byte[size];
        BinaryScrambler scrambler = this.getBinaryScrambler();
        while ((n = in.read(buf)) != -1) {
            scrambler.scrambleBuffer(buf, 0, n);
            digest.update(buf, 0, n);
            out.write(buf, 0, n);
        }
        out.flush();
        return DefaultBinaryManager.toHexString(digest.digest());
    }

    public static String toHexString(byte[] data) {
        StringBuilder buf = new StringBuilder(2 * data.length);
        for (byte b : data) {
            buf.append(HEX_DIGITS[(0xF0 & b) >> 4]);
            buf.append(HEX_DIGITS[0xF & b]);
        }
        return buf.toString();
    }

    protected void createGarbageCollector() {
        this.garbageCollector = new DefaultBinaryGarbageCollector(this);
    }

    @Override
    public BinaryGarbageCollector getGarbageCollector() {
        return this.garbageCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void touch(File file) {
        long time = System.currentTimeMillis();
        if (file.setLastModified(time)) {
            return;
        }
        if (!file.canWrite()) {
            return;
        }
        try {
            RandomAccessFile r = new RandomAccessFile(file, "rw");
            try {
                r.setLength(r.length());
            }
            finally {
                r.close();
            }
        }
        catch (IOException e) {
            log.error((Object)("Cannot set last modified for file: " + file), (Throwable)e);
        }
    }

    public static class DefaultBinaryGarbageCollector
    implements BinaryGarbageCollector {
        public static int TIME_RESOLUTION = 2000;
        protected final DefaultBinaryManager binaryManager;
        protected volatile long startTime;
        protected BinaryManagerStatus status;

        public DefaultBinaryGarbageCollector(DefaultBinaryManager binaryManager) {
            this.binaryManager = binaryManager;
        }

        @Override
        public String getId() {
            return this.binaryManager.getStorageDir().toURI().toString();
        }

        @Override
        public BinaryManagerStatus getStatus() {
            return this.status;
        }

        @Override
        public boolean isInProgress() {
            return this.startTime != 0L;
        }

        @Override
        public void start() {
            if (this.startTime != 0L) {
                throw new RuntimeException("Alread started");
            }
            this.startTime = System.currentTimeMillis();
            this.status = new BinaryManagerStatus();
        }

        @Override
        public void mark(String digest) {
            File file = this.binaryManager.getFileForDigest(digest, false);
            if (!file.exists()) {
                log.error((Object)("Unknown file digest: " + digest));
                return;
            }
            DefaultBinaryManager.touch(file);
        }

        @Override
        public void stop(boolean delete) {
            if (this.startTime == 0L) {
                throw new RuntimeException("Not started");
            }
            this.deleteOld(this.binaryManager.getStorageDir(), this.startTime - (long)TIME_RESOLUTION, 0, delete);
            this.status.gcDuration = System.currentTimeMillis() - this.startTime;
            this.startTime = 0L;
        }

        protected void deleteOld(File file, long minTime, int depth, boolean delete) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    this.deleteOld(f, minTime, depth + 1, delete);
                }
                if (depth > 0 && file.list().length == 0) {
                    file.delete();
                }
            } else if (file.isFile() && file.canWrite()) {
                long lastModified = file.lastModified();
                long length = file.length();
                if (lastModified == 0L) {
                    log.error((Object)("Cannot read last modified for file: " + file));
                } else if (lastModified < minTime) {
                    this.status.sizeBinariesGC += length;
                    ++this.status.numBinariesGC;
                    if (delete && !file.delete()) {
                        log.warn((Object)("Cannot gc file: " + file));
                    }
                } else {
                    this.status.sizeBinaries += length;
                    ++this.status.numBinaries;
                }
            }
        }
    }

    public static class ScrambledFileInputStream
    extends InputStream {
        protected final InputStream is;
        protected final BinaryScrambler scrambler;
        protected final byte[] onebyte = new byte[1];

        protected ScrambledFileInputStream(File file, BinaryScrambler scrambler) throws IOException {
            this.is = new FileInputStream(file);
            this.scrambler = scrambler;
            scrambler.reset();
        }

        @Override
        public int read() throws IOException {
            int b = this.is.read();
            if (b != -1) {
                this.onebyte[0] = (byte)b;
                this.scrambler.unscrambleBuffer(this.onebyte, 0, 1);
                b = this.onebyte[0];
            }
            return b;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.is.read(b, off, len);
            if (n != -1) {
                this.scrambler.unscrambleBuffer(b, off, n);
            }
            return n;
        }

        @Override
        public long skip(long n) throws IOException {
            n = this.is.skip(n);
            this.scrambler.skip(n);
            return n;
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            this.is.close();
        }
    }

    public static class ScrambledStreamSource
    extends FileSource {
        protected final BinaryScrambler scrambler;

        public ScrambledStreamSource(File file, BinaryScrambler scrambler) {
            super(file);
            this.scrambler = scrambler;
        }

        public File getFile() {
            throw new UnsupportedOperationException();
        }

        public InputStream getStream() throws IOException {
            return new ScrambledFileInputStream(this.file, this.scrambler);
        }
    }

    public static class ScrambledBinary
    extends Binary {
        private static final long serialVersionUID = 1L;
        private final File file;
        protected final BinaryScrambler scrambler;

        public ScrambledBinary(File file, String digest, String repoName, BinaryScrambler scrambler) {
            super(file, digest, repoName);
            this.file = file;
            this.scrambler = scrambler;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new ScrambledFileInputStream(this.file, this.scrambler);
        }

        @Override
        public StreamSource getStreamSource() {
            return new ScrambledStreamSource(this.file, this.scrambler);
        }
    }

    public static class NullBinaryScrambler
    implements BinaryScrambler {
        public static final BinaryScrambler INSTANCE = new NullBinaryScrambler();

        @Override
        public void scrambleBuffer(byte[] buf, int off, int n) {
        }

        @Override
        public void unscrambleBuffer(byte[] buf, int off, int n) {
        }

        @Override
        public Binary getUnscrambledBinary(File file, String digest, String repoName) {
            return new Binary(file, digest, repoName);
        }

        @Override
        public void skip(long n) {
        }

        @Override
        public void reset() {
        }
    }
}

