/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types.localconfiguration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.types.localconfiguration.ContentViewConfiguration;

public class ContentViewConfigurationAdapter
implements ContentViewConfiguration {
    private static final Log log = LogFactory.getLog(ContentViewConfigurationAdapter.class);
    protected DocumentRef documentRef;
    protected Map<String, List<String>> typeToContentViewNames;
    protected boolean canMerge = true;

    public ContentViewConfigurationAdapter(DocumentModel doc) {
        this.documentRef = doc.getRef();
        this.typeToContentViewNames = new HashMap<String, List<String>>();
        try {
            List cvNamesByType = (List)((Object)doc.getPropertyValue("cvconf:cvNamesByType"));
            for (Map typeToCv : cvNamesByType) {
                String type = (String)typeToCv.get("docType");
                String cvName = (String)typeToCv.get("contentView");
                if (this.typeToContentViewNames.containsKey(type)) {
                    this.typeToContentViewNames.get(type).add(cvName);
                    continue;
                }
                ArrayList<String> cvNames = new ArrayList<String>();
                cvNames.add(cvName);
                this.typeToContentViewNames.put(type, cvNames);
            }
        }
        catch (ClientException e) {
            log.error((Object)"Failed to get ContentViewConfiguration", (Throwable)e);
        }
    }

    public List<String> getContentViewsForType(String docType) {
        return this.typeToContentViewNames.get(docType);
    }

    public boolean canMerge() {
        return this.canMerge;
    }

    public DocumentRef getDocumentRef() {
        return this.documentRef;
    }

    public ContentViewConfiguration merge(ContentViewConfiguration other) {
        if (other == null) {
            return this;
        }
        this.documentRef = other.getDocumentRef();
        Map t2cv = other.getTypeToContentViewNames();
        for (String type : t2cv.keySet()) {
            if (this.typeToContentViewNames.containsKey(type)) continue;
            this.typeToContentViewNames.put(type, (List<String>)t2cv.get(type));
        }
        return this;
    }

    public Map<String, List<String>> getTypeToContentViewNames() {
        return this.typeToContentViewNames;
    }
}

