/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetTypeDefinitionComparator;
import org.nuxeo.ecm.platform.forms.layout.export.WidgetTypeDefinitions;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.view.TemplateView;
import org.nuxeo.runtime.api.Framework;

@Path(value="layout")
public class WebLayoutResource {
    protected WebLayoutManager service;
    protected final List<WidgetTypeDefinition> widgetTypes;
    protected final Map<String, List<WidgetTypeDefinition>> widgetTypesByCat;

    public WebLayoutResource() throws Exception {
        try {
            this.service = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
            this.widgetTypes = this.service.getWidgetTypeDefinitions();
            Collections.sort(this.widgetTypes, new WidgetTypeDefinitionComparator(true));
            this.widgetTypesByCat = this.getWidgetTypesByCategory();
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to initialize WebLayoutManager", (Throwable)e);
        }
    }

    protected Map<String, List<WidgetTypeDefinition>> getWidgetTypesByCategory() {
        HashMap cats = new HashMap();
        ArrayList<WidgetTypeDefinition> unknownCatWidgets = new ArrayList<WidgetTypeDefinition>();
        for (WidgetTypeDefinition wTypeDef : this.widgetTypes) {
            List categories = null;
            WidgetTypeConfiguration conf = wTypeDef.getConfiguration();
            if (conf != null) {
                categories = conf.getCategories();
            }
            boolean added = false;
            if (categories != null) {
                for (String cat : categories) {
                    ArrayList<WidgetTypeDefinition> list = (ArrayList<WidgetTypeDefinition>)cats.get(cat);
                    if (list == null) {
                        list = new ArrayList<WidgetTypeDefinition>();
                    }
                    list.add(wTypeDef);
                    cats.put(cat, list);
                    added = true;
                }
            }
            if (added) continue;
            unknownCatWidgets.add(wTypeDef);
        }
        if (!unknownCatWidgets.isEmpty()) {
            cats.put("unknown", unknownCatWidgets);
        }
        ArrayList sortedKeys = new ArrayList(cats.keySet());
        Collections.sort(sortedKeys);
        LinkedHashMap<String, List<WidgetTypeDefinition>> res = new LinkedHashMap<String, List<WidgetTypeDefinition>>();
        for (String key : sortedKeys) {
            res.put(key, (List<WidgetTypeDefinition>)cats.get(key));
        }
        return res;
    }

    @GET
    @Path(value="widgetTypes")
    public Object getWidgetTypeDefinitions(@Context HttpServletRequest request, @QueryParam(value="all") Boolean all) {
        return this.getWidgetTypeDefinitions(request, null, null, all);
    }

    @GET
    @Path(value="widgetTypes/{category}")
    public Object getWidgetTypeDefinitions(@Context HttpServletRequest request, @PathParam(value="category") String category, @QueryParam(value="version") String version, @QueryParam(value="all") Boolean all) {
        WidgetTypeDefinitions res = new WidgetTypeDefinitions();
        for (WidgetTypeDefinition def : this.widgetTypes) {
            String confVersion;
            WidgetTypeConfiguration conf = def.getConfiguration();
            if (!Boolean.TRUE.equals(all) && conf == null || version != null && conf != null && (confVersion = conf.getSinceVersion()) != null && version.compareTo(confVersion) < 0) continue;
            if (category != null) {
                List categories;
                boolean hasCats = false;
                if (conf != null && (categories = conf.getCategories()) != null) {
                    hasCats = true;
                    if (categories.contains(category)) {
                        res.add(def);
                    }
                }
                if (hasCats || !"unknown".equals(category)) continue;
                res.add(def);
                continue;
            }
            if (conf == null && !Boolean.TRUE.equals(all)) continue;
            res.add(def);
        }
        return res;
    }

    @GET
    @Path(value="widgetType/{name}")
    public Object getWidgetTypeDefinition(@Context HttpServletRequest request, @PathParam(value="name") String name) {
        WidgetTypeDefinition def = this.service.getWidgetTypeDefinition(name);
        if (def != null) {
            return def;
        }
        return Response.status((int)401).build();
    }

    public TemplateView getTemplate(@Context UriInfo uriInfo) {
        return this.getTemplate("index.ftl", uriInfo);
    }

    @GET
    @Path(value="wiki")
    public Object getWikiDocumentation(@Context UriInfo uriInfo) {
        return this.getTemplate("wiki.ftl", uriInfo);
    }

    protected TemplateView getTemplate(String name, UriInfo uriInfo) {
        String baseURL = uriInfo.getAbsolutePath().toString();
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        return new TemplateView((Object)this, name).arg("categories", this.widgetTypesByCat).arg("widgetTypes", this.widgetTypes).arg("baseURL", (Object)baseURL);
    }

    @GET
    public Object doGet(@QueryParam(value="widgetType") String widgetTypeName, @Context UriInfo uriInfo) {
        if (widgetTypeName == null) {
            return this.getTemplate(uriInfo);
        }
        WidgetTypeDefinition wType = this.service.getWidgetTypeDefinition(widgetTypeName);
        if (wType == null) {
            throw new WebResourceNotFoundException("No widget type found with name: " + widgetTypeName);
        }
        TemplateView tpl = this.getTemplate(uriInfo);
        tpl.arg("widgetType", (Object)wType);
        return tpl;
    }

    public String getWidgetTypeLabel(WidgetTypeDefinition wTypeDef) {
        if (wTypeDef != null) {
            WidgetTypeConfiguration conf = wTypeDef.getConfiguration();
            if (conf != null) {
                return conf.getTitle();
            }
            return wTypeDef.getName();
        }
        return null;
    }

    public String getWidgetTypeDescription(WidgetTypeDefinition wTypeDef) {
        WidgetTypeConfiguration conf;
        if (wTypeDef != null && (conf = wTypeDef.getConfiguration()) != null) {
            return conf.getDescription();
        }
        return null;
    }

    public List<String> getWidgetTypeCategories(WidgetTypeDefinition wTypeDef) {
        WidgetTypeConfiguration conf;
        if (wTypeDef != null && (conf = wTypeDef.getConfiguration()) != null) {
            return conf.getCategories();
        }
        return null;
    }

    public String getWidgetTypeCategoriesAsString(WidgetTypeDefinition wTypeDef) {
        List<String> categories = this.getWidgetTypeCategories(wTypeDef);
        if (categories == null) {
            return "";
        }
        return StringUtils.join(categories, (String)", ");
    }
}

