/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.connect.data.DownloadablePackage;

public class UpdateCheckResult {
    protected boolean requireUpdate = false;
    protected boolean transparentUpdate = false;
    protected List<DownloadablePackage> packagesToRemove = new ArrayList<DownloadablePackage>();
    protected Map<String, Boolean> updatePossible = new HashMap<String, Boolean>();
    protected List<DownloadablePackage> packagesToAdd = new ArrayList<DownloadablePackage>();

    public List<DownloadablePackage> getPackagesToRemove() {
        return this.packagesToRemove;
    }

    public List<DownloadablePackage> getPackagesToAdd() {
        return this.packagesToAdd;
    }

    public boolean isRequireUpdate() {
        return this.requireUpdate;
    }

    public void setRequireUpdate(boolean requireUpdate) {
        this.requireUpdate = requireUpdate;
    }

    public boolean isUpdatePossible() {
        for (Boolean possible : this.updatePossible.values()) {
            if (possible.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public void setTransparentUpdate() {
        this.updatePossible.clear();
        this.packagesToRemove.clear();
        this.transparentUpdate = true;
    }

    public void setUpdatePossible(String pkgName, boolean updatePossible) {
        this.updatePossible.put(pkgName, updatePossible);
    }

    public void addPackageToRemove(DownloadablePackage pkg) {
        if (!this.packagesToRemove.contains(pkg)) {
            this.packagesToRemove.add(pkg);
        }
    }

    public void addPackage(DownloadablePackage pkg) {
        if (!this.packagesToAdd.contains(pkg)) {
            this.packagesToAdd.add(pkg);
        }
    }

    public boolean isTransparentUpdate() {
        return this.transparentUpdate;
    }
}

