/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.usersettings.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.usersettings.UserSettingsDescriptor;
import org.nuxeo.ecm.usersettings.UserSettingsProviderDescriptor;
import org.nuxeo.ecm.usersettings.UserSettingsService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class UserSettingsServiceImpl
extends DefaultComponent
implements UserSettingsService {
    public static final String NAME = "com.nuxeo.vilogia.usersettings.UserSettingsServiceComponent";
    private static final Log log = LogFactory.getLog(UserSettingsService.class);
    public static final String DOC_PREFIX = "nuxeoUserSettings_";
    public static final String TITLE = "usersettings.title";
    private static UserSettingsDescriptor descriptor;
    private static UserSettingsService userSettingsService;
    private Map<String, UserSettingsProviderDescriptor> userSettingsProviders = new HashMap<String, UserSettingsProviderDescriptor>();
    private Map<String, List<String>> providerTypeByCategory = new HashMap<String, List<String>>();

    public void activate(ComponentContext context) {
        log.info((Object)"UserSettingsService activated");
    }

    public void deactivate(ComponentContext context) {
        log.info((Object)"UserSettingsService deactivated");
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws ClientException {
        if (!"userSettingsProvider".equals(extensionPoint)) {
            throw new ClientException(extensionPoint + " is not a valid extension point.");
        }
        this.registerUserSettingsProvider(contribution, extensionPoint, contributor);
    }

    private void registerUserSettingsProvider(Object contribution, String extensionPoint, ComponentInstance contributor) throws ClientException {
        if (contribution instanceof UserSettingsProviderDescriptor) {
            UserSettingsProviderDescriptor desc = (UserSettingsProviderDescriptor)contribution;
            this.registerProvider(desc);
            log.info((Object)String.format("Registered %s extension point with %s name.", extensionPoint, desc.getType()));
        }
    }

    private void unregisterPendingProviders() throws ClientException {
        this.clearProviders();
    }

    private void unregisterUserSettingsProvider(Object contribution, String extensionPoint, ComponentInstance contributor) throws ClientException {
        if (contribution instanceof UserSettingsProviderDescriptor) {
            UserSettingsProviderDescriptor desc = (UserSettingsProviderDescriptor)contribution;
            try {
                this.unRegisterProvider(desc.getType());
                log.info((Object)String.format("Unregistering settings provider %s", desc.getType()));
            }
            catch (Exception e) {
                throw new ClientException("Failed to unregister UserSettingsService", (Throwable)e);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws ClientException {
        if ("userSettingsConfiguration".equals(extensionPoint)) {
            this.unregisterPendingProviders();
            descriptor = null;
        } else if ("userSettingsProvider".equals(extensionPoint)) {
            this.unregisterUserSettingsProvider(contribution, extensionPoint, contributor);
        } else {
            throw new ClientException(extensionPoint + " is not a valid extension point.");
        }
    }

    public static void reset() {
        userSettingsService = null;
    }

    public static Class<? extends UserSettingsService> getUserSettingsClass() {
        return descriptor.getUserSettingsClass();
    }

    public void registerProvider(UserSettingsProviderDescriptor provider) throws ClientException {
        boolean isEnabled = provider.isEnabled();
        String providerType = provider.getType();
        if (this.userSettingsProviders.containsKey(providerType)) {
            if (!isEnabled) {
                this.userSettingsProviders.remove(providerType);
            } else {
                log.error((Object)String.format("%s UserSettings provider already registered. Overriding.", providerType));
            }
        } else if (isEnabled) {
            String category = provider.getCategory();
            List<String> providerTypes = this.providerTypeByCategory.get(category);
            if (providerTypes == null) {
                providerTypes = new LinkedList<String>();
            }
            providerTypes.add(providerType);
            this.providerTypeByCategory.put(category, providerTypes);
            this.userSettingsProviders.put(providerType, provider);
            log.info((Object)String.format("%s UserSettings provider registered", providerType));
        }
    }

    public void unRegisterProvider(String providerName) throws ClientException {
        if (!this.userSettingsProviders.containsKey(providerName)) {
            log.error((Object)String.format("Cannot remove %s UserSettings provider : unknown. Ignoring.", providerName));
        } else {
            this.userSettingsProviders.remove(providerName);
            log.info((Object)String.format("%s UserSettings provider removed", providerName));
        }
    }

    protected DocumentModel getUserWorkspace(CoreSession session) throws ClientException {
        try {
            String userName = session.getPrincipal().getName();
            UserWorkspaceService uws = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
            DocumentModel userWorkspace = uws.getCurrentUserPersonalWorkspace(userName, session.getRootDocument());
            return userWorkspace;
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected DocumentModel getUserSettingsRoot(CoreSession session, DocumentModel userWorkspace) throws ClientException {
        DocumentModel userSettingsRoot = null;
        DocumentModelList list = session.getChildren(userWorkspace.getRef(), "UserSettings");
        userSettingsRoot = list.isEmpty() ? this.createUserSettingsRootDocument(session, userWorkspace) : (DocumentModel)list.get(0);
        return userSettingsRoot;
    }

    protected DocumentModel createUserSettingsRootDocument(CoreSession session, DocumentModel userWorkspace) throws ClientException {
        String userName = session.getPrincipal().getName();
        log.info((Object)String.format("Creating user settings document for user %s in %s", userName, userWorkspace.getPathAsString()));
        String parent = userWorkspace.getPathAsString();
        DocumentModel doc = session.createDocumentModel(parent, DOC_PREFIX + userName, "UserSettings");
        String title = TITLE;
        try {
            title = Framework.getProperty((String)TITLE);
        }
        catch (Exception e) {
            log.warn((Object)String.format("Unable to get %s message, defaulting.", TITLE));
        }
        doc.setProperty("dublincore", "title", (Object)title);
        doc.setProperty("usersettings", "user", (Object)userName);
        doc = session.createDocument(doc);
        doc = session.saveDocument(doc);
        return doc;
    }

    public Map<String, UserSettingsProviderDescriptor> getAllRegisteredProviders() throws ClientException {
        return this.userSettingsProviders;
    }

    public void clearProviders() throws ClientException {
        try {
            ArrayList<String> names = new ArrayList<String>();
            Iterator<Map.Entry<String, UserSettingsProviderDescriptor>> it = this.getAllRegisteredProviders().entrySet().iterator();
            while (it.hasNext()) {
                names.add(it.next().getKey());
            }
            for (String name : names) {
                log.info((Object)String.format("Cleaning settings provider %s", name));
                this.unRegisterProvider(name);
            }
        }
        catch (Exception e) {
            throw new ClientException("Failed to clear providers", (Throwable)e);
        }
    }

    public void resetSettingProvider(CoreSession session, String type) throws ClientException {
        DocumentModel provider = this.getCurrentSettingsByType(session, type);
        session.removeDocument(provider.getRef());
    }

    public void resetSettingsCategory(CoreSession session, String category) throws ClientException {
        DocumentModelList providers = this.getCurrentSettingsByCategory(session, category);
        for (DocumentModel provider : providers) {
            session.removeDocument(provider.getRef());
        }
    }

    public Set<String> getCategories() {
        return this.providerTypeByCategory.keySet();
    }

    public List<String> getSettingsByCategory(String category) {
        return this.providerTypeByCategory.get(category);
    }

    public DocumentModelList getCurrentSettingsByCategory(CoreSession coreSession, String category) throws ClientException {
        return this.findUserSettings(coreSession, category, null, true);
    }

    public DocumentModelList getCurrentSettingsByCategoryUnfiltered(CoreSession coreSession, String category) throws ClientException {
        return this.findUserSettings(coreSession, category, null, false);
    }

    public DocumentModel getCurrentSettingsByType(CoreSession coreSession, String type) throws ClientException {
        UserSettingsProviderDescriptor provider = this.userSettingsProviders.get(type);
        if (provider == null) {
            log.warn((Object)"No provider has been registered in the UserSettings service");
            return null;
        }
        DocumentModelList settings = this.findUserSettings(coreSession, provider.getCategory(), type, false);
        return (DocumentModel)settings.get(0);
    }

    private DocumentModelList findUserSettings(CoreSession session, String category, String type, boolean hiddenInSettingsFilter) throws ClientException {
        DocumentModelListImpl result = new DocumentModelListImpl();
        if (this.userSettingsProviders.size() == 0) {
            log.warn((Object)"No provider has been registered in the UserSettings service");
            return result;
        }
        DocumentModel userWorkspace = this.getUserWorkspace(session);
        DocumentModel userSettingsRoot = this.getUserSettingsRoot(session, userWorkspace);
        if (type != null && !type.equals("")) {
            UserSettingsProviderDescriptor provider = this.userSettingsProviders.get(type);
            DocumentModel settingProviderDoc = this.getUserSettingProviderDoc(provider, userSettingsRoot, session);
            result.add((Object)settingProviderDoc);
        } else {
            List<String> providers = this.providerTypeByCategory.get(category);
            if (providers == null) {
                log.warn((Object)("This category has no assocated providers: " + category));
                return result;
            }
            for (String providerType : providers) {
                UserSettingsProviderDescriptor provider = this.userSettingsProviders.get(providerType);
                DocumentModel settingProviderDoc = this.getUserSettingProviderDoc(provider, userSettingsRoot, session);
                if (hiddenInSettingsFilter && settingProviderDoc.hasFacet("HiddenInSettings")) continue;
                result.add((Object)settingProviderDoc);
            }
        }
        return result;
    }

    protected DocumentModel getUserSettingProviderDoc(UserSettingsProviderDescriptor provider, DocumentModel userSettingsRoot, CoreSession session) throws ClientException {
        DocumentModel settingProviderDoc;
        String providerType = provider.getType();
        String category = provider.getCategory();
        if (providerType == null || "".equals(providerType)) {
            return null;
        }
        DocumentModel categoryRoot = this.getCategoryRoot(session, userSettingsRoot, category);
        DocumentModelList settingProviderDocList = session.getChildren(categoryRoot.getRef(), providerType);
        if (settingProviderDocList.isEmpty()) {
            settingProviderDoc = session.createDocumentModel(categoryRoot.getPathAsString(), providerType, providerType);
            settingProviderDoc.setProperty("dublincore", "title", (Object)providerType);
            settingProviderDoc = session.createDocument(settingProviderDoc);
            settingProviderDoc = session.saveDocument(settingProviderDoc);
            settingProviderDocList.add((Object)settingProviderDoc);
        } else {
            settingProviderDoc = (DocumentModel)settingProviderDocList.get(0);
        }
        return settingProviderDoc;
    }

    protected DocumentModel getCategoryRoot(CoreSession session, DocumentModel userSettingsRoot, String category) throws ClientException {
        DocumentModel categoryRoot;
        PathRef categoryRootPath = new PathRef(userSettingsRoot.getPathAsString() + "/" + category.toLowerCase());
        if (session.exists((DocumentRef)categoryRootPath)) {
            categoryRoot = session.getDocument((DocumentRef)categoryRootPath);
        } else {
            categoryRoot = session.createDocumentModel(userSettingsRoot.getPathAsString(), category.toLowerCase(), "Folder");
            categoryRoot.setProperty("dublincore", "title", (Object)category);
            categoryRoot = session.createDocument(categoryRoot);
            categoryRoot = session.saveDocument(categoryRoot);
        }
        return categoryRoot;
    }
}

