/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forum.web;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.comment.web.CommentManagerActions;
import org.nuxeo.ecm.platform.forum.web.ForumWorkflowFilter;
import org.nuxeo.ecm.platform.forum.web.api.PostAction;
import org.nuxeo.ecm.platform.forum.web.api.ThreadAction;
import org.nuxeo.ecm.platform.forum.workflow.GetModerationTaskOperation;
import org.nuxeo.ecm.platform.jbpm.JbpmListFilter;
import org.nuxeo.ecm.platform.jbpm.JbpmOperation;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="postAction")
@Scope(value=ScopeType.CONVERSATION)
public class PostActionBean
implements PostAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PostActionBean.class);
    @In(create=true)
    protected ThreadAction threadAction;
    @In(create=true)
    protected transient CommentManagerActions commentManagerActions;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient JbpmService jbpmService;
    @In(required=false)
    protected RepositoryLocation currentServerLocation;
    @In(create=true)
    protected transient Principal currentUser;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @RequestParameter
    protected String deletePostId;
    protected String title;
    protected String text;
    protected String filename;
    protected Blob fileContent;

    @Override
    public boolean checkWritePermissionOnThread() {
        try {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            if (currentDocument != null) {
                return this.documentManager.hasPermission(currentDocument.getRef(), "ReadWrite");
            }
            log.error((Object)"Cannot check write permission on thread: no current document found");
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
        return false;
    }

    protected void fetchInvalidationsIfNeeded() throws ClientException {
        if (!this.documentManager.isStateSharedByAllThreadSessions()) {
            this.documentManager.save();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String addPost() throws ClientException {
        DocumentModel dm = this.documentManager.createDocumentModel("Post");
        dm.setProperty("post", "author", (Object)this.commentManagerActions.getPrincipalName());
        dm.setProperty("post", "title", (Object)this.title);
        dm.setProperty("post", "text", (Object)this.text);
        dm.setProperty("post", "creationDate", (Object)new Date());
        dm.setProperty("post", "filename", (Object)this.filename);
        dm.setProperty("post", "fileContent", (Object)this.fileContent);
        dm = this.commentManagerActions.addComment(dm);
        if (this.threadAction.isCurrentThreadModerated() && !this.threadAction.isPrincipalModerator()) {
            this.startModeration(dm);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.comment.waiting_approval"), new Object[0]);
        } else {
            DocumentRef postRef = dm.getRef();
            if (this.documentManager.hasPermission(postRef, "WriteLifeCycle")) {
                this.documentManager.followTransition(postRef, "moderation_publish");
                this.documentManager.save();
            } else {
                CoreSession systemSession;
                block15: {
                    LoginContext loginContext = null;
                    systemSession = null;
                    try {
                        loginContext = Framework.login();
                        RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
                        Repository repo = mgr.getRepository(this.currentServerLocation.getName());
                        systemSession = repo.open();
                        systemSession.followTransition(dm.getRef(), "moderation_publish");
                        systemSession.save();
                        if (loginContext == null) break block15;
                    }
                    catch (Exception e) {
                        try {
                            throw new ClientException((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            if (loginContext != null) {
                                try {
                                    loginContext.logout();
                                }
                                catch (LoginException e2) {
                                    // empty catch block
                                }
                            }
                            if (systemSession != null) {
                                CoreInstance.getInstance().close(systemSession);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        loginContext.logout();
                    }
                    catch (LoginException e) {
                        // empty catch block
                    }
                }
                if (systemSession != null) {
                    CoreInstance.getInstance().close(systemSession);
                }
            }
            this.fetchInvalidationsIfNeeded();
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.comment.added.sucess"), new Object[0]);
        }
        this.commentManagerActions.documentChanged();
        this.cleanContextVariables();
        return this.navigationContext.navigateToDocument(this.getParentThread());
    }

    @Override
    public String cancelPost() throws ClientException {
        this.cleanContextVariables();
        this.commentManagerActions.cancelComment();
        this.fetchInvalidationsIfNeeded();
        return this.navigationContext.navigateToDocument(this.getParentThread());
    }

    @Override
    public String deletePost() throws ClientException {
        ProcessInstance process;
        if (this.deletePostId == null) {
            throw new ClientException("No id for post to delete");
        }
        DocumentModel thread = this.getParentThread();
        DocumentModel post = this.documentManager.getDocument((DocumentRef)new IdRef(this.deletePostId));
        if (this.threadAction.isThreadModerated(thread) && "moderation_pending".equals(post.getCurrentLifeCycleState()) && (process = this.getModerationProcess(thread, this.deletePostId)) != null) {
            this.jbpmService.endProcessInstance(Long.valueOf(process.getId()));
        }
        this.commentManagerActions.deleteComment(this.deletePostId);
        this.fetchInvalidationsIfNeeded();
        Events.instance().raiseEvent("workflowProcessEnded", new Object[0]);
        return this.navigationContext.navigateToDocument(this.getParentThread());
    }

    @Override
    public String rejectPost(DocumentModel post) throws ClientException {
        DocumentModel thread = this.getParentThread();
        TaskInstance moderationTask = this.getModerationTask(thread, post.getId());
        if (moderationTask == null) {
            throw new ClientException("No moderation task found");
        }
        this.jbpmService.endTask(Long.valueOf(moderationTask.getId()), "moderation_reject", null, null, null, (NuxeoPrincipal)this.currentUser);
        Events.instance().raiseEvent("workflowTaskCompleted", new Object[0]);
        this.commentManagerActions.documentChanged();
        this.fetchInvalidationsIfNeeded();
        return this.navigationContext.navigateToDocument(this.getParentThread());
    }

    @Override
    public String approvePost(DocumentModel post) throws ClientException {
        DocumentModel thread = this.getParentThread();
        TaskInstance moderationTask = this.getModerationTask(thread, post.getId());
        if (moderationTask == null) {
            throw new ClientException("No moderation task found");
        }
        this.jbpmService.endTask(Long.valueOf(moderationTask.getId()), "moderation_publish", null, null, null, (NuxeoPrincipal)this.currentUser);
        Events.instance().raiseEvent("workflowTaskCompleted", new Object[0]);
        this.commentManagerActions.documentChanged();
        this.fetchInvalidationsIfNeeded();
        return this.navigationContext.navigateToDocument(this.getParentThread());
    }

    @Override
    public DocumentModel getParentThread() {
        return this.navigationContext.getCurrentDocument();
    }

    @Override
    public boolean isPostPublished(DocumentModel post) throws ClientException {
        boolean published = false;
        if (post != null && "moderation_published".equals(post.getCurrentLifeCycleState())) {
            published = true;
        }
        return published;
    }

    protected void startModeration(DocumentModel post) throws ClientException {
        DocumentModel thread = this.getParentThread();
        ArrayList moderators = (ArrayList)thread.getProperty("thread", "moderators");
        if (moderators == null || moderators.isEmpty()) {
            throw new ClientException("No moderators defined");
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put(JbpmService.VariableName.participants.name(), moderators);
        vars.put("commentId", post.getId());
        this.jbpmService.createProcessInstance((NuxeoPrincipal)this.currentUser, "forum_moderation", thread, vars, null);
        Events.instance().raiseEvent("workflowNewProcessStarted", new Object[0]);
    }

    protected ProcessInstance getModerationProcess(DocumentModel thread, String postId) throws ClientException {
        List processes = this.jbpmService.getProcessInstances(thread, (NuxeoPrincipal)this.currentUser, (JbpmListFilter)new ForumWorkflowFilter(postId));
        if (processes != null && !processes.isEmpty()) {
            if (processes.size() > 1) {
                log.error((Object)"There are several moderation workflows running, taking only first found");
            }
            return (ProcessInstance)processes.get(0);
        }
        return null;
    }

    protected TaskInstance getModerationTask(DocumentModel thread, String postId) throws ClientException {
        ProcessInstance process = this.getModerationProcess(thread, postId);
        GetModerationTaskOperation operation = new GetModerationTaskOperation(process.getId());
        return (TaskInstance)this.jbpmService.executeJbpmOperation((JbpmOperation)operation);
    }

    protected void cleanContextVariables() {
        this.fileContent = null;
        this.filename = null;
        this.text = null;
        this.title = null;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public Blob getFileContent() {
        return this.fileContent;
    }

    @Override
    public void setFileContent(Blob fileContent) {
        this.fileContent = fileContent;
    }

    @Override
    public String getTitle() throws ClientException {
        DocumentModel previousPost;
        String previousId = this.commentManagerActions.getSavedReplyCommentId();
        if (previousId != null && !"".equals(previousId) && (previousPost = this.documentManager.getDocument((DocumentRef)new IdRef(previousId))).getDataModel("post") != null) {
            String previousTitle = (String)previousPost.getProperty("post", "title");
            String prefix = (String)this.resourcesAccessor.getMessages().get("label.forum.post.title.prefix");
            this.title = prefix + previousTitle;
        }
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }
}

