/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.blobs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.search.api.client.indexing.blobs.BlobExtractor;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.document.FulltextFieldDescriptor;
import org.nuxeo.runtime.api.Framework;

public class NXTransformBlobExtractor
implements BlobExtractor {
    private static final long serialVersionUID = -4204325669629533663L;
    private static final int BYTE_ORDER_MARK_CHAR = 65279;
    private static ConversionService conversionService;

    private static ConversionService getConversionService() throws Exception {
        if (conversionService == null) {
            conversionService = (ConversionService)Framework.getService(ConversionService.class);
        }
        return conversionService;
    }

    public String extract(Blob blob, String mimetype, FulltextFieldDescriptor desc) throws Exception {
        if (blob == null || blob.getLength() == 0L) {
            return "";
        }
        String converterName = null;
        try {
            converterName = NXTransformBlobExtractor.getConversionService().getConverterName(mimetype, "text/plain");
            BlobHolder result = NXTransformBlobExtractor.getConversionService().convert(converterName, (BlobHolder)new SimpleBlobHolder(blob), null);
            return NXTransformBlobExtractor.readContent(result.getBlob().getReader());
        }
        catch (IOException e) {
            throw new ClientException("Couldn't read from blob convert with " + converterName, (Throwable)e);
        }
    }

    public static String readContent(Reader reader) throws IOException {
        int length;
        char[] buffer = new char[2048];
        StringWriter writer = new StringWriter();
        while ((length = reader.read(buffer, 0, 2048)) != -1) {
            writer.write(buffer, 0, length);
        }
        String content = NXTransformBlobExtractor.stripByteOrderMarkChar(writer.toString());
        return content.trim();
    }

    private static String stripByteOrderMarkChar(String content) {
        if (content.length() > 0 && content.charAt(0) == '\ufeff') {
            return content.substring(1).trim();
        }
        return content;
    }
}

