/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.service;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.search.api.backend.SearchEngineBackend;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedResource;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedResources;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.factory.ResolvedResourcesFactory;
import org.nuxeo.ecm.core.search.api.client.IndexingException;
import org.nuxeo.ecm.core.search.api.client.SearchException;
import org.nuxeo.ecm.core.search.api.client.common.TypeManagerServiceDelegate;
import org.nuxeo.ecm.core.search.api.client.indexing.blobs.BlobExtractor;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.IndexableResources;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.document.schemas.DefaultSchemaFieldDescriptorsFactory;
import org.nuxeo.ecm.core.search.api.client.indexing.session.SearchServiceSession;
import org.nuxeo.ecm.core.search.api.client.query.ComposedNXQuery;
import org.nuxeo.ecm.core.search.api.client.query.NativeQuery;
import org.nuxeo.ecm.core.search.api.client.query.NativeQueryString;
import org.nuxeo.ecm.core.search.api.client.query.QueryException;
import org.nuxeo.ecm.core.search.api.client.query.SearchPrincipal;
import org.nuxeo.ecm.core.search.api.client.query.impl.ComposedNXQueryImpl;
import org.nuxeo.ecm.core.search.api.client.query.impl.SearchPrincipalImpl;
import org.nuxeo.ecm.core.search.api.client.search.results.ResultItem;
import org.nuxeo.ecm.core.search.api.client.search.results.ResultSet;
import org.nuxeo.ecm.core.search.api.events.IndexingEventConf;
import org.nuxeo.ecm.core.search.api.events.IndexingEventDescriptor;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableFieldDescriptor;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceConf;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceDataConf;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceDescriptor;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.ResourceTypeDescriptor;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.blobs.BlobExtractorDescriptor;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.document.FulltextFieldDescriptor;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.document.IndexableDocType;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.document.IndexableDocTypeDescriptor;
import org.nuxeo.ecm.core.search.api.internals.IndexingThreadPoolDescriptor;
import org.nuxeo.ecm.core.search.api.internals.SearchPolicyDescriptor;
import org.nuxeo.ecm.core.search.api.internals.SearchServiceInternals;
import org.nuxeo.ecm.core.search.api.security.SearchPolicy;
import org.nuxeo.ecm.core.search.backend.SearchEngineBackendDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class SearchServiceImpl
extends DefaultComponent
implements SearchServiceInternals {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.core.search.service.SearchServiceImpl");
    private static final long serialVersionUID = 5428662089095318591L;
    private static final Log log = LogFactory.getLog(SearchServiceImpl.class);
    public static final int DEFAULT_MAX_POOL_SIZE = 5;
    public static final int DEFAULT_DOC_BATCH_SIZE = 1;
    private static final String PT_BACKEND = "searchEngineBackend";
    private static final String PT_RESOURCE = "resource";
    private static final String PT_RESOURCE_TYPE = "resourceType";
    private static final String PT_DOCTYPE_INDEX = "indexableDocType";
    private static final String PT_BLOB_EXTRACTOR_DESC = "blobExtractor";
    private static final String PT_FULLTEXT = "fullTextField";
    private static final String PT_EVENTS = "indexingEvent";
    private static final String PT_INDEXING_THREAD_POOL = "indexingThreadPool";
    private static final String PT_POLICIES = "policies";
    private boolean activated = true;
    private boolean reindexingAll = false;
    private String defaultBackendName;
    private int threadPoolSizeMax = 5;
    private int docBatchSize = 1;
    private final Map<String, SearchEngineBackend> backends = new HashMap<String, SearchEngineBackend>();
    private final Map<String, SearchEngineBackendDescriptor> backendDescriptors = new HashMap<String, SearchEngineBackendDescriptor>();
    private final Map<String, IndexableResourceConf> namedResources = new HashMap<String, IndexableResourceConf>();
    private final Map<String, IndexableResourceConf> prefixedResources = new HashMap<String, IndexableResourceConf>();
    private Map<String, IndexableResourceConf> cNamedResources = new HashMap<String, IndexableResourceConf>();
    private final Map<String, IndexableResourceConf> cPrefixedResources = new HashMap<String, IndexableResourceConf>();
    private final Map<String, IndexableDocType> docType2IndexableResourceTypes = new HashMap<String, IndexableDocType>();
    private final Map<String, FulltextFieldDescriptor> fullTextDescriptors = new HashMap<String, FulltextFieldDescriptor>();
    private final Map<String, IndexingEventConf> indexingEvents = new HashMap<String, IndexingEventConf>();
    private final Map<String, BlobExtractor> blobExtractors = new HashMap<String, BlobExtractor>();
    private final Map<String, ResourceTypeDescriptor> resourceTypes = new HashMap<String, ResourceTypeDescriptor>();
    private Map<String, SearchPolicyDescriptor> policyDescriptors;
    private List<SearchPolicy> policies;
    private SchemaManager typeManagerService;
    private boolean backendsConstructed = false;

    public void activate(ComponentContext context) throws Exception {
        this.policyDescriptors = new Hashtable<String, SearchPolicyDescriptor>();
        super.activate(context);
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.policyDescriptors = null;
        this.policies = null;
        super.deactivate(context);
    }

    private void setToCache(IndexableResourceConf conf) {
        this.cNamedResources.put(conf.getName(), conf);
        this.cPrefixedResources.put(conf.getPrefix(), conf);
    }

    private void removeFromCache(IndexableResourceConf conf) {
        this.cNamedResources.remove(conf.getName());
        this.cPrefixedResources.remove(conf.getPrefix());
    }

    private SchemaManager getTypeManagerService() {
        if (this.typeManagerService == null) {
            this.typeManagerService = TypeManagerServiceDelegate.getRemoteTypeManagerService();
        }
        return this.typeManagerService;
    }

    @Override
    public final String getDefaultSearchEngineBakendName() {
        return this.defaultBackendName;
    }

    @Override
    public final void setDefaultSearchEngineBackendName(String backendName) {
        this.defaultBackendName = backendName;
    }

    @Override
    public final String getPreferedBackendNameFor(ResolvedResource resource) {
        return this.defaultBackendName;
    }

    protected SearchEngineBackend getDefaultBackend() {
        return this.getSearchEngineBackendByName(this.defaultBackendName);
    }

    public void index(ResolvedResources sources) throws IndexingException {
        SearchEngineBackend backend = this.getDefaultBackend();
        if (backend != null) {
            backend.index(sources);
        } else {
            log.warn((Object)"No search engine backend found !");
        }
    }

    public void index(IndexableResources sources, boolean fulltext) throws IndexingException {
        ResolvedResources resolved = ResolvedResourcesFactory.computeAggregatedResolvedResourcesFrom((IndexableResources)sources, (boolean)fulltext);
        this.index(resolved);
    }

    public void unindex(DocumentModel dm) throws IndexingException {
        this.deleteAggregatedResources(dm.getId());
        ResultSet rset = null;
        try {
            rset = this.searchQuery(SearchServiceImpl.createUnindexPathQuery(dm), 0, 100);
        }
        catch (SearchException se) {
            throw new IndexingException((Throwable)se);
        }
        catch (QueryException qe) {
            throw new IndexingException((Throwable)qe);
        }
        if (rset == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No children to unindex for dm= " + dm));
            }
            return;
        }
        while (true) {
            for (ResultItem item : rset) {
                String key = (String)item.get((Object)"ecm:uuid");
                if (key != null) {
                    this.deleteAggregatedResources(key);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"No UUID indexed for dm=");
            }
            if (!rset.hasNextPage()) break;
            try {
                rset = rset.nextPage();
            }
            catch (SearchException se) {
                throw new IndexingException((Throwable)se);
            }
        }
    }

    private static ComposedNXQuery createUnindexPathQuery(DocumentModel dm) {
        String queryStr = "SELECT * FROM Document WHERE ecm:path STARTSWITH '" + dm.getPathAsString() + "'";
        return new ComposedNXQueryImpl(queryStr);
    }

    public void clear() throws IndexingException {
        SearchEngineBackend backend = this.getDefaultBackend();
        if (backend != null) {
            backend.clear();
        } else {
            log.warn((Object)"No search engine backend found !");
        }
    }

    public void deleteAggregatedResources(String key) throws IndexingException {
        SearchEngineBackend backend = this.getDefaultBackend();
        if (backend != null) {
            backend.deleteAggregatedResources(key);
        } else {
            log.warn((Object)"No search engine backend found !");
        }
    }

    public void deleteAtomicResource(String key) throws IndexingException {
        SearchEngineBackend backend = this.getDefaultBackend();
        if (backend != null) {
            backend.deleteAtomicResource(key);
        } else {
            log.warn((Object)"No search engine backend found !");
        }
    }

    @Override
    public final SearchEngineBackend getSearchEngineBackendByName(String name) {
        this.lookupBackends();
        return this.backends.get(name);
    }

    @Override
    public final Map<String, SearchEngineBackend> getSearchEngineBackends() {
        this.lookupBackends();
        return this.backends;
    }

    private void lookupBackends() {
        if (this.backendsConstructed) {
            return;
        }
        for (String name : this.backendDescriptors.keySet()) {
            this.backends.put(name, SearchServiceImpl.constructBackend(this.backendDescriptors.get(name)));
        }
        this.backendsConstructed = true;
    }

    private static SearchEngineBackend constructBackend(SearchEngineBackendDescriptor desc) {
        SearchEngineBackend engine = null;
        try {
            engine = (SearchEngineBackend)Framework.getService(desc.getKlass());
        }
        catch (Exception e) {
            log.error((Object)("Exception in nxruntime's service lookup: " + e.getMessage()));
        }
        if (engine == null) {
            try {
                engine = desc.getKlass().newInstance();
            }
            catch (InstantiationException e) {
                log.error((Object)("Exception in search backend instantiation: " + e.getMessage()));
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Exception in search backend instantiation: " + e.getMessage()));
            }
        }
        log.debug((Object)("Instantiated search engine backend: " + desc.getName()));
        String configurationFileName = desc.getConfigurationFileName();
        engine.setName(desc.getName());
        engine.setConfigurationFileName(configurationFileName);
        return engine;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(PT_BACKEND)) {
            SearchEngineBackendDescriptor desc = (SearchEngineBackendDescriptor)contribution;
            if (desc.getName() != null) {
                try {
                    String name = desc.getName();
                    this.backendDescriptors.put(name, desc);
                    log.debug((Object)("Registered search engine descriptor: " + name));
                    this.defaultBackendName = name;
                }
                catch (NullPointerException ne) {
                    log.error((Object)ne);
                }
            } else {
                log.error((Object)"No name for the supplied search engine plugin registration... Cancelling...");
            }
        } else if (extensionPoint.equals(PT_RESOURCE)) {
            IndexableResourceConf conf = (IndexableResourceConf)contribution;
            String resourceName = conf.getName();
            if (resourceName != null) {
                boolean isOverride = this.namedResources.containsKey(resourceName);
                this.namedResources.put(resourceName, conf);
                this.prefixedResources.put(conf.getPrefix(), conf);
                this.removeFromCache(conf);
                if (isOverride) {
                    log.info((Object)("Reregistered resource:" + resourceName));
                } else {
                    log.info((Object)("Registered resource: " + resourceName));
                }
            } else {
                log.warn((Object)"You need to supply a resource name...");
            }
        } else if (extensionPoint.equals(PT_RESOURCE_TYPE)) {
            ResourceTypeDescriptor desc = (ResourceTypeDescriptor)contribution;
            if (desc.getName() != null) {
                this.resourceTypes.put(desc.getName(), desc);
                log.info((Object)("Registered resource type: " + desc.getName()));
            } else {
                log.warn((Object)"Resource type can't be registered cause no type name specified");
            }
        } else if (extensionPoint.equals(PT_DOCTYPE_INDEX)) {
            IndexableDocTypeDescriptor desc = (IndexableDocTypeDescriptor)contribution;
            String docType = desc.getType();
            if (docType != null) {
                this.docType2IndexableResourceTypes.put(docType, (IndexableDocType)desc);
                log.info((Object)("Registered indexable doc type: " + docType));
            } else {
                log.error((Object)"type is compulsory....... Skipping contribution...");
            }
        } else if (extensionPoint.equals(PT_FULLTEXT)) {
            FulltextFieldDescriptor desc = (FulltextFieldDescriptor)contribution;
            log.info((Object)("Registered fulltext: " + desc.getName()));
            this.fullTextDescriptors.put(desc.getName(), desc);
        } else if (extensionPoint.equals(PT_EVENTS)) {
            IndexingEventDescriptor desc = (IndexingEventDescriptor)contribution;
            log.info((Object)("Registered event: " + desc.getName()));
            this.indexingEvents.put(desc.getName(), (IndexingEventConf)desc);
        } else if (extensionPoint.equals(PT_BLOB_EXTRACTOR_DESC)) {
            BlobExtractorDescriptor desc = (BlobExtractorDescriptor)contribution;
            try {
                BlobExtractor extractor = (BlobExtractor)desc.getKlass().newInstance();
                this.blobExtractors.put(desc.getName(), extractor);
            }
            catch (InstantiationException e) {
                log.error((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.error((Object)e.getMessage());
            }
        } else if (extensionPoint.equals(PT_INDEXING_THREAD_POOL)) {
            IndexingThreadPoolDescriptor desc = (IndexingThreadPoolDescriptor)contribution;
            this.setNumberOfIndexingThreads(desc.getMaxPoolSize());
            this.setIndexingDocBatchSize(desc.getDocBatchSize());
        } else if (extensionPoint.equals(PT_POLICIES)) {
            SearchPolicyDescriptor desc = (SearchPolicyDescriptor)contribution;
            this.registerSearchPolicyDescriptor(desc);
        } else {
            log.error((Object)("Wrong extension point name for registration... Check your fragments...=>" + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(PT_BACKEND)) {
            SearchEngineBackendDescriptor desc = (SearchEngineBackendDescriptor)contribution;
            if (desc.getName() != null) {
                log.debug((Object)("Starting a search engine plugin unregistration with name=" + desc.getName()));
                this.backends.remove(desc.getName());
            } else {
                log.error((Object)"No name for the supplied search engine plugin unregistration... Cancelling...");
            }
        } else if (extensionPoint.equals(PT_RESOURCE)) {
            IndexableResourceDescriptor schema = (IndexableResourceDescriptor)contribution;
            this.namedResources.remove(schema.getName());
            this.prefixedResources.remove(schema.getPrefix());
            this.removeFromCache((IndexableResourceConf)schema);
            log.debug((Object)("Indexable schema with name=" + schema.getName() + " has been unregistered"));
        } else if (extensionPoint.equals(PT_RESOURCE_TYPE)) {
            ResourceTypeDescriptor desc = (ResourceTypeDescriptor)contribution;
            if (desc.getName() != null) {
                this.resourceTypes.remove(desc.getName());
                log.debug((Object)("Resource type with name = " + desc.getName() + " has been unregistered"));
            } else {
                log.warn((Object)"Resource type can't be registered cause no type name specified");
            }
        } else if (extensionPoint.equals(PT_DOCTYPE_INDEX)) {
            IndexableDocTypeDescriptor desc = (IndexableDocTypeDescriptor)contribution;
            String docType = desc.getType();
            if (docType != null && this.docType2IndexableResourceTypes.containsKey(docType)) {
                this.docType2IndexableResourceTypes.remove(docType);
                log.debug((Object)("Unregister doctype to indexable resources mapping for doctype=" + docType));
            }
        } else if (extensionPoint.equals(PT_FULLTEXT)) {
            FulltextFieldDescriptor desc = (FulltextFieldDescriptor)contribution;
            if (this.fullTextDescriptors.containsKey(desc.getName())) {
                log.debug((Object)("Unregistering fulltext descriptor with name" + desc.getName()));
                this.fullTextDescriptors.remove(desc.getName());
            }
        } else if (extensionPoint.equals(PT_BLOB_EXTRACTOR_DESC)) {
            BlobExtractorDescriptor desc = (BlobExtractorDescriptor)contribution;
            this.blobExtractors.remove(desc.getName());
            log.debug((Object)("Full text extractor with name : " + desc.getName() + " has been unregistered"));
        } else if (extensionPoint.equals(PT_POLICIES)) {
            SearchPolicyDescriptor desc = (SearchPolicyDescriptor)contribution;
            this.unregisterSearchPolicyDescriptor(desc);
        } else {
            log.debug((Object)("Nothing to do to unregister contrib=" + extensionPoint));
        }
    }

    public final IndexableResourceConf getIndexableResourceConfByName(String name, boolean full) {
        IndexableResourceConf conf = this.namedResources.get(name);
        if (full) {
            if (this.cNamedResources.containsKey(name)) {
                return this.cNamedResources.get(name);
            }
            IndexableResourceConf computedConf = this.computeResourceConfByName(name);
            if (computedConf != null) {
                conf = computedConf;
                this.setToCache(conf);
            }
        }
        return conf;
    }

    public final IndexableResourceConf getIndexableResourceConfByPrefix(String prefix, boolean full) {
        IndexableResourceConf conf = this.prefixedResources.get(prefix);
        if (full) {
            if (this.cPrefixedResources.containsKey(prefix)) {
                return this.computeResourceConfByPrefix(prefix);
            }
            IndexableResourceConf computeConf = this.computeResourceConfByPrefix(prefix);
            if (computeConf != null) {
                conf = computeConf;
                this.setToCache(conf);
            }
        }
        return conf;
    }

    public final Map<String, IndexableResourceConf> getIndexableResourceConfs() {
        return this.namedResources;
    }

    @Override
    public final Map<String, IndexableDocType> getIndexableDocTypes() {
        return this.docType2IndexableResourceTypes;
    }

    public final IndexableDocType getIndexableDocTypeFor(String docType) {
        return this.docType2IndexableResourceTypes.get(docType);
    }

    public List<String> getSupportedAnalyzersFor(String backendName) {
        SearchEngineBackend backend = this.getSearchEngineBackendByName(backendName);
        if (backend != null) {
            return backend.getSupportedAnalyzersFor();
        }
        return Collections.emptyList();
    }

    public List<String> getSupportedFieldTypes(String backendName) {
        SearchEngineBackend backend = this.getSearchEngineBackendByName(backendName);
        if (backend != null) {
            return backend.getSupportedFieldTypes();
        }
        return Collections.emptyList();
    }

    public ResultSet searchQuery(ComposedNXQuery nxqlQuery, int offset, int range) throws SearchException, QueryException {
        try {
            String backendName = this.defaultBackendName;
            SearchEngineBackend backend = this.getSearchEngineBackendByName(backendName);
            if (backend != null) {
                List<SearchPolicy> policies = this.getSearchPolicies();
                for (SearchPolicy policy : policies) {
                    nxqlQuery = policy.applyPolicy(nxqlQuery);
                }
                return backend.searchQuery(nxqlQuery, offset, range);
            }
            throw new SearchException("No backend with name=" + backendName + " found ! ");
        }
        catch (Throwable t) {
            throw new SearchException(t);
        }
    }

    public ResultSet searchQuery(NativeQuery nativeQuery, int offset, int range) throws SearchException, QueryException {
        try {
            SearchEngineBackend backend = this.getSearchEngineBackendByName(nativeQuery.getBackendName());
            if (backend != null) {
                return backend.searchQuery(nativeQuery, offset, range);
            }
            throw new SearchException("No backend with name=" + nativeQuery.getBackendName() + " found ! ");
        }
        catch (Throwable t) {
            throw new SearchException(t);
        }
    }

    public ResultSet searchQuery(NativeQueryString queryString, String backendName, int offset, int range) throws SearchException, QueryException {
        try {
            SearchEngineBackend backend = this.getSearchEngineBackendByName(backendName);
            if (backend != null) {
                return backend.searchQuery(queryString, offset, range);
            }
            throw new SearchException("No backend with name=" + backendName + " found ! ");
        }
        catch (Throwable t) {
            throw new SearchException(t);
        }
    }

    public final String[] getAvailableBackendNames() {
        this.lookupBackends();
        String[] names = new String[this.backends.size()];
        this.backends.keySet().toArray(names);
        return names;
    }

    @Override
    public final IndexableResourceDataConf getIndexableDataConfFor(String dataName) {
        String[] split = dataName.split(":", 2);
        if (split.length < 2) {
            return null;
        }
        IndexableResourceConf conf = this.getIndexableResourceConfByPrefix(split[0], true);
        if (conf != null) {
            return (IndexableResourceDataConf)conf.getIndexableFields().get(split[1]);
        }
        return null;
    }

    @Override
    public final IndexableResourceDataConf getIndexableDataConfByName(String name) {
        IndexableResourceDataConf matchingDataConf = null;
        for (IndexableResourceConf conf : this.namedResources.values()) {
            matchingDataConf = (IndexableResourceDataConf)conf.getIndexableFields().get(name);
            if (matchingDataConf == null) continue;
            return matchingDataConf;
        }
        return matchingDataConf;
    }

    public final SearchPrincipal getSearchPrincipal(Principal principal) {
        String[] groups;
        if (principal == null) {
            return null;
        }
        String name = principal.getName();
        boolean isSystemUser = "system".equals(name);
        boolean isAdministrator = false;
        if (principal instanceof NuxeoPrincipal) {
            NuxeoPrincipal nuxeoPrincipal = (NuxeoPrincipal)principal;
            groups = nuxeoPrincipal.getAllGroups().toArray(new String[nuxeoPrincipal.getAllGroups().size() + 1]);
            groups[groups.length - 1] = "Everyone";
            isAdministrator = nuxeoPrincipal.isAdministrator();
        } else {
            groups = new String[]{};
        }
        return new SearchPrincipalImpl(name, groups, isSystemUser, isAdministrator, principal);
    }

    public final boolean isEnabled() {
        return this.activated;
    }

    public final void setStatus(boolean active) {
        log.debug((Object)("Set to status: " + active));
        this.activated = active;
    }

    public final FulltextFieldDescriptor getFullTextDescriptorByName(String name) {
        if (name != null) {
            return this.fullTextDescriptors.get(name);
        }
        return null;
    }

    public IndexingEventConf getIndexingEventConfByName(String name) {
        return this.indexingEvents.get(name);
    }

    private IndexableResourceConf computeResourceConfByName(String name) {
        IndexableResourceConf conf = this.getIndexableResourceConfByName(name, false);
        if (conf == null) {
            DefaultSchemaFieldDescriptorsFactory schemaFieldFactory = new DefaultSchemaFieldDescriptorsFactory();
            Schema schema = schemaFieldFactory.getSchemaByName(name);
            if (schema != null) {
                String prefix = schema.getNamespace().prefix;
                if (prefix.equals("")) {
                    prefix = name;
                }
                HashSet excludedFields = new HashSet();
                HashMap<String, IndexableFieldDescriptor> fields = new HashMap<String, IndexableFieldDescriptor>();
                List descs = schemaFieldFactory.getFieldDescriptorsBySchemaName(name, excludedFields);
                for (IndexableFieldDescriptor desc : descs) {
                    fields.put(desc.getIndexingName(), desc);
                }
                conf = new IndexableResourceDescriptor(name, prefix, true, excludedFields, fields, "schema");
            }
        } else {
            for (String excludedField : conf.getExcludedFields()) {
                if (!conf.getIndexableFields().containsKey(excludedField)) continue;
                conf.getIndexableFields().remove(excludedField);
            }
            if (conf.areAllFieldsIndexable()) {
                DefaultSchemaFieldDescriptorsFactory schemaFieldFactory = new DefaultSchemaFieldDescriptorsFactory();
                HashSet<Object> excluded = new HashSet<Object>();
                excluded.addAll(conf.getIndexableFields().keySet());
                for (String explicitExclude : conf.getExcludedFields()) {
                    if (excluded.contains(explicitExclude)) continue;
                    excluded.add(explicitExclude);
                }
                List fieldConfs = schemaFieldFactory.getFieldDescriptorsBySchemaName(name, excluded);
                for (IndexableFieldDescriptor fieldConf : fieldConfs) {
                    conf.getIndexableFields().put(fieldConf.getIndexingName(), fieldConf);
                }
            }
        }
        return conf;
    }

    private IndexableResourceConf computeResourceConfByPrefix(String prefix) {
        DefaultSchemaFieldDescriptorsFactory schemaFieldFactory = new DefaultSchemaFieldDescriptorsFactory();
        Schema schema = schemaFieldFactory.getSchemaByPrefix(prefix);
        if (schema == null) {
            schema = schemaFieldFactory.getSchemaByName(prefix);
        }
        if (schema != null) {
            return this.computeResourceConfByName(schema.getName());
        }
        return null;
    }

    @Override
    public final Set<String> getDocumentTypeNamesForFacet(String facet) {
        SchemaManager typeManager = this.getTypeManagerService();
        if (typeManager != null) {
            return this.typeManagerService.getDocumentTypeNamesForFacet(facet);
        }
        log.error((Object)"Type manager service cannot be found....");
        return new HashSet<String>();
    }

    @Override
    public Set<String> getDocumentTypeNamesExtending(String docType) {
        SchemaManager typeManager = this.getTypeManagerService();
        if (typeManager != null) {
            return this.typeManagerService.getDocumentTypeNamesExtending(docType);
        }
        log.error((Object)"Type manager service cannot be found....");
        return null;
    }

    @Override
    public final Set<String> getDocumentTypeNamesForFacet(Collection<String> facets) {
        SchemaManager typeManager = this.getTypeManagerService();
        if (typeManager == null) {
            log.error((Object)"Type manager service cannot be found...");
            return new HashSet<String>();
        }
        HashSet result = null;
        for (String facet : facets) {
            Set forOne = typeManager.getDocumentTypeNamesForFacet(facet);
            if (forOne == null) continue;
            if (result == null) {
                result = new HashSet();
            }
            result.addAll(forOne);
        }
        return result;
    }

    public final void invalidateComputedIndexableResourceConfs() {
        this.cNamedResources = new HashMap<String, IndexableResourceConf>();
    }

    public final BlobExtractor getBlobExtractorByName(String name) {
        return this.blobExtractors.get(name);
    }

    public ResourceTypeDescriptor getResourceTypeDescriptorByName(String name) {
        return this.resourceTypes.get(name);
    }

    public long getIndexingWaitingQueueSize() {
        return 0L;
    }

    public int getNumberOfIndexingThreads() {
        return this.threadPoolSizeMax;
    }

    public void closeSession(String sid) {
        SearchEngineBackend backend = this.getDefaultBackend();
        if (backend != null) {
            backend.closeSession(sid);
        } else {
            log.warn((Object)"No search engine backend found !");
        }
    }

    public SearchServiceSession openSession() {
        SearchEngineBackend backend = this.getDefaultBackend();
        if (backend != null) {
            return backend.createSession();
        }
        log.warn((Object)"No search engine backend found !");
        return null;
    }

    public int getIndexingDocBatchSize() {
        return this.docBatchSize;
    }

    public void setIndexingDocBatchSize(int docBatchSize) {
        this.docBatchSize = docBatchSize;
        log.info((Object)("Setting indexing batch size: " + Integer.toString(this.docBatchSize)));
    }

    public void setNumberOfIndexingThreads(int numberOfIndexingThreads) {
        log.info((Object)("Setting indexing thread pool size: " + Integer.toString(numberOfIndexingThreads)));
        this.threadPoolSizeMax = numberOfIndexingThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAllSessions() throws IndexingException {
        this.reindexingAll = true;
        try {
            SearchEngineBackend backend = this.getDefaultBackend();
            if (backend != null) {
                backend.saveAllSessions();
                log.debug((Object)"Saving all sessions");
            } else {
                log.warn((Object)"No search engine backend found !");
            }
        }
        finally {
            this.reindexingAll = false;
        }
    }

    public static CoreSession getCoreSession(String repoName) throws IndexingException {
        log.debug((Object)"Opening a new Session against Nuxeo Core");
        try {
            RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
            return mgr.getRepository(repoName).open();
        }
        catch (Exception e) {
            throw new IndexingException((Throwable)e);
        }
    }

    public void reindexAll(String repoName, String path, boolean fulltext) throws IndexingException {
        log.error((Object)"reindexAll is deprecated and does nothing");
    }

    public int getActiveIndexingTasks() {
        return 0;
    }

    public long getTotalCompletedIndexingTasks() {
        return 0L;
    }

    public boolean isReindexingAll() {
        return this.reindexingAll;
    }

    public void setReindexingAll(boolean flag) {
        this.reindexingAll = flag;
    }

    private void computeSearchPolicies() {
        this.policies = new ArrayList<SearchPolicy>();
        ArrayList<SearchPolicyDescriptor> orderedDescriptors = new ArrayList<SearchPolicyDescriptor>();
        for (SearchPolicyDescriptor descriptor : this.policyDescriptors.values()) {
            if (!descriptor.isEnabled()) continue;
            orderedDescriptors.add(descriptor);
        }
        Collections.sort(orderedDescriptors);
        ArrayList<String> policyNames = new ArrayList<String>();
        for (SearchPolicyDescriptor descriptor : orderedDescriptors) {
            if (!descriptor.isEnabled()) continue;
            try {
                Object policy = descriptor.getPolicy().newInstance();
                if (policy instanceof SearchPolicy) {
                    this.policies.add((SearchPolicy)policy);
                    policyNames.add(descriptor.getName());
                    continue;
                }
                log.error((Object)String.format("Invalid contribution to search policy %s: must implement SearchPolicy interface", descriptor.getName()));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        log.debug((Object)("Ordered search policies: " + ((Object)policyNames).toString()));
    }

    private List<SearchPolicy> getSearchPolicies() {
        if (this.policies == null) {
            this.computeSearchPolicies();
        }
        return this.policies;
    }

    private void resetSearchPolicies() {
        this.policies = null;
    }

    private void registerSearchPolicyDescriptor(SearchPolicyDescriptor descriptor) {
        String id = descriptor.getName();
        if (this.policyDescriptors.containsKey(id)) {
            log.info((Object)("Overriding security policy: " + id));
        }
        this.policyDescriptors.put(id, descriptor);
        this.resetSearchPolicies();
    }

    private void unregisterSearchPolicyDescriptor(SearchPolicyDescriptor descriptor) {
        String id = descriptor.getName();
        if (this.policyDescriptors.containsKey(id)) {
            this.policyDescriptors.remove(id);
            this.resetSearchPolicies();
        }
    }
}

