/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.publisher.api.AbstractBasePublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.helper.PublicationRelationHelper;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreFolderPublicationNode;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreProxyFactory;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;
import org.nuxeo.ecm.platform.publisher.impl.core.VirtualCoreFolderPublicationNode;

public class SectionPublicationTree
extends AbstractBasePublicationTree
implements PublicationTree {
    private static final long serialVersionUID = 1L;
    protected static final String CAN_ASK_FOR_PUBLISHING = "CanAskForPublishing";
    protected static final String DEFAULT_ROOT_PATH = "/default-domain/sections";
    protected DocumentModel treeRoot;
    protected String sessionId;

    public void initTree(String sid, CoreSession coreSession, Map<String, String> parameters, PublishedDocumentFactory factory, String configName, String title) throws ClientException {
        super.initTree(sid, coreSession, parameters, factory, configName, title);
        PathRef ref = new PathRef(this.rootPath);
        if (coreSession.hasPermission((DocumentRef)ref, "Read")) {
            this.treeRoot = coreSession.getDocument((DocumentRef)new PathRef(this.rootPath));
            this.rootNode = new CoreFolderPublicationNode(this.treeRoot, this.getConfigName(), sid, factory);
        } else {
            this.rootNode = new VirtualCoreFolderPublicationNode(coreSession.getSessionId(), this.rootPath, this.getConfigName(), sid, factory);
            this.sessionId = coreSession.getSessionId();
        }
    }

    protected CoreSession getCoreSession() {
        String coreSessionId = this.treeRoot == null ? this.sessionId : this.treeRoot.getSessionId();
        return CoreInstance.getInstance().getSession(coreSessionId);
    }

    public List<PublishedDocument> getExistingPublishedDocument(DocumentLocation docLoc) throws ClientException {
        ArrayList<PublishedDocument> publishedDocs = new ArrayList<PublishedDocument>();
        DocumentModelList proxies = this.getCoreSession().getProxies(docLoc.getDocRef(), null);
        for (DocumentModel proxy : proxies) {
            if (!proxy.getPathAsString().startsWith(this.rootPath)) continue;
            publishedDocs.add(this.factory.wrapDocumentModel(proxy));
        }
        return publishedDocs;
    }

    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode) throws ClientException {
        SimpleCorePublishedDocument publishedDocument = (SimpleCorePublishedDocument)super.publish(doc, targetNode);
        PublicationRelationHelper.addPublicationRelation(publishedDocument.getProxy(), this);
        return publishedDocument;
    }

    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) throws ClientException {
        SimpleCorePublishedDocument publishedDocument = (SimpleCorePublishedDocument)super.publish(doc, targetNode, params);
        PublicationRelationHelper.addPublicationRelation(publishedDocument.getProxy(), this);
        return publishedDocument;
    }

    public void unpublish(DocumentModel doc, PublicationNode targetNode) throws ClientException {
        List publishedDocs = this.getPublishedDocumentInNode(targetNode);
        for (PublishedDocument pubDoc : publishedDocs) {
            if (!pubDoc.getSourceDocumentRef().equals(doc.getRef())) continue;
            this.unpublish(pubDoc);
        }
    }

    public void unpublish(PublishedDocument publishedDocument) throws ClientException {
        if (!this.accept(publishedDocument)) {
            return;
        }
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        PublicationRelationHelper.removePublicationRelation(proxy);
        this.getCoreSession().removeDocument(proxy.getRef());
        this.getCoreSession().save();
    }

    public PublicationNode getNodeByPath(String path) throws ClientException {
        PathRef docRef = new PathRef(path);
        if (this.coreSession.hasPermission((DocumentRef)docRef, "Read")) {
            return new CoreFolderPublicationNode(this.coreSession.getDocument((DocumentRef)new PathRef(path)), this.getConfigName(), this.getSessionId(), this.factory);
        }
        return new VirtualCoreFolderPublicationNode(this.coreSession.getSessionId(), path, this.getConfigName(), this.sid, this.factory);
    }

    public void release() {
    }

    protected String getDefaultRootPath() {
        return DEFAULT_ROOT_PATH;
    }

    protected PublishedDocumentFactory getDefaultFactory() {
        return new CoreProxyFactory();
    }

    public boolean canPublishTo(PublicationNode publicationNode) throws ClientException {
        if (publicationNode == null || publicationNode.getParent() == null) {
            return false;
        }
        PathRef docRef = new PathRef(publicationNode.getPath());
        return this.coreSession.hasPermission((DocumentRef)docRef, CAN_ASK_FOR_PUBLISHING);
    }

    public boolean canUnpublish(PublishedDocument publishedDocument) throws ClientException {
        if (!this.accept(publishedDocument)) {
            return false;
        }
        PathRef docRef = new PathRef(publishedDocument.getParentPath());
        return this.coreSession.hasPermission((DocumentRef)docRef, "Write");
    }

    public PublishedDocument wrapToPublishedDocument(DocumentModel documentModel) throws ClientException {
        return this.factory.wrapDocumentModel(documentModel);
    }

    public boolean isPublicationNode(DocumentModel documentModel) throws ClientException {
        return documentModel.getPathAsString().startsWith(this.rootPath);
    }

    public PublicationNode wrapToPublicationNode(DocumentModel documentModel) throws ClientException {
        if (!this.isPublicationNode(documentModel)) {
            throw new ClientException("Document " + documentModel.getPathAsString() + " is not a valid publication node.");
        }
        return new CoreFolderPublicationNode(documentModel, this.getConfigName(), this.sid, this.factory);
    }

    protected boolean accept(PublishedDocument publishedDocument) {
        return publishedDocument instanceof SimpleCorePublishedDocument;
    }
}

