/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.CmisBindingFactory;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmisBindingHelper {
    private CmisBindingHelper() {
    }

    public static CmisBinding createBinding(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            throw new CmisRuntimeException("Session parameter not set!");
        }
        if (!parameters.containsKey("org.apache.chemistry.opencmis.binding.spi.type")) {
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.CUSTOM.value());
        }
        BindingType bt = BindingType.fromValue((String)parameters.get("org.apache.chemistry.opencmis.binding.spi.type"));
        switch (bt) {
            case ATOMPUB: {
                return CmisBindingHelper.createAtomPubBinding(parameters);
            }
            case WEBSERVICES: {
                return CmisBindingHelper.createWebServiceBinding(parameters);
            }
            case LOCAL: {
                return CmisBindingHelper.createLocalBinding(parameters);
            }
            case CUSTOM: {
                return CmisBindingHelper.createCustomBinding(parameters);
            }
        }
        throw new CmisRuntimeException("Ambiguous session parameter: " + parameters);
    }

    private static CmisBinding createCustomBinding(Map<String, String> parameters) {
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        CmisBinding binding = factory.createCmisBinding(parameters);
        return binding;
    }

    private static CmisBinding createWebServiceBinding(Map<String, String> parameters) {
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        CmisBinding binding = factory.createCmisWebServicesBinding(parameters);
        return binding;
    }

    private static CmisBinding createAtomPubBinding(Map<String, String> parameters) {
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        CmisBinding binding = factory.createCmisAtomPubBinding(parameters);
        return binding;
    }

    private static CmisBinding createLocalBinding(Map<String, String> parameters) {
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        CmisBinding binding = factory.createCmisLocalBinding(parameters);
        return binding;
    }
}

