/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.Serializable;
import java.util.List;
import javax.annotation.security.PermitAll;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelListener;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelImpl;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelRowEvent;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.contentbrowser.DomainActions;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListDescriptor;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.querymodel.QueryModelActions;

@Name(value="domainActions")
@Scope(value=ScopeType.CONVERSATION)
public class DomainActionsBean
extends InputController
implements DomainActions,
Serializable {
    private static final long serialVersionUID = 4151925677321848635L;
    private static final Log log = LogFactory.getLog(DomainActionsBean.class);
    private static final String QM_USER_DOMAINS = "USER_DOMAINS";
    @In(create=true)
    private transient QueryModelActions queryModelActions;
    @In(create=true, required=false)
    private transient CoreSession documentManager;
    @In(create=true)
    private transient DocumentsListsManager documentsListsManager;
    private transient DocumentModelList domains;

    @Override
    public DocumentModelList getDomains() throws ClientException {
        if (this.domains == null) {
            try {
                this.domains = this.queryModelActions.get(QM_USER_DOMAINS).getDocuments(this.documentManager, new Object[0]);
            }
            catch (Throwable t) {
                throw ClientException.wrap((Throwable)t);
            }
        }
        return this.domains;
    }

    @Override
    @Observer(value={"locationSelectionChanged", "changeableDocumentCreated", "documentChanged"}, create=false)
    @BypassInterceptors
    public void invalidateDomainList() {
        this.domains = null;
    }

    @Override
    public Boolean getCanAddDomains() throws ClientException {
        return this.documentManager.hasPermission(this.documentManager.getRootDocument().getRef(), "AddChildren");
    }

    @Override
    public SelectDataModel getDomainsSelectModel() throws ClientException {
        List selectedDomains = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        SelectDataModelImpl model = new SelectDataModelImpl("CURRENT_SELECTION", (List)this.getDomains(), selectedDomains);
        model.addSelectModelListener((SelectDataModelListener)this);
        return model;
    }

    public void processSelectRowEvent(SelectDataModelRowEvent event) {
        Boolean selection = event.getSelected();
        DocumentModel data = (DocumentModel)event.getRowData();
        if (selection.booleanValue()) {
            if (this.documentsListsManager.getWorkingList("CURRENT_SELECTION") == null) {
                this.documentsListsManager.createWorkingList("CURRENT_SELECTION", new DocumentsListDescriptor("CURRENT_SELECTION"));
            }
            this.documentsListsManager.addToWorkingList("CURRENT_SELECTION", data);
        } else {
            this.documentsListsManager.removeFromWorkingList("CURRENT_SELECTION", data);
        }
    }

    @Override
    public void initialize() {
        log.debug((Object)"Initializing...");
    }

    @Override
    @Destroy
    @Remove
    @PermitAll
    public void destroy() {
        log.debug((Object)"Removing Seam action listener...");
    }

    @PrePassivate
    public void saveState() {
        log.debug((Object)"PrePassivate");
    }

    @PostActivate
    public void readState() {
        log.debug((Object)"PostActivate");
    }
}

