/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.blobholder;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.AbstractBlobHolder;
import org.nuxeo.ecm.core.utils.BlobsExtractor;

public class DocumentBlobHolder
extends AbstractBlobHolder {
    protected final DocumentModel doc;
    protected final String xPath;
    protected String xPathFilename;

    public DocumentBlobHolder(DocumentModel doc, String xPath, String xPathFilename) {
        this.doc = doc;
        this.xPath = xPath;
        this.xPathFilename = xPathFilename;
    }

    public DocumentBlobHolder(DocumentModel doc, String xPath) {
        this(doc, xPath, null);
    }

    @Override
    protected String getBasePath() {
        return this.doc.getPathAsString();
    }

    @Override
    public Blob getBlob() throws ClientException {
        String filename;
        Blob blob = (Blob)((Object)this.doc.getPropertyValue(this.xPath));
        if (blob != null && this.xPathFilename != null && ((filename = blob.getFilename()) == null || "".equals(filename))) {
            blob.setFilename((String)((Object)this.doc.getPropertyValue(this.xPathFilename)));
        }
        return blob;
    }

    @Override
    public void setBlob(Blob blob) throws ClientException {
        this.doc.getProperty(this.xPath).setValue(blob);
        if (this.xPathFilename != null) {
            String filename = blob == null ? null : blob.getFilename();
            this.doc.setPropertyValue(this.xPathFilename, (Serializable)((Object)filename));
        }
    }

    @Override
    public Calendar getModificationDate() throws ClientException {
        return (Calendar)this.doc.getProperty("dublincore", "modified");
    }

    @Override
    public String getHash() throws ClientException {
        String h;
        Blob blob = this.getBlob();
        if (blob != null && (h = blob.getDigest()) != null) {
            return h;
        }
        return this.doc.getId() + this.xPath + this.getModificationDate().toString();
    }

    @Override
    public Serializable getProperty(String name) throws ClientException {
        return this.doc.getPropertyValue(name);
    }

    @Override
    public Map<String, Serializable> getProperties() {
        return this.doc.getPrefetch();
    }

    @Override
    public List<Blob> getBlobs() throws ClientException {
        return new BlobsExtractor().getBlobs(this.doc);
    }
}

