/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.blobholder;

import java.io.IOException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

public class DocumentStringBlobHolder
extends DocumentBlobHolder {
    protected String mt;

    public DocumentStringBlobHolder(DocumentModel doc, String path) {
        super(doc, path);
    }

    public DocumentStringBlobHolder(DocumentModel doc, String path, String mime_type) {
        super(doc, path);
        this.mt = mime_type;
    }

    @Override
    public Blob getBlob() throws ClientException {
        String string = (String)((Object)this.doc.getProperty(this.xPath).getValue());
        if (string == null) {
            return null;
        }
        StringBlob blob = new StringBlob(string, this.mt);
        String ext = ".txt";
        if ("text/html".equals(this.mt)) {
            ext = ".html";
        } else if ("text/xml".equals(this.mt)) {
            ext = ".xml";
        }
        String title = this.doc.getTitle();
        if (!title.endsWith(ext)) {
            title = title.concat(ext);
        }
        blob.setFilename(title);
        return blob;
    }

    @Override
    public void setBlob(Blob blob) throws ClientException {
        if (blob == null) {
            this.doc.getProperty(this.xPath).setValue(null);
            this.mt = null;
        } else {
            String string;
            try {
                string = blob.getString();
            }
            catch (IOException e) {
                throw new ClientException(e);
            }
            this.doc.getProperty(this.xPath).setValue(string);
            this.mt = blob.getMimeType();
        }
    }
}

