/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.NuxeoGroup;

public class NuxeoGroupImpl
implements NuxeoGroup {
    private static final long serialVersionUID = -69828664399387083L;
    private final List<String> users;
    private final List<String> groups;
    private final List<String> parentGroups;
    private String name;

    public NuxeoGroupImpl(String name) {
        if (name == null) {
            throw new IllegalArgumentException("group name cannot be null");
        }
        this.name = name;
        this.users = new ArrayList<String>();
        this.groups = new ArrayList<String>();
        this.parentGroups = new ArrayList<String>();
    }

    @Override
    public List<String> getMemberUsers() {
        return this.users;
    }

    @Override
    public List<String> getMemberGroups() {
        return this.groups;
    }

    @Override
    public List<String> getParentGroups() {
        return this.parentGroups;
    }

    @Override
    public void setMemberUsers(List<String> users) {
        if (users == null) {
            throw new IllegalArgumentException("member users list cannot be null");
        }
        this.users.clear();
        this.users.addAll(users);
    }

    @Override
    public void setMemberGroups(List<String> groups) {
        if (groups == null) {
            throw new IllegalArgumentException("member groups list cannot be null");
        }
        this.groups.clear();
        this.groups.addAll(groups);
    }

    @Override
    public void setParentGroups(List<String> groups) {
        if (groups == null) {
            throw new IllegalArgumentException("parent groups list cannot be null");
        }
        this.parentGroups.clear();
        this.parentGroups.addAll(groups);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof NuxeoGroupImpl) {
            return this.name.equals(((NuxeoGroupImpl)other).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

