/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.local;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.nuxeo.ecm.core.api.local.LoginStack;

public class ClientLoginModule
implements LoginModule {
    protected static final LoginStack globalInstance = LoginStack.synchronizedStack();
    protected static final ThreadLocal<LoginStack> threadInstance = new ThreadLocal<LoginStack>(){

        @Override
        protected LoginStack initialValue() {
            return new LoginStack();
        }
    };
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private boolean useFirstPass;
    private String username;
    private char[] password;
    private String principalClass;
    private LoginStack stack;

    public static LoginStack getThreadLocalLogin() {
        return threadInstance.get();
    }

    public static LoginStack.Entry getCurrentLogin() {
        LoginStack.Entry entry = threadInstance.get().peek();
        if (entry == null) {
            entry = globalInstance.peek();
        }
        return entry;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        String mt = (String)options.get("multi-threaded");
        this.stack = mt != null && Boolean.valueOf(mt) != false ? threadInstance.get() : globalInstance;
        String passwordStacking = (String)options.get("password-stacking");
        this.useFirstPass = passwordStacking != null;
        this.principalClass = (String)options.get("principal-class");
    }

    @Override
    public boolean login() throws LoginException {
        if (this.useFirstPass) {
            return true;
        }
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        NameCallback nc = new NameCallback("User name: ", "guest");
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = nc.getName();
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.password = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
                pc.clearPassword();
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        Principal p;
        Set<Principal> principals = this.subject.getPrincipals();
        Object credential = this.password;
        if (this.useFirstPass) {
            Object user = this.sharedState.get("javax.security.auth.login.name");
            if (!(user instanceof Principal)) {
                this.username = user != null ? user.toString() : "";
                p = this.createPrincipal(this.username);
            } else {
                p = (Principal)user;
            }
            credential = this.sharedState.get("javax.security.auth.login.password");
        } else {
            p = this.createPrincipal(this.username);
        }
        if (!principals.isEmpty()) {
            p = principals.iterator().next();
        }
        this.stack.push(p, credential, this.subject);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        int length = this.password != null ? this.password.length : 0;
        for (int n = 0; n < length; ++n) {
            this.password[n] = '\u0000';
        }
        this.stack.clear();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.stack.pop();
        return true;
    }

    public Principal createPrincipal(final String name) throws LoginException {
        if (this.principalClass != null) {
            try {
                Class<?> klass = Class.forName(this.principalClass);
                Constructor<?> ctor = klass.getConstructor(String.class);
                return (Principal)ctor.newInstance(name);
            }
            catch (Exception e) {
                LoginException ee = new LoginException("Failed to instantiate principal : " + this.principalClass);
                ee.initCause(e);
                throw ee;
            }
        }
        return new Principal(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String toString() {
                return name;
            }

            @Override
            public int hashCode() {
                return name == null ? 0 : name.hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj == this) {
                    return true;
                }
                if (obj instanceof Principal) {
                    String n = ((Principal)obj).getName();
                    if (name == n) {
                        return true;
                    }
                    if (name == null) {
                        return false;
                    }
                    return name.equals(n);
                }
                return false;
            }
        };
    }
}

