/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl.osm;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

public class TypeHierarchyIterator
implements Iterator<Class<?>> {
    final Queue<Class<?>> queue;
    Class<?> type;

    public TypeHierarchyIterator(Class<?> type) {
        this.type = type;
        this.queue = new LinkedList();
    }

    @Override
    public boolean hasNext() {
        return this.type != null;
    }

    @Override
    public Class<?> next() {
        if (this.type == null) {
            throw new NoSuchElementException();
        }
        Class<?> superClass = this.type.getSuperclass();
        if (superClass != null) {
            this.queue.add(superClass);
        }
        for (Class<?> itf : this.type.getInterfaces()) {
            this.queue.add(itf);
        }
        Class<?> prev = this.type;
        this.type = this.queue.poll();
        return prev;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }
}

