/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.core.helper;

import java.io.Serializable;
import java.security.Principal;
import java.util.List;
import org.jbpm.graph.exe.Comment;
import org.jbpm.graph.exe.ExecutionContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.jbpm.AbstractJbpmHandlerHelper;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.VirtualTaskInstance;
import org.nuxeo.runtime.api.Framework;

public class TaskNotificationHandler
extends AbstractJbpmHandlerHelper {
    private static final long serialVersionUID = 1L;
    private static final String DUE_DATE_KEY = "dueDate";
    private static final String DIRECTIVE_KEY = "directive";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext executionContext) throws Exception {
        this.executionContext = executionContext;
        if (this.nuxeoHasStarted()) {
            DocumentModel documentModel = (DocumentModel)this.getTransientVariable(JbpmService.VariableName.document.name());
            NuxeoPrincipal principal = (NuxeoPrincipal)this.getTransientVariable(JbpmService.VariableName.principal.name());
            if (documentModel == null) {
                return;
            }
            CoreSession coreSession = this.getCoreSession(principal);
            try {
                EventProducer eventProducer;
                try {
                    eventProducer = (EventProducer)Framework.getService(EventProducer.class);
                }
                catch (Exception e) {
                    throw new ClientException((Throwable)e);
                }
                DocumentEventContext ctx = new DocumentEventContext(coreSession, (Principal)principal, documentModel);
                ctx.setProperty("recipients", (Serializable)this.getRecipients());
                ctx.setProperty("comment", (Serializable)((Object)this.getComments()));
                ctx.setProperty(DUE_DATE_KEY, (Serializable)executionContext.getTaskInstance().getDueDate());
                ctx.setProperty(DIRECTIVE_KEY, (Serializable)executionContext.getTaskInstance().getVariable(DIRECTIVE_KEY));
                eventProducer.fireEvent(ctx.newEvent("workflowTaskAssigned"));
            }
            finally {
                this.closeCoreSession(coreSession);
            }
        }
    }

    protected String getComments() {
        List comments = this.executionContext.getTaskInstance().getComments();
        return comments == null ? null : ((Comment)comments.get(comments.size() - 1)).getMessage();
    }

    protected String[] getRecipients() {
        VirtualTaskInstance participant = (VirtualTaskInstance)this.getTransientVariable(JbpmService.VariableName.participant.name());
        if (participant == null) {
            participant = (VirtualTaskInstance)this.executionContext.getContextInstance().getVariable(JbpmService.VariableName.participant.name());
        }
        return participant.getActors().toArray(new String[0]);
    }
}

