/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Null;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.impl.DocumentPartImpl;
import org.nuxeo.ecm.core.api.repository.cache.DirtyUpdateChecker;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.NoSuchPropertyException;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;

public class DocumentModelFactory {
    private static final Log log = LogFactory.getLog(DocumentModelFactory.class);

    private DocumentModelFactory() {
    }

    @Deprecated
    public static DocumentModel newDocument(DocumentModel parent, String type) {
        return DocumentModelFactory.newDocument(parent, null, type);
    }

    @Deprecated
    public static DocumentModel newDocument(DocumentModel parent, String name, String type) {
        DocumentType docType = parent.getCoreSession().getDocumentType(type);
        return DocumentModelFactory.newDocument(parent, name, docType);
    }

    @Deprecated
    public static DocumentModel newDocument(DocumentModel parent, DocumentType type) {
        return DocumentModelFactory.newDocument(parent, null, type);
    }

    @Deprecated
    public static DocumentModel newDocument(DocumentModel parent, String name, DocumentType type) {
        return new DocumentModelImpl(null, type.getName(), null, parent.getPath(), null, null, parent.getRef(), null, null, null, parent.getRepositoryName());
    }

    @Deprecated
    public static Map<String, Serializable> updatePrefetch(DocumentModel docModel) {
        HashMap<String, Serializable> prefetchMap = new HashMap<String, Serializable>();
        PrefetchInfo prefetchInfo = docModel.getDocumentType().getPrefetchInfo();
        if (prefetchInfo != null) {
            Field[] prefetchFields;
            for (Field field : prefetchFields = prefetchInfo.getFields()) {
                Object value;
                String typeName = field.getDeclaringType().getName();
                String typeLocalName = field.getName().getLocalName();
                String fieldName = typeName + '.' + typeLocalName;
                try {
                    value = docModel.getProperty(typeName, typeLocalName);
                }
                catch (ClientException e) {
                    continue;
                }
                prefetchMap.put(fieldName, (Serializable)value);
            }
        }
        return prefetchMap;
    }

    public static DocumentModelImpl createDocumentModel(Document doc) throws DocumentException {
        DocumentType docType = doc.getType();
        String[] schemas = docType == null ? null : docType.getSchemaNames();
        return DocumentModelFactory.createDocumentModel(doc, schemas);
    }

    /*
     * WARNING - void declaration
     */
    public static DocumentModelImpl createDocumentModel(Document doc, String[] schemas) throws DocumentException {
        Repository repository;
        DocumentType type = doc.getType();
        if (type == null) {
            throw new DocumentException("Type not found for doc " + doc);
        }
        String sid = doc.getSession().getUserSessionId();
        IdRef docRef = new IdRef(doc.getUUID());
        Document parent = doc.getParent();
        IdRef parentRef = parent == null ? null : new IdRef(parent.getUUID());
        Document sourceDoc = doc.getSourceDocument();
        String sourceId = sourceDoc == null ? null : sourceDoc.getUUID();
        boolean immutable = doc.isVersion() || doc.isProxy() && sourceDoc.isVersion();
        HashSet<String> facets = new HashSet<String>(Arrays.asList(doc.getFacets()));
        if (immutable) {
            facets.add("Immutable");
        }
        String repositoryName = (repository = doc.getRepository()) == null ? null : repository.getName();
        String p = doc.getPath();
        Path path = p == null ? null : new Path(p);
        DocumentModelImpl docModel = new DocumentModelImpl(sid, type.getName(), doc.getUUID(), path, null, (DocumentRef)docRef, (DocumentRef)parentRef, null, facets, sourceId, repositoryName);
        if (doc.isVersion()) {
            docModel.setIsVersion(true);
        }
        if (doc.isProxy()) {
            docModel.setIsProxy(true);
        }
        if (immutable) {
            docModel.setIsImmutable(true);
        }
        Schema[] prefetchSchemas = null;
        PrefetchInfo prefetchInfo = type.getPrefetchInfo();
        if (prefetchInfo != null) {
            void var21_26;
            Field[] prefetchFields;
            prefetchSchemas = prefetchInfo.getSchemas();
            Field[] arr$ = prefetchFields = prefetchInfo.getFields();
            int len$ = arr$.length;
            boolean bl = false;
            while (var21_26 < len$) {
                Field field = arr$[var21_26];
                try {
                    Object value = doc.getPropertyValue(field.getName().getPrefixedName());
                    docModel.prefetchProperty(field.getDeclaringType().getName() + '.' + field.getName().getLocalName(), value);
                }
                catch (NoSuchPropertyException e) {
                }
                catch (DocumentException e) {
                    log.error((Object)"Error while building prefetch fields, check the document configuration", (Throwable)e);
                }
                ++var21_26;
            }
        }
        if (schemas != null) {
            for (String string : schemas) {
                Schema schema = type.getSchema(string);
                if (schema == null) continue;
                docModel.addDataModel(DocumentModelFactory.createDataModel(doc, schema));
            }
        } else if (prefetchSchemas != null) {
            for (String string : prefetchSchemas) {
                docModel.addDataModel(DocumentModelFactory.createDataModel(doc, (Schema)string));
            }
        }
        try {
            String lifeCycleState = doc.getLifeCycleState();
            docModel.prefetchCurrentLifecycleState(lifeCycleState);
            String lifeCyclePolicy = doc.getLifeCyclePolicy();
            docModel.prefetchLifeCyclePolicy(lifeCyclePolicy);
        }
        catch (LifeCycleException e) {
            log.debug((Object)("Cannot prefetch lifecycle for doc: " + doc.getName() + ". Error: " + e.getMessage()));
        }
        DirtyUpdateChecker.check((DocumentModel)docModel);
        return docModel;
    }

    public static DocumentModelImpl createDocumentModel(String docType) {
        try {
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            if (schemaManager == null) {
                throw new ClientRuntimeException("SchemaManager is null");
            }
            DocumentType type = schemaManager.getDocumentType(docType);
            return DocumentModelFactory.createDocumentModel(type);
        }
        catch (ClientRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public static DocumentModelImpl createDocumentModel(String sessionId, DocumentType docType) throws DocumentException {
        DocumentModelImpl docModel = new DocumentModelImpl(sessionId, docType.getName(), null, null, null, null, null, null, null, null, null);
        for (Schema schema : docType.getSchemas()) {
            docModel.addDataModel(DocumentModelFactory.createDataModel(null, schema));
        }
        return docModel;
    }

    public static DocumentModelImpl createDocumentModel(DocumentType docType) throws DocumentException {
        return DocumentModelFactory.createDocumentModel(null, docType);
    }

    @Deprecated
    public static DocumentModelImpl createDocumentModel(String parentPath, String id, DocumentType docType, String[] schemas) throws DocumentException {
        DocumentModelImpl docModel = new DocumentModelImpl(parentPath, id, docType.getName());
        if (schemas != null) {
            for (String schemaName : schemas) {
                Schema schema = docType.getSchema(schemaName);
                docModel.addDataModel(DocumentModelFactory.createDataModel(null, schema));
            }
        }
        return docModel;
    }

    public static DataModel createDataModel(Document doc, Schema schema) throws DocumentException {
        DocumentPartImpl part = new DocumentPartImpl(schema);
        if (doc != null) {
            try {
                doc.readDocumentPart((DocumentPart)part);
            }
            catch (DocumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DocumentException("failed to read document part", (Throwable)e);
            }
        }
        return new DataModelImpl((DocumentPart)part);
    }

    public static DocumentModel writeDocumentModel(DocumentModel docModel, Document doc) throws DocumentException, ClientException {
        DocumentPart[] parts;
        if (!(docModel instanceof DocumentModelImpl)) {
            throw new ClientRuntimeException("Must be a DocumentModelImpl: " + docModel);
        }
        boolean changed = false;
        Set instanceFacets = ((DocumentModelImpl)docModel).instanceFacets;
        Set instanceFacetsOrig = ((DocumentModelImpl)docModel).instanceFacetsOrig;
        HashSet addedFacets = new HashSet(instanceFacets);
        addedFacets.removeAll(instanceFacetsOrig);
        for (String facet : addedFacets) {
            changed = doc.addFacet(facet) || changed;
        }
        HashSet removedFacets = new HashSet(instanceFacetsOrig);
        removedFacets.removeAll(instanceFacets);
        for (String facet : removedFacets) {
            changed = doc.removeFacet(facet) || changed;
        }
        for (DocumentPart part : parts = docModel.getParts()) {
            if (!part.isDirty()) continue;
            try {
                doc.writeDocumentPart(part);
            }
            catch (ClientException e) {
                throw e;
            }
            catch (DocumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ClientException("failed to write document part", (Throwable)e);
            }
            changed = true;
        }
        if (!changed) {
            return docModel;
        }
        DocumentModelImpl newModel = DocumentModelFactory.createDocumentModel(doc, null);
        newModel.copyContextData(docModel);
        return newModel;
    }

    public static DocumentModel.DocumentModelRefresh refreshDocumentModel(Document doc, int flags, String[] schemas) throws DocumentException, LifeCycleException, Exception {
        PrefetchInfo info;
        DocumentModel.DocumentModelRefresh refresh = new DocumentModel.DocumentModelRefresh();
        if ((flags & 4) != 0 && (info = doc.getType().getPrefetchInfo()) != null) {
            Field[] fields;
            Schema[] pschemas = info.getSchemas();
            if (pschemas != null) {
                // empty if block
            }
            if ((fields = info.getFields()) != null) {
                HashMap<String, Null> prefetch = new HashMap<String, Null>();
                for (Field field : fields) {
                    Object value = doc.getPropertyValue(field.getName().getPrefixedName());
                    prefetch.put(field.getDeclaringType().getName() + '.' + field.getName().getLocalName(), (Null)(value == null ? Null.VALUE : (Serializable)value));
                }
                refresh.prefetch = prefetch;
            }
        }
        if ((flags & 1) != 0) {
            refresh.lifeCycleState = doc.getLifeCycleState();
            refresh.lifeCyclePolicy = doc.getLifeCyclePolicy();
            refresh.isCheckedOut = doc.isCheckedOut();
            refresh.isLatestVersion = doc.isLatestVersion();
            refresh.isMajorVersion = doc.isMajorVersion();
            refresh.isLatestMajorVersion = doc.isLatestMajorVersion();
            refresh.isVersionSeriesCheckedOut = doc.isVersionSeriesCheckedOut();
            refresh.versionSeriesId = doc.getVersionSeriesId();
            refresh.checkinComment = doc.getCheckinComment();
        }
        if ((flags & 0x100) != 0) {
            if (schemas == null) {
                schemas = doc.getType().getSchemaNames();
            }
            DocumentType type = doc.getType();
            DocumentPart[] parts = new DocumentPart[schemas.length];
            for (int i = 0; i < schemas.length; ++i) {
                DocumentPartImpl part = new DocumentPartImpl(type.getSchema(schemas[i]));
                doc.readDocumentPart((DocumentPart)part);
                parts[i] = part;
            }
            refresh.documentParts = parts;
        }
        return refresh;
    }
}

