/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.security.SecurityCache;

public class CacheEntry {
    private final String docUid;
    private final String username;
    private final String permission;
    private final SecurityCache cache;
    private Access access;
    private int hash;

    public CacheEntry(SecurityCache cache, String docUid, String username, String permission) {
        this.docUid = docUid;
        this.username = username;
        this.permission = permission;
        this.cache = cache;
    }

    public final void setAccess(Access access) {
        this.access = access;
        if (this.hash == 0) {
            this.cache.put(this);
        }
    }

    public final Access getAccess() {
        return this.access;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = 17;
            h = 37 * h + this.docUid.hashCode();
            h = 37 * h + this.username.hashCode();
            this.hash = 37 * h + this.permission.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof CacheEntry)) {
            return false;
        }
        CacheEntry entry = (CacheEntry)other;
        return entry.docUid.equals(this.docUid) && entry.username.equals(this.username) && entry.permission.equals(this.permission);
    }

    public String toString() {
        return this.docUid + ':' + this.username + ':' + this.permission;
    }
}

