/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.computedgroups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.computedgroups.AbstractGroupComputer;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;

public abstract class AbstractAttributeBasedGroupComputer
extends AbstractGroupComputer {
    protected abstract String getAttributeForGroupComputation();

    @Override
    public List<String> getAllGroupIds() throws Exception {
        ArrayList<String> companies = new ArrayList<String>();
        for (String userId : this.getUM().getUserIds()) {
            String companyName;
            DocumentModel doc = this.getUM().getUserModel(userId);
            if (doc == null || companies.contains(companyName = (String)doc.getProperty(this.getUM().getUserSchemaName(), "company"))) continue;
            companies.add(companyName);
        }
        return companies;
    }

    @Override
    public List<String> getGroupMembers(String groupName) throws Exception {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put(this.getAttributeForGroupComputation(), groupName);
        DocumentModelList users = this.getUM().searchUsers(filter, null);
        ArrayList<String> memberIds = new ArrayList<String>();
        for (DocumentModel user : users) {
            memberIds.add(user.getId());
        }
        return memberIds;
    }

    @Override
    public List<String> getGroupsForUser(NuxeoPrincipalImpl nuxeoPrincipal) throws Exception {
        ArrayList<String> grpNames = new ArrayList<String>();
        String property = (String)nuxeoPrincipal.getModel().getProperty(this.getUM().getUserSchemaName(), this.getAttributeForGroupComputation());
        if (property != null && !"".equals(property.trim())) {
            grpNames.add(property);
        }
        return grpNames;
    }

    @Override
    public List<String> getParentsGroupNames(String groupName) throws Exception {
        return null;
    }

    @Override
    public List<String> getSubGroupsNames(String groupName) throws Exception {
        return null;
    }

    @Override
    public List<String> searchGroups(Map<String, Serializable> filter, HashSet<String> fulltext) throws Exception {
        ArrayList<String> companies = new ArrayList<String>();
        String grpName = (String)((Object)filter.get(this.getUM().getGroupIdField()));
        if (grpName != null) {
            HashMap<String, String> gFilter = new HashMap<String, String>();
            HashSet<String> gFulltext = new HashSet<String>();
            gFilter.put(this.getAttributeForGroupComputation(), grpName);
            gFulltext.add(this.getAttributeForGroupComputation());
            for (DocumentModel userDoc : this.getUM().searchUsers(gFilter, gFulltext)) {
                String companyName = (String)userDoc.getProperty(this.getUM().getUserSchemaName(), this.getAttributeForGroupComputation());
                if (companies.contains(companyName)) continue;
                companies.add(companyName);
            }
        }
        return companies;
    }
}

