/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.computedgroups;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.platform.computedgroups.ComputedGroup;
import org.nuxeo.ecm.platform.computedgroups.ComputedGroupsService;
import org.nuxeo.runtime.api.Framework;

public class NuxeoComputedGroup
implements ComputedGroup {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected List<String> parents;
    protected List<String> subGroups;
    protected List<String> members;

    public NuxeoComputedGroup(String name) {
        this.name = name;
    }

    public List<String> getMemberUsers() {
        if (this.members == null) {
            ComputedGroupsService cgs = (ComputedGroupsService)Framework.getLocalService(ComputedGroupsService.class);
            if (cgs != null) {
                this.members = cgs.getComputedGroupMembers(this.name);
            }
            if (this.members == null) {
                this.members = new ArrayList<String>();
            }
        }
        return this.members;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParentGroups() {
        if (this.parents == null) {
            ComputedGroupsService cgs = (ComputedGroupsService)Framework.getLocalService(ComputedGroupsService.class);
            if (cgs != null) {
                this.parents = cgs.getComputedGroupParent(this.name);
            }
            if (this.parents == null) {
                this.parents = new ArrayList<String>();
            }
        }
        return this.parents;
    }

    public List<String> getMemberGroups() {
        if (this.subGroups == null) {
            ComputedGroupsService cgs = (ComputedGroupsService)Framework.getLocalService(ComputedGroupsService.class);
            if (cgs != null) {
                this.subGroups = cgs.getComputedGroupSubGroups(this.name);
            }
            if (this.subGroups == null) {
                this.subGroups = new ArrayList<String>();
            }
        }
        return this.subGroups;
    }

    public void setMemberGroups(List<String> groups) {
        throw new UnsupportedOperationException("Computed groups are read only");
    }

    public void setMemberUsers(List<String> users) {
        throw new UnsupportedOperationException("Computed groups are read only");
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("Computed groups are read only");
    }

    public void setParentGroups(List<String> groups) {
        throw new UnsupportedOperationException("Computed groups are read only");
    }
}

