/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.computedgroups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.platform.computedgroups.ComputedGroupsService;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManagerImpl;
import org.nuxeo.runtime.api.Framework;

public class UserManagerWithComputedGroups
extends UserManagerImpl {
    private static final long serialVersionUID = 1L;
    protected static ComputedGroupsService cgs;
    protected static Boolean useComputedGroup;
    public static final String VIRTUAL_GROUP_MARKER = "__virtualGroup";

    protected ComputedGroupsService getService() {
        if (cgs == null) {
            cgs = (ComputedGroupsService)Framework.getLocalService(ComputedGroupsService.class);
        }
        return cgs;
    }

    protected boolean activateComputedGroup() {
        if (useComputedGroup == null) {
            useComputedGroup = this.getService().activateComputedGroups();
        }
        return useComputedGroup;
    }

    @Override
    protected NuxeoPrincipal makePrincipal(DocumentModel userEntry, boolean anonymous, List<String> groups) throws ClientException {
        NuxeoPrincipal principal = super.makePrincipal(userEntry, anonymous, groups);
        if (this.activateComputedGroup() && principal instanceof NuxeoPrincipalImpl) {
            ArrayList<String> origVGroups;
            NuxeoPrincipalImpl nuxPrincipal = (NuxeoPrincipalImpl)principal;
            List<String> vGroups = this.getService().computeGroupsForUser(nuxPrincipal);
            if (vGroups == null) {
                vGroups = new ArrayList<String>();
            }
            if ((origVGroups = nuxPrincipal.getVirtualGroups()) == null) {
                origVGroups = new ArrayList<String>();
            }
            origVGroups.addAll(vGroups);
            nuxPrincipal.setVirtualGroups(origVGroups);
            if (!Framework.isTestModeSet()) {
                nuxPrincipal.updateAllGroups();
            } else {
                List allGroups = nuxPrincipal.getGroups();
                for (String vGroup : vGroups) {
                    if (allGroups.contains(vGroup)) continue;
                    allGroups.add(vGroup);
                }
                nuxPrincipal.setGroups(allGroups);
            }
        }
        return principal;
    }

    @Override
    public NuxeoGroup getGroup(String groupName) throws ClientException {
        NuxeoGroup computed;
        NuxeoGroup grp = super.getGroup(groupName);
        if (this.activateComputedGroup() && (grp == null || this.getService().allowGroupOverride()) && (computed = this.getService().getComputedGroup(groupName)) != null) {
            grp = computed;
        }
        return grp;
    }

    @Override
    public List<String> getGroupIds() throws ClientException {
        List<String> ids = super.getGroupIds();
        if (this.activateComputedGroup()) {
            List<String> vGroups = this.getService().computeGroupIds();
            for (String vGroup : vGroups) {
                if (ids.contains(vGroup)) continue;
                ids.add(vGroup);
            }
        }
        return ids;
    }

    @Override
    public DocumentModel getGroupModel(String groupName) throws ClientException {
        DocumentModel grpDoc = super.getGroupModel(groupName);
        if (this.activateComputedGroup() && grpDoc == null) {
            return this.getComputedGroupAsDocumentModel(groupName);
        }
        return grpDoc;
    }

    @Override
    public DocumentModelList searchGroups(Map<String, Serializable> filter, HashSet<String> fulltext) throws ClientException {
        boolean searchInVirtualGroups = this.activateComputedGroup();
        if (Boolean.FALSE.equals(filter.get(VIRTUAL_GROUP_MARKER))) {
            searchInVirtualGroups = false;
        }
        this.removeVirtualFilters(filter);
        DocumentModelList groups = super.searchGroups(filter, fulltext);
        if (searchInVirtualGroups) {
            for (String vGroupName : this.getService().searchComputedGroups(filter, fulltext)) {
                DocumentModel vGroup = this.getComputedGroupAsDocumentModel(vGroupName);
                if (vGroup == null || groups.contains((Object)vGroup)) continue;
                groups.add((Object)vGroup);
            }
        }
        return groups;
    }

    protected DocumentModel getComputedGroupAsDocumentModel(String grpName) throws ClientException {
        NuxeoGroup grp = this.getService().getComputedGroup(grpName);
        if (grp == null) {
            return null;
        }
        String schemaName = this.getGroupSchemaName();
        String id = this.getGroupIdField();
        DocumentModel groupDoc = BaseSession.createEntryModel(null, (String)schemaName, (String)grpName, null);
        groupDoc.setProperty(schemaName, this.getGroupMembersField(), (Object)grp.getMemberUsers());
        groupDoc.setProperty(schemaName, id, (Object)grp.getName());
        groupDoc.setProperty(schemaName, this.getGroupIdField(), (Object)grp.getName());
        ScopedMap contextData = groupDoc.getContextData();
        contextData.putScopedValue("virtual", (Serializable)Boolean.TRUE);
        return groupDoc;
    }
}

