/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.UserManagerDescriptor;
import org.nuxeo.ecm.platform.usermanager.VirtualUser;
import org.nuxeo.ecm.platform.usermanager.VirtualUserDescriptor;

public class FakeUserManagerImpl
implements UserManager {
    private static final long serialVersionUID = 1L;
    String userListingMode;
    String groupListingMode;
    List<String> defaultAdministratorIds;
    List<String> administratorsGroups;
    String defaultGroup;
    String userSortField;
    String groupSortField;
    String userDirectoryName;
    String userEmailField;
    Map<String, UserManager.MatchType> userSearchFields;
    Pattern userPasswordPattern;
    String groupDirectoryName;
    String groupMembersField;
    String groupSubGroupsField;
    String groupParentGroupsField;
    VirtualUser anonymousUser;
    final Map<String, VirtualUserDescriptor> virtualUsers = new HashMap<String, VirtualUserDescriptor>();

    public String getUserListingMode() {
        return this.userListingMode;
    }

    public void setUserListingMode(String userListingMode) {
        this.userListingMode = userListingMode;
    }

    public String getGroupListingMode() {
        return this.groupListingMode;
    }

    public void setGroupListingMode(String groupListingMode) {
        this.groupListingMode = groupListingMode;
    }

    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public String getUserSortField() {
        return this.userSortField;
    }

    public void setUserSortField(String sortField) {
        this.userSortField = sortField;
    }

    public void setGroupSortField(String sortField) {
        this.groupSortField = sortField;
    }

    public void setUserDirectoryName(String userDirectoryName) {
        this.userDirectoryName = userDirectoryName;
    }

    public String getUserDirectoryName() {
        return this.userDirectoryName;
    }

    public void setUserEmailField(String userEmailField) {
        this.userEmailField = userEmailField;
    }

    public String getUserEmailField() {
        return this.userEmailField;
    }

    public void setUserSearchFields(Set<String> userSearchFields) {
        this.userSearchFields = new LinkedHashMap<String, UserManager.MatchType>();
        for (String searchField : userSearchFields) {
            this.userSearchFields.put(searchField, UserManager.MatchType.SUBSTRING);
        }
    }

    public void setUserSearchFields(Map<String, UserManager.MatchType> userSearchFields) {
        this.userSearchFields = userSearchFields;
    }

    public Set<String> getUserSearchFields() {
        return this.userSearchFields.keySet();
    }

    public void setGroupDirectoryName(String groupDirectoryName) {
        this.groupDirectoryName = groupDirectoryName;
    }

    public String getGroupDirectoryName() {
        return this.groupDirectoryName;
    }

    public void setGroupMembersField(String groupMembersField) {
        this.groupMembersField = groupMembersField;
    }

    public String getGroupMembersField() {
        return this.groupMembersField;
    }

    public void setGroupSubGroupsField(String groupSubGroupsField) {
        this.groupSubGroupsField = groupSubGroupsField;
    }

    public String getGroupSubGroupsField() {
        return this.groupSubGroupsField;
    }

    public void setGroupParentGroupsField(String groupParentGroupsField) {
        this.groupParentGroupsField = groupParentGroupsField;
    }

    public String getGroupParentGroupsField() {
        return this.groupParentGroupsField;
    }

    public Boolean areGroupsReadOnly() throws ClientException {
        throw new UnsupportedOperationException();
    }

    public Boolean areUsersReadOnly() throws ClientException {
        throw new UnsupportedOperationException();
    }

    public boolean checkUsernamePassword(String username, String password) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public boolean validatePassword(String password) {
        if (this.userPasswordPattern == null) {
            return true;
        }
        Matcher userPasswordMatcher = this.userPasswordPattern.matcher(password);
        return userPasswordMatcher.find();
    }

    public List<String> getGroupsInGroup(String parentId) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public NuxeoPrincipal getPrincipal(String username) throws ClientException {
        NuxeoPrincipalImpl principal = new NuxeoPrincipalImpl("Administrator", false, true);
        principal.setGroups(Arrays.asList("administrators"));
        principal.setEmail("admin@example.com");
        return principal;
    }

    public List<String> getTopLevelGroups() throws ClientException {
        throw new UnsupportedOperationException();
    }

    public List<String> getUsersInGroup(String groupId) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public List<String> getUsersInGroupAndSubGroups(String groupId) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public List<NuxeoGroup> searchGroups(String pattern) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public List<NuxeoPrincipal> searchPrincipals(String pattern) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public Pattern getUserPasswordPattern() {
        return this.userPasswordPattern;
    }

    public void setUserPasswordPattern(Pattern userPasswordPattern) {
        this.userPasswordPattern = userPasswordPattern;
    }

    public void setAnonymousUser(VirtualUser anonymousUser) {
        this.anonymousUser = anonymousUser;
    }

    public void setVirtualUsers(Map<String, VirtualUserDescriptor> virtualUsers) {
        this.virtualUsers.clear();
        if (virtualUsers != null) {
            this.virtualUsers.putAll(virtualUsers);
        }
    }

    public String getAnonymousUserId() {
        if (this.anonymousUser == null) {
            return null;
        }
        return this.anonymousUser.getId();
    }

    public String getDigestAuthDirectory() {
        return null;
    }

    public String getDigestAuthRealm() {
        return null;
    }

    public void setConfiguration(UserManagerDescriptor descriptor) {
        this.setDefaultGroup(descriptor.defaultGroup);
        this.defaultAdministratorIds = descriptor.defaultAdministratorIds;
        this.administratorsGroups = descriptor.administratorsGroups;
        this.setUserSortField(descriptor.userSortField);
        this.setGroupSortField(descriptor.groupSortField);
        this.setUserListingMode(descriptor.userListingMode);
        this.setGroupListingMode(descriptor.groupListingMode);
        this.setUserDirectoryName(descriptor.userDirectoryName);
        this.setUserEmailField(descriptor.userEmailField);
        this.setUserSearchFields(descriptor.userSearchFields);
        this.setUserPasswordPattern(descriptor.userPasswordPattern);
        this.setGroupDirectoryName(descriptor.groupDirectoryName);
        this.setGroupMembersField(descriptor.groupMembersField);
        this.setGroupSubGroupsField(descriptor.groupSubGroupsField);
        this.setGroupParentGroupsField(descriptor.groupParentGroupsField);
        this.setAnonymousUser((VirtualUser)descriptor.anonymousUser);
        this.setVirtualUsers(descriptor.virtualUsers);
    }

    public DocumentModel getBareUserModel() throws ClientException {
        throw new UnsupportedOperationException();
    }

    public DocumentModel createGroup(DocumentModel groupModel) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public DocumentModel createUser(DocumentModel userModel) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void deleteGroup(DocumentModel groupModel) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void deleteGroup(String groupId) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void deleteUser(DocumentModel userModel) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void deleteUser(String userId) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public DocumentModel getBareGroupModel() throws ClientException {
        throw new UnsupportedOperationException();
    }

    public NuxeoGroup getGroup(String groupName) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public List<String> getGroupIds() throws ClientException {
        throw new UnsupportedOperationException();
    }

    public List<String> getUserIds() throws ClientException {
        throw new UnsupportedOperationException();
    }

    public DocumentModelList searchGroups(Map<String, Serializable> filter, HashSet<String> fulltext) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public DocumentModelList searchUsers(Map<String, Serializable> filter, Set<String> fulltext) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public DocumentModelList searchUsers(String pattern) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void updateGroup(DocumentModel groupModel) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void updateUser(DocumentModel userModel) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public DocumentModel getGroupModel(String groupName) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public DocumentModel getUserModel(String userName) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public String getGroupIdField() throws ClientException {
        return "groupname";
    }

    public String getGroupSchemaName() throws ClientException {
        return "group";
    }

    public String getUserIdField() throws ClientException {
        return "username";
    }

    public String getUserSchemaName() throws ClientException {
        return "user";
    }

    public void createGroup(NuxeoGroup group) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void createPrincipal(NuxeoPrincipal principal) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void deleteGroup(NuxeoGroup group) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void deletePrincipal(NuxeoPrincipal principal) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public List<NuxeoGroup> getAvailableGroups() throws ClientException {
        throw new UnsupportedOperationException();
    }

    public List<NuxeoPrincipal> getAvailablePrincipals() throws ClientException {
        throw new UnsupportedOperationException();
    }

    public DocumentModel getModelForUser(String name) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public List<NuxeoPrincipal> searchByMap(Map<String, Serializable> filter, Set<String> pattern) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void updateGroup(NuxeoGroup group) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void updatePrincipal(NuxeoPrincipal principal) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public List<String> getAdministratorsGroups() {
        throw new UnsupportedOperationException();
    }

    public String[] getUsersForPermission(String perm, ACP acp) {
        throw new UnsupportedOperationException();
    }

    public Principal authenticate(String name, String password) throws ClientException {
        return this.checkUsernamePassword(name, password) ? this.getPrincipal(name) : null;
    }
}

