/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemLifeCycleListener;
import org.apache.jackrabbit.core.LazyItemIterator;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.core.version.VersionHistoryImpl;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemManager
implements ItemLifeCycleListener,
Dumpable,
ItemStateListener {
    private static Logger log = LoggerFactory.getLogger((Class)ItemManager.class);
    private final NodeDefinition rootNodeDef;
    private final NodeId rootNodeId;
    protected final SessionImpl session;
    private final ItemStateManager itemStateProvider;
    private final HierarchyManager hierMgr;
    private final Map itemCache;

    protected ItemManager(SessionItemStateManager itemStateProvider, HierarchyManager hierMgr, SessionImpl session, NodeDefinition rootNodeDef, NodeId rootNodeId) {
        this.itemStateProvider = itemStateProvider;
        this.hierMgr = hierMgr;
        this.session = session;
        this.rootNodeDef = rootNodeDef;
        this.rootNodeId = rootNodeId;
        this.itemCache = new ReferenceMap(0, 2);
        itemStateProvider.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Map map = this.itemCache;
        synchronized (map) {
            this.itemCache.clear();
        }
    }

    private NodeDefinition getDefinition(NodeState state) throws RepositoryException {
        NodeDefId defId = state.getDefinitionId();
        NodeDefinitionImpl def = this.session.getNodeTypeManager().getNodeDefinition(defId);
        if (def == null) {
            log.warn("node at " + this.safeGetJCRPath(state.getNodeId()) + " has invalid definitionId (" + defId + ")");
            NodeImpl parent = (NodeImpl)this.getItem(state.getParentId());
            NodeState parentState = (NodeState)parent.getItemState();
            NodeState.ChildNodeEntry cne = parentState.getChildNodeEntry(state.getNodeId());
            def = parent.getApplicableChildNodeDefinition(cne.getName(), state.getNodeTypeName());
            state.setDefinitionId(def.unwrap().getId());
        }
        return def;
    }

    private PropertyDefinition getDefinition(PropertyState state) throws RepositoryException {
        PropDefId defId = state.getDefinitionId();
        PropertyDefinitionImpl def = this.session.getNodeTypeManager().getPropertyDefinition(defId);
        if (def == null) {
            log.warn("property at " + this.safeGetJCRPath(state.getPropertyId()) + " has invalid definitionId (" + defId + ")");
            NodeImpl parent = (NodeImpl)this.getItem(state.getParentId());
            def = parent.getApplicablePropertyDefinition(state.getName(), state.getType(), state.isMultiValued(), true);
            state.setDefinitionId(def.unwrap().getId());
        }
        return def;
    }

    private ItemState getItemState(ItemId id) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        if (!this.session.getAccessManager().isGranted(id, 1)) {
            ItemImpl item = this.retrieveItem(id);
            if (item != null) {
                this.evictItem(id);
            }
            throw new AccessDeniedException("cannot read item " + id);
        }
        try {
            return this.itemStateProvider.getItemState(id);
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "no such item: " + id;
            log.debug(msg);
            throw new ItemNotFoundException(msg);
        }
        catch (ItemStateException ise) {
            String msg = "failed to retrieve item state of " + id;
            log.error(msg);
            throw new RepositoryException(msg, (Throwable)((Object)ise));
        }
    }

    public boolean itemExists(Path path) {
        try {
            this.session.sanityCheck();
            ItemId id = this.hierMgr.resolvePath(path);
            return id != null && this.itemExists(id);
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public boolean nodeExists(Path path) {
        try {
            this.session.sanityCheck();
            NodeId id = this.hierMgr.resolveNodePath(path);
            return id != null && this.itemExists(id);
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public boolean propertyExists(Path path) {
        try {
            this.session.sanityCheck();
            PropertyId id = this.hierMgr.resolvePropertyPath(path);
            return id != null && this.itemExists(id);
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public boolean itemExists(ItemId id) {
        try {
            this.session.sanityCheck();
            if (!this.itemStateProvider.hasItemState(id)) {
                return false;
            }
            if (!this.session.getAccessManager().isGranted(id, 1)) {
                this.evictItem(id);
                return false;
            }
            return true;
        }
        catch (ItemNotFoundException infe) {
            return false;
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    NodeImpl getRootNode() throws RepositoryException {
        return (NodeImpl)this.getItem(this.rootNodeId);
    }

    public ItemImpl getItem(Path path) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        ItemId id = this.hierMgr.resolvePath(path);
        if (id == null) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
        try {
            return this.getItem(id);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
    }

    public NodeImpl getNode(Path path) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        NodeId id = this.hierMgr.resolveNodePath(path);
        if (id == null) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
        try {
            return (NodeImpl)this.getItem(id);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
    }

    public PropertyImpl getProperty(Path path) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        PropertyId id = this.hierMgr.resolvePropertyPath(path);
        if (id == null) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
        try {
            return (PropertyImpl)this.getItem(id);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
    }

    public synchronized ItemImpl getItem(ItemId id) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.session.sanityCheck();
        ItemImpl item = this.retrieveItem(id);
        if (item == null) {
            if (!this.session.getAccessManager().isGranted(id, 1)) {
                throw new AccessDeniedException("cannot read item " + id);
            }
            item = this.createItemInstance(id);
        }
        return item;
    }

    public synchronized ItemImpl getItem(ItemState state) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.session.sanityCheck();
        ItemId id = state.getId();
        ItemImpl item = this.retrieveItem(id);
        if (item == null) {
            if (state.getStatus() != 4 && !this.session.getAccessManager().isGranted(id, 1)) {
                throw new AccessDeniedException("cannot read item " + id);
            }
            item = this.createItemInstance(id);
        }
        return item;
    }

    synchronized boolean hasChildNodes(NodeId parentId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.session.sanityCheck();
        ItemState state = this.getItemState(parentId);
        if (!state.isNode()) {
            String msg = "can't list child nodes of property " + parentId;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeState nodeState = (NodeState)state;
        Iterator iter = nodeState.getChildNodeEntries().iterator();
        while (iter.hasNext()) {
            NodeState.ChildNodeEntry entry = (NodeState.ChildNodeEntry)iter.next();
            if (!this.session.getAccessManager().isGranted(entry.getId(), 1)) continue;
            return true;
        }
        return false;
    }

    synchronized NodeIterator getChildNodes(NodeId parentId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.session.sanityCheck();
        ItemState state = this.getItemState(parentId);
        if (!state.isNode()) {
            String msg = "can't list child nodes of property " + parentId;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeState nodeState = (NodeState)state;
        ArrayList<NodeId> childIds = new ArrayList<NodeId>();
        Iterator iter = nodeState.getChildNodeEntries().iterator();
        while (iter.hasNext()) {
            NodeState.ChildNodeEntry entry = (NodeState.ChildNodeEntry)iter.next();
            if (!this.session.getAccessManager().isGranted(entry.getId(), 1)) continue;
            childIds.add(entry.getId());
        }
        return new LazyItemIterator(this, childIds);
    }

    synchronized boolean hasChildProperties(NodeId parentId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.session.sanityCheck();
        ItemState state = this.getItemState(parentId);
        if (!state.isNode()) {
            String msg = "can't list child properties of property " + parentId;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeState nodeState = (NodeState)state;
        Iterator iter = nodeState.getPropertyNames().iterator();
        while (iter.hasNext()) {
            Name propName = (Name)iter.next();
            if (!this.session.getAccessManager().isGranted(new PropertyId(parentId, propName), 1)) continue;
            return true;
        }
        return false;
    }

    synchronized PropertyIterator getChildProperties(NodeId parentId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.session.sanityCheck();
        ItemState state = this.getItemState(parentId);
        if (!state.isNode()) {
            String msg = "can't list child properties of property " + parentId;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeState nodeState = (NodeState)state;
        ArrayList<PropertyId> childIds = new ArrayList<PropertyId>();
        Iterator iter = nodeState.getPropertyNames().iterator();
        while (iter.hasNext()) {
            Name propName = (Name)iter.next();
            PropertyId id = new PropertyId(parentId, propName);
            if (!this.session.getAccessManager().isGranted(id, 1)) continue;
            childIds.add(id);
        }
        return new LazyItemIterator(this, childIds);
    }

    private ItemImpl createItemInstance(ItemId id) throws ItemNotFoundException, RepositoryException {
        ItemState state;
        try {
            state = this.itemStateProvider.getItemState(id);
        }
        catch (NoSuchItemStateException nsise) {
            throw new ItemNotFoundException(id.toString());
        }
        catch (ItemStateException ise) {
            String msg = "failed to retrieve item state of item " + id;
            log.error(msg, (Throwable)((Object)ise));
            throw new RepositoryException(msg, (Throwable)((Object)ise));
        }
        ItemImpl item = id.equals(this.rootNodeId) ? this.createNodeInstance((NodeState)state, this.rootNodeDef) : (state.isNode() ? this.createNodeInstance((NodeState)state) : this.createPropertyInstance((PropertyState)state));
        return item;
    }

    NodeImpl createNodeInstance(NodeState state, NodeDefinition def) throws RepositoryException {
        NodeId id = state.getNodeId();
        ItemLifeCycleListener[] listeners = new ItemLifeCycleListener[]{this};
        if (state.getNodeTypeName().equals(NameConstants.NT_VERSION)) {
            return this.createVersionInstance(id, state, def, listeners);
        }
        if (state.getNodeTypeName().equals(NameConstants.NT_VERSIONHISTORY)) {
            return this.createVersionHistoryInstance(id, state, def, listeners);
        }
        return new NodeImpl(this, this.session, id, state, def, listeners);
    }

    NodeImpl createNodeInstance(NodeState state) throws RepositoryException {
        NodeDefinition def = this.getDefinition(state);
        return this.createNodeInstance(state, def);
    }

    PropertyImpl createPropertyInstance(PropertyState state, PropertyDefinition def) {
        ItemLifeCycleListener[] listeners = new ItemLifeCycleListener[]{this};
        return new PropertyImpl(this, this.session, state.getPropertyId(), state, def, listeners);
    }

    PropertyImpl createPropertyInstance(PropertyState state) throws RepositoryException {
        PropertyDefinition def = this.getDefinition(state);
        return this.createPropertyInstance(state, def);
    }

    protected VersionImpl createVersionInstance(NodeId id, NodeState state, NodeDefinition def, ItemLifeCycleListener[] listeners) throws RepositoryException {
        return new VersionImpl(this, this.session, id, state, def, listeners);
    }

    protected VersionHistoryImpl createVersionHistoryInstance(NodeId id, NodeState state, NodeDefinition def, ItemLifeCycleListener[] listeners) throws RepositoryException {
        return new VersionHistoryImpl(this, this.session, id, state, def, listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemImpl retrieveItem(ItemId id) {
        Map map = this.itemCache;
        synchronized (map) {
            return (ItemImpl)this.itemCache.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheItem(ItemImpl item) {
        Map map = this.itemCache;
        synchronized (map) {
            ItemId id = item.getId();
            if (this.itemCache.containsKey(id)) {
                log.warn("overwriting cached item " + id);
            }
            if (log.isDebugEnabled()) {
                log.debug("caching item " + id);
            }
            this.itemCache.put(id, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictItem(ItemId id) {
        if (log.isDebugEnabled()) {
            log.debug("removing item " + id + " from cache");
        }
        Map map = this.itemCache;
        synchronized (map) {
            this.itemCache.remove(id);
        }
    }

    String safeGetJCRPath(Path path) {
        try {
            return this.session.getJCRPath(path);
        }
        catch (NamespaceException e) {
            log.error("failed to convert " + path.toString() + " to JCR path.");
            return path.toString();
        }
    }

    String safeGetJCRPath(ItemId id) {
        try {
            return this.safeGetJCRPath(this.hierMgr.getPath(id));
        }
        catch (RepositoryException re) {
            log.error(id + ": failed to determine path to");
            return id.toString();
        }
    }

    public void itemCreated(ItemImpl item) {
        if (log.isDebugEnabled()) {
            log.debug("created item " + item.getId());
        }
        this.cacheItem(item);
    }

    public void itemInvalidated(ItemId id, ItemImpl item) {
        if (log.isDebugEnabled()) {
            log.debug("invalidated item " + id);
        }
        this.evictItem(id);
    }

    public void itemDestroyed(ItemId id, ItemImpl item) {
        if (log.isDebugEnabled()) {
            log.debug("destroyed item " + id);
        }
        item.removeLifeCycleListener(this);
        this.evictItem(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dump(PrintStream ps) {
        ps.println("ItemManager (" + this + ")");
        ps.println();
        ps.println("Items in cache:");
        ps.println();
        Map map = this.itemCache;
        synchronized (map) {
            Iterator iter = this.itemCache.keySet().iterator();
            while (iter.hasNext()) {
                ItemId id = (ItemId)iter.next();
                ItemImpl item = (ItemImpl)this.itemCache.get(id);
                if (item.isNode()) {
                    ps.print("Node: ");
                } else {
                    ps.print("Property: ");
                }
                if (item.isTransient()) {
                    ps.print("transient ");
                } else {
                    ps.print("          ");
                }
                ps.println(id + "\t" + item.safeGetJCRPath() + " (" + item + ")");
            }
        }
    }

    public void stateCreated(ItemState created) {
        ItemImpl item = this.retrieveItem(created.getId());
        if (item != null) {
            item.stateCreated(created);
        }
    }

    public void stateModified(ItemState modified) {
        ItemImpl item = this.retrieveItem(modified.getId());
        if (item != null) {
            item.stateModified(modified);
        }
    }

    public void stateDestroyed(ItemState destroyed) {
        ItemImpl item = this.retrieveItem(destroyed.getId());
        if (item != null) {
            item.stateDestroyed(destroyed);
        }
    }

    public void stateDiscarded(ItemState discarded) {
        ItemImpl item = this.retrieveItem(discarded.getId());
        if (item != null) {
            item.stateDiscarded(discarded);
        }
    }
}

