/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.jackrabbit.util.LazyFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleMonitor {
    private static Logger log = LoggerFactory.getLogger((Class)HandleMonitor.class);
    private HashMap openHandles = new HashMap();

    public InputStream open(File file) throws FileNotFoundException {
        Handle handle = this.getHandle(file);
        InputStream in = handle.open();
        return in;
    }

    public boolean isOpen(File file) {
        return this.openHandles.containsKey(file);
    }

    private void close(File file) {
        this.openHandles.remove(file);
    }

    private Handle getHandle(File file) {
        Handle handle = (Handle)this.openHandles.get(file);
        if (handle == null) {
            handle = new Handle(file);
            this.openHandles.put(file, handle);
        }
        return handle;
    }

    public void dump() {
        log.info("Number of open files: " + this.openHandles.size());
        Iterator iter = this.openHandles.keySet().iterator();
        while (iter.hasNext()) {
            File file = (File)iter.next();
            Handle handle = (Handle)this.openHandles.get(file);
            handle.dump();
        }
    }

    public void dump(File file) {
        Handle handle = (Handle)this.openHandles.get(file);
        if (handle != null) {
            handle.dump(true);
        }
    }

    private class Handle {
        private File file;
        private HashSet streams = new HashSet();

        private Handle(File file) {
            this.file = file;
        }

        private InputStream open() throws FileNotFoundException {
            MonitoredInputStream in = new MonitoredInputStream(this.file);
            this.streams.add(in);
            return in;
        }

        private void close(MonitoredInputStream in) {
            this.streams.remove((Object)in);
            if (this.streams.isEmpty()) {
                HandleMonitor.this.close(this.file);
            }
        }

        private void dump() {
            this.dump(false);
        }

        private void dump(boolean detailed) {
            if (detailed) {
                log.info("- " + this.file.getPath() + ", " + this.streams.size());
                Iterator iter = this.streams.iterator();
                while (iter.hasNext()) {
                    MonitoredInputStream in = (MonitoredInputStream)((Object)iter.next());
                    in.dump();
                }
            } else {
                log.info("- " + this.file.getPath() + ", " + this.streams.size());
            }
        }

        private class MonitoredInputStream
        extends LazyFileInputStream {
            private final Throwable throwable;

            private MonitoredInputStream(File file) throws FileNotFoundException {
                super(file);
                this.throwable = new Exception();
            }

            private void dump() {
                log.info("- opened by : ", this.throwable);
            }

            public void close() throws IOException {
                Handle.this.close(this);
                super.close();
            }
        }
    }
}

