/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jackrabbit.core.journal.ReadRecord;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRecordLog {
    private static Logger log = LoggerFactory.getLogger((Class)FileRecordLog.class);
    private static final byte[] SIGNATURE = new byte[]{74, 76, 79, 71};
    private static final short MAJOR_VERSION = 2;
    private static final short MINOR_VERSION = 0;
    private static final int HEADER_SIZE = 16;
    private File logFile;
    private boolean isNew;
    private DataInputStream in;
    private long previousRevision;
    private long position;
    private long lastRevision;
    private short major;
    private short minor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileRecordLog(File logFile) throws IOException {
        this.logFile = logFile;
        if (logFile.exists()) {
            DataInputStream in = new DataInputStream(new FileInputStream(logFile));
            try {
                this.readHeader(in);
                this.previousRevision = in.readLong();
                this.lastRevision = this.previousRevision + logFile.length() - 16L;
            }
            finally {
                FileRecordLog.close(in);
            }
        } else {
            this.isNew = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(long previousRevision) throws IOException {
        if (this.isNew) {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(this.logFile));
            try {
                this.writeHeader(out);
                out.writeLong(previousRevision);
            }
            finally {
                FileRecordLog.close(out);
            }
            this.previousRevision = this.lastRevision = previousRevision;
            this.isNew = false;
        }
    }

    public boolean contains(long revision) {
        return revision >= this.previousRevision && revision < this.lastRevision;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean exceeds(long size) {
        return this.lastRevision - this.previousRevision > size;
    }

    public void seek(long revision) throws IOException {
        if (this.in != null) {
            String msg = "Stream already open: seek() only allowed once.";
            throw new IllegalStateException(msg);
        }
        this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.logFile)));
        this.skip(revision - this.previousRevision + 16L);
        this.position = revision - this.previousRevision;
    }

    private void skip(long n) throws IOException {
        long skiplen;
        long skipped;
        for (skiplen = n; skiplen > 0L && (skipped = this.in.skip(skiplen)) > 0L; skiplen -= skipped) {
        }
        if (skiplen != 0L) {
            String msg = "Unable to skip remaining bytes.";
            throw new IOException(msg);
        }
    }

    public ReadRecord read(NamespaceResolver resolver, NamePathResolver npResolver) throws IOException {
        String journalId = this.in.readUTF();
        String producerId = this.in.readUTF();
        int length = this.in.readInt();
        this.position += (long)(2 + FileRecordLog.utfLength(journalId) + 2 + FileRecordLog.utfLength(producerId) + 4 + length);
        long revision = this.previousRevision + this.position;
        return new ReadRecord(journalId, producerId, revision, this.in, length, resolver, npResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long append(String journalId, String producerId, InputStream in, int length) throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.logFile, true));
        try {
            int len;
            out.writeUTF(journalId);
            out.writeUTF(producerId);
            out.writeInt(length);
            byte[] buffer = new byte[8192];
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.flush();
            this.lastRevision += (long)(2 + FileRecordLog.utfLength(journalId) + 2 + FileRecordLog.utfLength(producerId) + 4 + length);
            long l = this.lastRevision;
            return l;
        }
        finally {
            FileRecordLog.close(out);
        }
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            String msg = "Error while closing record log: " + e.getMessage();
            log.warn(msg);
        }
    }

    private void readHeader(DataInputStream in) throws IOException {
        byte[] signature = new byte[SIGNATURE.length];
        in.readFully(signature);
        for (int i = 0; i < SIGNATURE.length; ++i) {
            if (signature[i] == SIGNATURE[i]) continue;
            String msg = "Record log '" + this.logFile.getPath() + "' has wrong signature: " + FileRecordLog.toHexString(signature);
            throw new IOException(msg);
        }
        this.major = in.readShort();
        if (this.major != 2) {
            String msg = "Record log '" + this.logFile.getPath() + "' has incompatible major version: " + this.major;
            throw new IOException(msg);
        }
        this.minor = in.readShort();
    }

    private void writeHeader(DataOutputStream out) throws IOException {
        out.write(SIGNATURE);
        out.writeShort(2);
        out.writeShort(0);
    }

    private static void close(InputStream in) {
        try {
            in.close();
        }
        catch (IOException e) {
            String msg = "I/O error while closing input stream.";
            log.warn(msg, (Throwable)e);
        }
    }

    private static void close(OutputStream out) {
        try {
            out.close();
        }
        catch (IOException e) {
            String msg = "I/O error while closing input stream.";
            log.warn(msg, (Throwable)e);
        }
    }

    private static String toHexString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            String s = Integer.toHexString(b[i] & 0xFF).toUpperCase();
            if (s.length() == 1) {
                buf.append('0');
            }
            buf.append(s);
        }
        return buf.toString();
    }

    private static int utfLength(String s) {
        char[] ac = s.toCharArray();
        int utflen = 0;
        for (int i = 0; i < ac.length; ++i) {
            char c = ac[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }
}

