/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeTypeCache;
import org.apache.jackrabbit.spi.Name;

public class EffectiveNodeTypeCacheImpl
implements EffectiveNodeTypeCache {
    private final TreeSet sortedKeys = new TreeSet();
    private final HashMap aggregates = new HashMap();

    EffectiveNodeTypeCacheImpl() {
    }

    public EffectiveNodeTypeCache.Key getKey(Name[] ntNames) {
        return new WeightedKey(ntNames);
    }

    public void put(EffectiveNodeType ent) {
        int weight = ent.getMergedNodeTypes().length;
        WeightedKey k = new WeightedKey(ent.getMergedNodeTypes(), weight);
        this.put(k, ent);
    }

    public void put(EffectiveNodeTypeCache.Key key, EffectiveNodeType ent) {
        this.aggregates.put(key, ent);
        this.sortedKeys.add(key);
    }

    public boolean contains(EffectiveNodeTypeCache.Key key) {
        return this.aggregates.containsKey(key);
    }

    public EffectiveNodeType get(EffectiveNodeTypeCache.Key key) {
        return (EffectiveNodeType)this.aggregates.get(key);
    }

    private EffectiveNodeType remove(EffectiveNodeTypeCache.Key key) {
        EffectiveNodeType removed = (EffectiveNodeType)this.aggregates.remove(key);
        if (removed != null) {
            Iterator iter = this.sortedKeys.iterator();
            while (iter.hasNext()) {
                EffectiveNodeTypeCache.Key k = (EffectiveNodeTypeCache.Key)iter.next();
                if (!key.equals(k)) continue;
                this.sortedKeys.remove(k);
                break;
            }
        }
        return removed;
    }

    public void invalidate(Name name) {
        ArrayList keys = new ArrayList(this.sortedKeys);
        Iterator keysIter = keys.iterator();
        while (keysIter.hasNext()) {
            EffectiveNodeTypeCache.Key k = (EffectiveNodeTypeCache.Key)keysIter.next();
            EffectiveNodeType ent = this.get(k);
            if (!ent.includesNodeType(name)) continue;
            this.remove(k);
        }
    }

    public EffectiveNodeTypeCache.Key findBest(EffectiveNodeTypeCache.Key key) {
        if (this.contains(key)) {
            return key;
        }
        Iterator iter = this.sortedKeys.iterator();
        while (iter.hasNext()) {
            EffectiveNodeTypeCache.Key k = (EffectiveNodeTypeCache.Key)iter.next();
            if (!key.contains(k)) continue;
            return k;
        }
        return null;
    }

    public Object clone() {
        EffectiveNodeTypeCacheImpl clone = new EffectiveNodeTypeCacheImpl();
        clone.sortedKeys.addAll(this.sortedKeys);
        clone.aggregates.putAll(this.aggregates);
        return clone;
    }

    public void dump(PrintStream ps) {
        ps.println("EffectiveNodeTypeCache (" + this + ")");
        ps.println();
        ps.println("EffectiveNodeTypes in cache:");
        ps.println();
        Iterator iter = this.sortedKeys.iterator();
        while (iter.hasNext()) {
            EffectiveNodeTypeCache.Key k = (EffectiveNodeTypeCache.Key)iter.next();
            ps.println(k);
        }
    }

    private static class WeightedKey
    implements EffectiveNodeTypeCache.Key {
        private final Name[] names;
        private final int weight;

        WeightedKey(Name[] ntNames) {
            this(ntNames, ntNames.length);
        }

        WeightedKey(Name[] ntNames, int weight) {
            this.weight = weight;
            this.names = new Name[ntNames.length];
            System.arraycopy(ntNames, 0, this.names, 0, this.names.length);
            Arrays.sort(this.names);
        }

        WeightedKey(Collection ntNames) {
            this(ntNames, ntNames.size());
        }

        WeightedKey(Collection ntNames, int weight) {
            this(ntNames.toArray(new Name[ntNames.size()]), weight);
        }

        public Name[] getNames() {
            return this.names;
        }

        public boolean contains(EffectiveNodeTypeCache.Key otherKey) {
            WeightedKey key = (WeightedKey)otherKey;
            HashSet<Name> tmp = new HashSet<Name>(Arrays.asList(this.names));
            for (int i = 0; i < key.names.length; ++i) {
                if (tmp.contains(key.names[i])) continue;
                return false;
            }
            return true;
        }

        public EffectiveNodeTypeCache.Key subtract(EffectiveNodeTypeCache.Key otherKey) {
            WeightedKey key = (WeightedKey)otherKey;
            HashSet<Name> tmp = new HashSet<Name>(Arrays.asList(this.names));
            tmp.removeAll(Arrays.asList(key.names));
            return new WeightedKey(tmp);
        }

        public int compareTo(Object o) {
            WeightedKey other = (WeightedKey)o;
            if (this.weight > other.weight) {
                return -1;
            }
            if (this.weight < other.weight) {
                return 1;
            }
            int len1 = this.names.length;
            int len2 = other.names.length;
            int len = Math.min(len1, len2);
            for (int i = 0; i < len; ++i) {
                Name name1 = this.names[i];
                Name name2 = other.names[i];
                int result = name1.compareTo((Object)name2);
                if (result == 0) continue;
                return result;
            }
            return len1 - len2;
        }

        public int hashCode() {
            int h = 17;
            for (int i = 0; i < this.names.length; ++i) {
                h *= 37;
                h += this.names[i].hashCode();
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof WeightedKey) {
                WeightedKey other = (WeightedKey)obj;
                return Arrays.equals(this.names, other.names);
            }
            return false;
        }

        public String toString() {
            return Arrays.asList(this.names).toString() + " (" + this.weight + ")";
        }
    }
}

