/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.CachingPersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.bundle.util.BundleCache;
import org.apache.jackrabbit.core.persistence.bundle.util.HashMapIndex;
import org.apache.jackrabbit.core.persistence.bundle.util.LRUNodeIdCache;
import org.apache.jackrabbit.core.persistence.bundle.util.NamespaceIndex;
import org.apache.jackrabbit.core.persistence.bundle.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.bundle.util.StringIndex;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBundlePersistenceManager
implements PersistenceManager,
CachingPersistenceManager,
IterablePersistenceManager {
    static final String CVS_ID = "$URL: http://svn.eu.apache.org/repos/asf/jackrabbit/tags/jackrabbit-core-1.4.5/src/main/java/org/apache/jackrabbit/core/persistence/bundle/AbstractBundlePersistenceManager.java $ $Rev: 650499 $ $Date: 2008-04-22 15:53:52 +0300 (Tue, 22 Apr 2008) $";
    private static Logger log = LoggerFactory.getLogger((Class)AbstractBundlePersistenceManager.class);
    protected static final String NODEFILENAME = "n";
    protected static final String NODEREFSFILENAME = "r";
    protected static final String RES_NAME_INDEX = "/names.properties";
    protected static final String RES_NS_INDEX = "/namespaces.properties";
    private StringIndex nsIndex;
    private StringIndex nameIndex;
    private BundleCache bundles;
    private LRUNodeIdCache missing;
    private PropDefId idJcrUUID;
    private PropDefId idJcrPrimaryType;
    private PropDefId idJcrMixinTypes;
    protected PMContext context;
    private long bundleCacheSize = 0x800000L;

    public String getBundleCacheSize() {
        return String.valueOf(this.bundleCacheSize / 0x100000L);
    }

    public void setBundleCacheSize(String bundleCacheSize) {
        this.bundleCacheSize = Long.parseLong(bundleCacheSize) * 1024L * 1024L;
    }

    protected StringBuffer buildNodeFolderPath(StringBuffer buf, NodeId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        char[] chars = id.getUUID().toString().toCharArray();
        int cnt = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '-') continue;
            if (cnt == 2 || cnt == 4) {
                buf.append('/');
            }
            buf.append(chars[i]);
            ++cnt;
        }
        return buf;
    }

    protected StringBuffer buildPropFilePath(StringBuffer buf, PropertyId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildNodeFolderPath(buf, id.getParentId());
        buf.append("/");
        buf.append(this.getNsIndex().stringToIndex(id.getName().getNamespaceURI()));
        buf.append('.');
        buf.append(this.getNameIndex().stringToIndex(id.getName().getLocalName()));
        return buf;
    }

    protected StringBuffer buildBlobFilePath(StringBuffer buf, PropertyId id, int i) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildPropFilePath(buf, id);
        buf.append('.');
        buf.append(i);
        return buf;
    }

    protected StringBuffer buildNodeFilePath(StringBuffer buf, NodeId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildNodeFolderPath(buf, id);
        buf.append("/");
        buf.append(NODEFILENAME);
        return buf;
    }

    protected StringBuffer buildNodeReferencesFilePath(StringBuffer buf, NodeReferencesId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildNodeFolderPath(buf, id.getTargetId());
        buf.append("/");
        buf.append(NODEREFSFILENAME);
        return buf;
    }

    public StringIndex getNsIndex() {
        try {
            if (this.nsIndex == null) {
                FileSystemResource nsFile = new FileSystemResource(this.context.getFileSystem(), RES_NS_INDEX);
                this.nsIndex = nsFile.exists() ? new HashMapIndex(nsFile) : new NamespaceIndex((NamespaceRegistryImpl)this.context.getNamespaceRegistry());
            }
            return this.nsIndex;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create nsIndex." + e);
        }
    }

    public StringIndex getNameIndex() {
        try {
            if (this.nameIndex == null) {
                this.nameIndex = new HashMapIndex(new FileSystemResource(this.context.getFileSystem(), RES_NAME_INDEX));
            }
            return this.nameIndex;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create nsIndex." + e);
        }
    }

    public synchronized void onExternalUpdate(ChangeLog changes) {
        ItemState state;
        Iterator iter = changes.modifiedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode()) {
                this.bundles.remove((NodeId)state.getId());
                continue;
            }
            this.bundles.remove(state.getParentId());
        }
        iter = changes.deletedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode()) {
                this.bundles.remove((NodeId)state.getId());
                continue;
            }
            this.bundles.remove(state.getParentId());
        }
        iter = changes.addedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode()) {
                this.missing.remove((NodeId)state.getId());
                continue;
            }
            this.missing.remove(state.getParentId());
        }
    }

    protected abstract NodePropBundle loadBundle(NodeId var1) throws ItemStateException;

    protected abstract boolean existsBundle(NodeId var1) throws ItemStateException;

    protected abstract void storeBundle(NodePropBundle var1) throws ItemStateException;

    protected abstract void destroyBundle(NodePropBundle var1) throws ItemStateException;

    public abstract NodeReferences load(NodeReferencesId var1) throws NoSuchItemStateException, ItemStateException;

    protected abstract void destroy(NodeReferences var1) throws ItemStateException;

    protected abstract void store(NodeReferences var1) throws ItemStateException;

    protected abstract BundleBinding getBinding();

    public void init(PMContext context) throws Exception {
        this.context = context;
        this.bundles = new BundleCache(this.bundleCacheSize);
        this.missing = new LRUNodeIdCache();
        if (context.getNodeTypeRegistry() != null) {
            this.idJcrUUID = context.getNodeTypeRegistry().getEffectiveNodeType(NameConstants.MIX_REFERENCEABLE).getApplicablePropertyDef(NameConstants.JCR_UUID, 1, false).getId();
            this.idJcrPrimaryType = context.getNodeTypeRegistry().getEffectiveNodeType(NameConstants.NT_BASE).getApplicablePropertyDef(NameConstants.JCR_PRIMARYTYPE, 7, false).getId();
            this.idJcrMixinTypes = context.getNodeTypeRegistry().getEffectiveNodeType(NameConstants.NT_BASE).getApplicablePropertyDef(NameConstants.JCR_MIXINTYPES, 7, true).getId();
        }
    }

    public synchronized NodeState load(NodeId id) throws NoSuchItemStateException, ItemStateException {
        NodePropBundle bundle = this.getBundle(id);
        if (bundle == null) {
            throw new NoSuchItemStateException(id.toString());
        }
        return bundle.createNodeState(this);
    }

    public synchronized PropertyState load(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        NodePropBundle bundle = this.getBundle(id.getParentId());
        if (bundle == null) {
            throw new NoSuchItemStateException(id.toString());
        }
        PropertyState state = bundle.createPropertyState(this, id.getName());
        if (state == null) {
            if (id.getName().equals(NameConstants.JCR_UUID)) {
                state = this.createNew(id);
                state.setType(1);
                state.setDefinitionId(this.idJcrUUID);
                state.setMultiValued(false);
                state.setValues(new InternalValue[]{InternalValue.create(id.getParentId().getUUID().toString())});
            } else if (id.getName().equals(NameConstants.JCR_PRIMARYTYPE)) {
                state = this.createNew(id);
                state.setType(7);
                state.setDefinitionId(this.idJcrPrimaryType);
                state.setMultiValued(false);
                state.setValues(new InternalValue[]{InternalValue.create(bundle.getNodeTypeName())});
            } else if (id.getName().equals(NameConstants.JCR_MIXINTYPES)) {
                Set mixins = bundle.getMixinTypeNames();
                state = this.createNew(id);
                state.setType(7);
                state.setDefinitionId(this.idJcrMixinTypes);
                state.setMultiValued(true);
                state.setValues(InternalValue.create(mixins.toArray(new Name[mixins.size()])));
            } else {
                throw new NoSuchItemStateException(id.toString());
            }
            bundle.addProperty(state);
        }
        return state;
    }

    public synchronized boolean exists(PropertyId id) throws ItemStateException {
        NodePropBundle bundle = this.getBundle(id.getParentId());
        return bundle != null && bundle.hasProperty(id.getName());
    }

    public synchronized boolean exists(NodeId id) throws ItemStateException {
        return this.getBundle(id) != null;
    }

    public NodeState createNew(NodeId id) {
        return new NodeState(id, null, null, 4, false);
    }

    public PropertyState createNew(PropertyId id) {
        return new PropertyState(id, 4, false);
    }

    public synchronized void store(ChangeLog changeLog) throws ItemStateException {
        NodePropBundle bundle;
        NodeId nodeId;
        PropertyId id;
        ItemState state;
        NodePropBundle bundle2;
        HashSet<ItemId> deleted = new HashSet<ItemId>();
        Iterator iter = changeLog.deletedStates();
        while (iter.hasNext()) {
            ItemState state2 = (ItemState)iter.next();
            if (!state2.isNode()) continue;
            bundle2 = this.getBundle((NodeId)state2.getId());
            if (bundle2 == null) {
                throw new NoSuchItemStateException(state2.getId().toString());
            }
            this.deleteBundle(bundle2);
            deleted.add(state2.getId());
        }
        HashMap<ItemId, NodePropBundle> modified = new HashMap<ItemId, NodePropBundle>();
        iter = changeLog.addedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (!state.isNode()) continue;
            NodePropBundle bundle3 = new NodePropBundle(this.getBinding(), (NodeState)state);
            modified.put(state.getId(), bundle3);
        }
        iter = changeLog.modifiedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode()) {
                NodeId nodeId2 = (NodeId)state.getId();
                NodePropBundle bundle4 = (NodePropBundle)modified.get(nodeId2);
                if (bundle4 == null) {
                    bundle4 = this.getBundle(nodeId2);
                    if (bundle4 == null) {
                        throw new NoSuchItemStateException(nodeId2.toString());
                    }
                    modified.put(nodeId2, bundle4);
                }
                bundle4.update((NodeState)state);
                continue;
            }
            id = (PropertyId)state.getId();
            if (id.getName().equals(NameConstants.JCR_PRIMARYTYPE) || id.getName().equals(NameConstants.JCR_MIXINTYPES) || id.getName().equals(NameConstants.JCR_UUID)) continue;
            nodeId = id.getParentId();
            bundle = (NodePropBundle)modified.get(nodeId);
            if (bundle == null) {
                bundle = this.getBundle(nodeId);
                if (bundle == null) {
                    throw new NoSuchItemStateException(nodeId.toString());
                }
                modified.put(nodeId, bundle);
            }
            bundle.addProperty((PropertyState)state);
        }
        iter = changeLog.deletedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode()) {
                NodeId parentId = state.getParentId();
                if (modified.containsKey(parentId) || deleted.contains(parentId)) continue;
                log.warn("Deleted node state's parent is not modified or deleted: " + parentId + "/" + state.getId());
                continue;
            }
            id = (PropertyId)state.getId();
            nodeId = id.getParentId();
            if (deleted.contains(nodeId)) continue;
            bundle = (NodePropBundle)modified.get(nodeId);
            if (bundle == null) {
                log.warn("deleted property state's parent not modified!");
                bundle = this.getBundle(nodeId);
                if (bundle == null) {
                    throw new NoSuchItemStateException(nodeId.toString());
                }
                modified.put(nodeId, bundle);
            }
            bundle.removeProperty(id.getName());
        }
        iter = changeLog.addedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode() || (id = (PropertyId)state.getId()).getName().equals(NameConstants.JCR_PRIMARYTYPE) || id.getName().equals(NameConstants.JCR_MIXINTYPES) || id.getName().equals(NameConstants.JCR_UUID)) continue;
            nodeId = id.getParentId();
            bundle = (NodePropBundle)modified.get(nodeId);
            if (bundle == null) {
                log.warn("added property state's parent not modified!");
                bundle = this.getBundle(nodeId);
                if (bundle == null) {
                    throw new NoSuchItemStateException(nodeId.toString());
                }
                modified.put(nodeId, bundle);
            }
            bundle.addProperty((PropertyState)state);
        }
        iter = modified.values().iterator();
        while (iter.hasNext()) {
            bundle2 = (NodePropBundle)iter.next();
            this.putBundle(bundle2);
        }
        iter = changeLog.modifiedRefs();
        while (iter.hasNext()) {
            NodeReferences refs = (NodeReferences)iter.next();
            if (refs.hasReferences()) {
                this.store(refs);
                continue;
            }
            this.destroy(refs);
        }
    }

    private NodePropBundle getBundle(NodeId id) throws ItemStateException {
        if (this.missing.contains(id)) {
            return null;
        }
        NodePropBundle bundle = this.bundles.get(id);
        if (bundle == null) {
            bundle = this.loadBundle(id);
            if (bundle != null) {
                bundle.markOld();
                this.bundles.put(bundle);
            } else {
                this.missing.put(id);
            }
        }
        return bundle;
    }

    private void deleteBundle(NodePropBundle bundle) throws ItemStateException {
        this.destroyBundle(bundle);
        bundle.removeAllProperties();
        this.bundles.remove(bundle.getId());
        this.missing.put(bundle.getId());
    }

    private void putBundle(NodePropBundle bundle) throws ItemStateException {
        this.storeBundle(bundle);
        bundle.markOld();
        log.debug("stored bundle " + bundle.getId());
        this.missing.remove(bundle.getId());
        if (this.bundles.contains(bundle.getId())) {
            this.bundles.put(bundle);
        }
    }

    public void checkConsistency(String[] uuids, boolean recursive, boolean fix) {
    }

    protected void evictBundle(NodeId id) {
        this.bundles.remove(id);
    }
}

