/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import java.sql.SQLException;
import java.sql.Statement;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.bundle.BundleDbPersistenceManager;

public class H2PersistenceManager
extends BundleDbPersistenceManager {
    static final String CVS_ID = "$URL: http://svn.eu.apache.org/repos/asf/jackrabbit/tags/jackrabbit-core-1.4.5/src/main/java/org/apache/jackrabbit/core/persistence/bundle/H2PersistenceManager.java $ $Rev: 661631 $ $Date: 2008-05-30 13:19:40 +0300 (Fri, 30 May 2008) $";
    private long lockTimeout = 10000L;

    public String getLockTimeout() {
        return String.valueOf(this.lockTimeout);
    }

    public void setLockTimeout(String lockTimeout) {
        this.lockTimeout = Long.parseLong(lockTimeout);
    }

    public void init(PMContext context) throws Exception {
        if (this.getDriver() == null) {
            this.setDriver("org.h2.Driver");
        }
        if (this.getUrl() == null) {
            this.setUrl("jdbc:h2:file:" + context.getHomeDir().getPath() + "/db/itemState");
        }
        if (this.getSchema() == null) {
            this.setSchema("h2");
        }
        if (this.getSchemaObjectPrefix() == null) {
            this.setSchemaObjectPrefix("");
        }
        super.init(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSchema() throws SQLException, RepositoryException {
        Statement stmt = this.connectionManager.getConnection().createStatement();
        try {
            stmt.execute("SET LOCK_TIMEOUT " + this.lockTimeout);
        }
        finally {
            stmt.close();
        }
        super.checkSchema();
    }
}

