/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import org.apache.commons.collections.map.LinkedMap;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.persistence.bundle.util.NodePropBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleCache {
    static final String CVS_ID = "$URL: http://svn.eu.apache.org/repos/asf/jackrabbit/tags/jackrabbit-core-1.4.5/src/main/java/org/apache/jackrabbit/core/persistence/bundle/util/BundleCache.java $ $Rev: 517150 $ $Date: 2007-03-12 11:42:12 +0200 (Mon, 12 Mar 2007) $";
    private static Logger log = LoggerFactory.getLogger((Class)BundleCache.class);
    private long curSize = 0L;
    private long maxSize;
    private long hits = 0L;
    private long misses = 0L;
    private LinkedMap bundles = new LinkedMap();

    public BundleCache(long maxSize) {
        this.maxSize = maxSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public NodePropBundle get(NodeId id) {
        Entry entry = (Entry)this.bundles.remove((Object)id);
        if (entry != null) {
            this.bundles.put((Object)id, (Object)entry);
            ++this.hits;
        } else {
            ++this.misses;
        }
        if (log.isInfoEnabled() && (this.hits + this.misses) % 10000L == 0L) {
            long c = this.curSize / 1024L;
            long m = this.maxSize / 1024L;
            long a = this.bundles.size() > 0 ? this.curSize / (long)this.bundles.size() : 0L;
            log.info("num=" + this.bundles.size() + " mem=" + c + "k max=" + m + "k avg=" + a + " hits=" + this.hits + " miss=" + this.misses);
        }
        return entry == null ? null : entry.bundle;
    }

    public void put(NodePropBundle bundle) {
        Entry entry = (Entry)this.bundles.remove((Object)bundle.getId());
        if (entry == null) {
            entry = new Entry(bundle, bundle.getSize());
        } else {
            this.curSize -= entry.size;
            entry.bundle = bundle;
            entry.size = bundle.getSize();
        }
        this.bundles.put((Object)bundle.getId(), (Object)entry);
        this.curSize += entry.size;
        while (this.curSize > this.maxSize) {
            entry = (Entry)this.bundles.remove(0);
            this.curSize -= entry.size;
        }
    }

    public boolean contains(NodeId id) {
        return this.bundles.containsKey((Object)id);
    }

    public NodePropBundle remove(NodeId id) {
        Entry entry = (Entry)this.bundles.remove((Object)id);
        if (entry != null) {
            this.curSize -= entry.size;
            return entry.bundle;
        }
        return null;
    }

    public void clear() {
        this.bundles.clear();
        this.curSize = 0L;
        this.hits = 0L;
        this.misses = 0L;
    }

    private static final class Entry {
        private NodePropBundle bundle;
        private long size;

        public Entry(NodePropBundle bundle, long size) {
            this.bundle = bundle;
            this.size = size;
        }
    }
}

