/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.core.query.QueryNode;
import org.apache.jackrabbit.core.query.QueryNodeVisitor;

public abstract class NAryQueryNode
extends QueryNode {
    private static final Object[] EMPTY = new Object[0];
    protected List operands = null;

    public NAryQueryNode(QueryNode parent) {
        super(parent);
    }

    public NAryQueryNode(QueryNode parent, QueryNode[] operands) {
        super(parent);
        if (operands.length > 0) {
            this.operands = new ArrayList();
            this.operands.addAll(Arrays.asList(operands));
        }
    }

    public void addOperand(QueryNode operand) {
        if (this.operands == null) {
            this.operands = new ArrayList();
        }
        this.operands.add(operand);
    }

    public boolean removeOperand(QueryNode operand) {
        if (this.operands == null) {
            return false;
        }
        return this.operands.remove(operand);
    }

    public QueryNode[] getOperands() {
        if (this.operands == null) {
            return new QueryNode[0];
        }
        return this.operands.toArray(new QueryNode[this.operands.size()]);
    }

    public int getNumOperands() {
        if (this.operands == null) {
            return 0;
        }
        return this.operands.size();
    }

    public Object[] acceptOperands(QueryNodeVisitor visitor, Object data) {
        if (this.operands == null) {
            return EMPTY;
        }
        ArrayList<Object> result = new ArrayList<Object>(this.operands.size());
        for (int i = 0; i < this.operands.size(); ++i) {
            Object r = ((QueryNode)this.operands.get(i)).accept(visitor, data);
            if (r == null) continue;
            result.add(r);
        }
        return result.toArray();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NAryQueryNode) {
            NAryQueryNode other = (NAryQueryNode)obj;
            return this.operands == null ? other.operands == null : ((Object)this.operands).equals(other.operands);
        }
        return false;
    }

    public boolean needsSystemTree() {
        if (this.operands == null) {
            return false;
        }
        Iterator iter = this.operands.iterator();
        while (iter.hasNext()) {
            QueryNode queryNode = (QueryNode)iter.next();
            if (!queryNode.needsSystemTree()) continue;
            return true;
        }
        return false;
    }
}

