/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.query.lucene.AggregateRule;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.util.Text;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AggregateRuleImpl
implements AggregateRule {
    private final NameResolver resolver;
    private final Name nodeTypeName;
    private final Rule[] rules;
    private final ItemStateManager ism;
    private final HierarchyManager hmgr;

    AggregateRuleImpl(Node config, NameResolver resolver, ItemStateManager ism, HierarchyManager hmgr) throws MalformedPathException, IllegalNameException, NamespaceException {
        this.resolver = resolver;
        this.nodeTypeName = this.getNodeTypeName(config);
        this.rules = this.getRules(config);
        this.ism = ism;
        this.hmgr = hmgr;
    }

    public NodeState getAggregateRoot(NodeState nodeState) throws ItemStateException, RepositoryException {
        for (int i = 0; i < this.rules.length; ++i) {
            NodeState aggregateRoot = this.rules[i].matches(nodeState);
            if (aggregateRoot == null || !aggregateRoot.getNodeTypeName().equals(this.nodeTypeName)) continue;
            return aggregateRoot;
        }
        return null;
    }

    public NodeState[] getAggregatedNodeStates(NodeState nodeState) throws ItemStateException {
        if (nodeState.getNodeTypeName().equals(this.nodeTypeName)) {
            ArrayList<NodeState> nodeStates = new ArrayList<NodeState>();
            for (int i = 0; i < this.rules.length; ++i) {
                nodeStates.addAll(Arrays.asList(this.rules[i].resolve(nodeState)));
            }
            if (nodeStates.size() > 0) {
                return nodeStates.toArray(new NodeState[nodeStates.size()]);
            }
        }
        return null;
    }

    private Name getNodeTypeName(Node config) throws IllegalNameException, NamespaceException {
        String ntString = config.getAttributes().getNamedItem("primaryType").getNodeValue();
        return this.resolver.getQName(ntString);
    }

    private Rule[] getRules(Node config) throws MalformedPathException, IllegalNameException, NamespaceException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        NodeList childNodes = config.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!n.getNodeName().equals("include")) continue;
            Name ntName = null;
            Node ntAttr = n.getAttributes().getNamedItem("primaryType");
            if (ntAttr != null) {
                ntName = this.resolver.getQName(ntAttr.getNodeValue());
            }
            String[] elements = Text.explode((String)AggregateRuleImpl.getTextContent(n), (int)47);
            PathBuilder builder = new PathBuilder();
            for (int j = 0; j < elements.length; ++j) {
                if (elements[j].equals("*")) {
                    builder.addLast(NameConstants.ANY_NAME);
                    continue;
                }
                builder.addLast(this.resolver.getQName(elements[j]));
            }
            rules.add(new Rule(builder.getPath(), ntName));
        }
        return rules.toArray(new Rule[rules.size()]);
    }

    private static String getTextContent(Node node) {
        StringBuffer content = new StringBuffer();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 3) continue;
            content.append(((CharacterData)n).getData());
        }
        return content.toString();
    }

    private final class Rule {
        private final Name nodeTypeName;
        private final Path pattern;

        private Rule(Path pattern, Name nodeTypeName) {
            this.nodeTypeName = nodeTypeName;
            this.pattern = pattern;
        }

        NodeState matches(NodeState nodeState) throws ItemStateException, RepositoryException {
            if (this.nodeTypeName == null || nodeState.getNodeTypeName().equals(this.nodeTypeName)) {
                Path.Element[] elements = this.pattern.getElements();
                for (int e = elements.length - 1; e >= 0; --e) {
                    NodeId parentId = nodeState.getParentId();
                    if (parentId == null) {
                        return null;
                    }
                    NodeState parent = (NodeState)AggregateRuleImpl.this.ism.getItemState(parentId);
                    if (elements[e].getName().getLocalName().equals("*")) {
                        nodeState = parent;
                        continue;
                    }
                    Name name = AggregateRuleImpl.this.hmgr.getName(nodeState.getId());
                    if (elements[e].getName().equals(name)) {
                        nodeState = parent;
                        continue;
                    }
                    return null;
                }
                return nodeState;
            }
            return null;
        }

        NodeState[] resolve(NodeState nodeState) throws ItemStateException {
            ArrayList nodeStates = new ArrayList();
            this.resolve(nodeState, nodeStates, 0);
            return nodeStates.toArray(new NodeState[nodeStates.size()]);
        }

        private void resolve(NodeState nodeState, List collector, int offset) throws ItemStateException {
            Name currentName = this.pattern.getElements()[offset].getName();
            List cne = currentName.getLocalName().equals("*") ? nodeState.getChildNodeEntries() : nodeState.getChildNodeEntries(currentName);
            if (this.pattern.getLength() - 1 == offset) {
                Iterator it = cne.iterator();
                while (it.hasNext()) {
                    NodeId id = ((NodeState.ChildNodeEntry)it.next()).getId();
                    NodeState ns = (NodeState)AggregateRuleImpl.this.ism.getItemState(id);
                    if (this.nodeTypeName != null && !ns.getNodeTypeName().equals(this.nodeTypeName)) continue;
                    collector.add(ns);
                }
            } else {
                ++offset;
                Iterator it = cne.iterator();
                while (it.hasNext()) {
                    NodeId id = ((NodeState.ChildNodeEntry)it.next()).getId();
                    this.resolve((NodeState)AggregateRuleImpl.this.ism.getItemState(id), collector, offset);
                }
            }
        }
    }
}

