/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.lang.reflect.InvocationTargetException;

public class DynamicPooledExecutor {
    private final PooledExecutor executor = new PooledExecutor();
    private volatile long lastCheck;
    private volatile int numProcessors;

    public DynamicPooledExecutor() {
        this.executor.setKeepAliveTime(500L);
        this.executor.waitWhenBlocked();
        this.adjustPoolSize();
    }

    public void execute(Runnable command) {
        this.adjustPoolSize();
        if (this.numProcessors == 1) {
            command.run();
        } else {
            try {
                this.executor.execute(command);
            }
            catch (InterruptedException e) {
                command.run();
            }
        }
    }

    public Result[] executeAndWait(Command[] commands) {
        Result[] results = new Result[commands.length];
        if (this.numProcessors == 1) {
            for (int i = 0; i < commands.length; ++i) {
                Object obj = null;
                InvocationTargetException ex = null;
                try {
                    obj = commands[i].call();
                }
                catch (Exception e) {
                    ex = new InvocationTargetException(e);
                }
                results[i] = new Result(obj, ex);
            }
        } else {
            FutureResult[] futures = new FutureResult[commands.length];
            for (int i = 0; i < commands.length; ++i) {
                final Command c = commands[i];
                futures[i] = new FutureResult();
                Runnable r = futures[i].setter(new Callable(){

                    public Object call() throws Exception {
                        return c.call();
                    }
                });
                try {
                    this.executor.execute(r);
                    continue;
                }
                catch (InterruptedException e) {
                    r.run();
                }
            }
            boolean interrupted = false;
            for (int i = 0; i < futures.length; ++i) {
                Object obj = null;
                InvocationTargetException ex = null;
                while (true) {
                    try {
                        obj = futures[i].get();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        Thread.interrupted();
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        ex = e;
                    }
                    break;
                }
                results[i] = new Result(obj, ex);
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return results;
    }

    private void adjustPoolSize() {
        if (this.lastCheck + 1000L < System.currentTimeMillis()) {
            int n = Runtime.getRuntime().availableProcessors();
            if (this.numProcessors != n) {
                this.executor.setMaximumPoolSize(n);
                this.numProcessors = n;
            }
            this.lastCheck = System.currentTimeMillis();
        }
    }

    public static class Result {
        private final Object object;
        private final InvocationTargetException exception;

        private Result(Object object, InvocationTargetException exception) {
            this.object = object;
            this.exception = exception;
        }

        public Object get() {
            return this.object;
        }

        public InvocationTargetException getException() {
            return this.exception;
        }
    }

    public static interface Command {
        public Object call() throws Exception;
    }
}

