/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.query.lucene.DateField;
import org.apache.jackrabbit.core.query.lucene.DoubleField;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.IndexingConfiguration;
import org.apache.jackrabbit.core.query.lucene.LongField;
import org.apache.jackrabbit.core.query.lucene.NamePathResolverImpl;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.extractor.TextExtractor;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeIndexer {
    private static final Logger log = LoggerFactory.getLogger((Class)NodeIndexer.class);
    protected static final float DEFAULT_BOOST = 1.0f;
    protected final NodeState node;
    protected final ItemStateManager stateProvider;
    protected final NamespaceMappings mappings;
    protected final NamePathResolver resolver;
    protected final TextExtractor extractor;
    protected IndexingConfiguration indexingConfig;
    protected boolean supportHighlighting = false;
    protected IndexFormatVersion indexFormatVersion = IndexFormatVersion.V1;

    public NodeIndexer(NodeState node, ItemStateManager stateProvider, NamespaceMappings mappings, TextExtractor extractor) {
        this.node = node;
        this.stateProvider = stateProvider;
        this.mappings = mappings;
        this.resolver = NamePathResolverImpl.create(mappings);
        this.extractor = extractor;
    }

    public NodeId getNodeId() {
        return this.node.getNodeId();
    }

    public void setSupportHighlighting(boolean b) {
        this.supportHighlighting = b;
    }

    public void setIndexFormatVersion(IndexFormatVersion indexFormatVersion) {
        this.indexFormatVersion = indexFormatVersion;
    }

    public void setIndexingConfiguration(IndexingConfiguration config) {
        this.indexingConfig = config;
    }

    protected Document createDoc() throws RepositoryException {
        Document doc = new Document();
        doc.setBoost(this.getNodeBoost());
        doc.add((Fieldable)new Field(FieldNames.UUID, this.node.getNodeId().getUUID().toString(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
        try {
            if (this.node.getParentId() == null) {
                doc.add((Fieldable)new Field(FieldNames.PARENT, "", Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
                doc.add((Fieldable)new Field(FieldNames.LABEL, "", Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
            } else {
                doc.add((Fieldable)new Field(FieldNames.PARENT, this.node.getParentId().toString(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
                NodeState parent = (NodeState)this.stateProvider.getItemState(this.node.getParentId());
                NodeState.ChildNodeEntry child = parent.getChildNodeEntry(this.node.getNodeId());
                if (child == null) {
                    throw new RepositoryException("Missing child node entry for node with id: " + this.node.getNodeId());
                }
                String name = this.resolver.getJCRName(child.getName());
                doc.add((Fieldable)new Field(FieldNames.LABEL, name, Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
            }
        }
        catch (NoSuchItemStateException e) {
            this.throwRepositoryException((Exception)((Object)e));
        }
        catch (ItemStateException e) {
            this.throwRepositoryException((Exception)((Object)e));
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        Set props = this.node.getPropertyNames();
        Iterator it = props.iterator();
        while (it.hasNext()) {
            Name propName = (Name)it.next();
            PropertyId id = new PropertyId(this.node.getNodeId(), propName);
            try {
                PropertyState propState = (PropertyState)this.stateProvider.getItemState(id);
                if (this.indexFormatVersion.getVersion() >= IndexFormatVersion.V2.getVersion()) {
                    this.addPropertyName(doc, propState.getName());
                }
                InternalValue[] values = propState.getValues();
                for (int i = 0; i < values.length; ++i) {
                    this.addValue(doc, values[i], propState.getName());
                }
                if (values.length <= 1) continue;
                this.addMVPName(doc, propState.getName());
            }
            catch (NoSuchItemStateException e) {
                this.throwRepositoryException((Exception)((Object)e));
            }
            catch (ItemStateException e) {
                this.throwRepositoryException((Exception)((Object)e));
            }
        }
        return doc;
    }

    private void throwRepositoryException(Exception e) throws RepositoryException {
        String msg = "Error while indexing node: " + this.node.getNodeId() + " of " + "type: " + this.node.getNodeTypeName();
        throw new RepositoryException(msg, (Throwable)e);
    }

    private void addMVPName(Document doc, Name name) {
        try {
            String propName = this.resolver.getJCRName(name);
            doc.add((Fieldable)new Field(FieldNames.MVP, propName, Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    private void addValue(Document doc, InternalValue value, Name name) {
        String fieldName = name.getLocalName();
        try {
            fieldName = this.resolver.getJCRName(name);
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        switch (value.getType()) {
            case 2: {
                if (!this.isIndexed(name)) break;
                this.addBinaryValue(doc, fieldName, value.getBLOBFileValue());
                break;
            }
            case 6: {
                if (!this.isIndexed(name)) break;
                this.addBooleanValue(doc, fieldName, value.getBoolean());
                break;
            }
            case 5: {
                if (!this.isIndexed(name)) break;
                this.addCalendarValue(doc, fieldName, value.getDate());
                break;
            }
            case 4: {
                if (!this.isIndexed(name)) break;
                this.addDoubleValue(doc, fieldName, new Double(value.getDouble()));
                break;
            }
            case 3: {
                if (!this.isIndexed(name)) break;
                this.addLongValue(doc, fieldName, new Long(value.getLong()));
                break;
            }
            case 9: {
                if (!this.isIndexed(name)) break;
                this.addReferenceValue(doc, fieldName, value.getUUID());
                break;
            }
            case 8: {
                if (!this.isIndexed(name)) break;
                this.addPathValue(doc, fieldName, value.getPath());
                break;
            }
            case 1: {
                if (!this.isIndexed(name)) break;
                if (name.equals(NameConstants.JCR_UUID)) {
                    this.addStringValue(doc, fieldName, value.getString(), false, false, 1.0f);
                    break;
                }
                this.addStringValue(doc, fieldName, value.getString(), true, this.isIncludedInNodeIndex(name), this.getPropertyBoost(name));
                break;
            }
            case 7: {
                if (!this.isIndexed(name) && !name.equals(NameConstants.JCR_PRIMARYTYPE) && !name.equals(NameConstants.JCR_MIXINTYPES)) break;
                this.addNameValue(doc, fieldName, value.getQName());
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal internal value type");
            }
        }
    }

    private void addPropertyName(Document doc, Name name) {
        String fieldName = name.getLocalName();
        try {
            fieldName = this.resolver.getJCRName(name);
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        doc.add((Fieldable)new Field(FieldNames.PROPERTIES_SET, fieldName, Field.Store.NO, Field.Index.NO_NORMS));
    }

    protected void addBinaryValue(Document doc, String fieldName, Object internalValue) {
        try {
            String jcrData = this.mappings.getPrefix("http://www.jcp.org/jcr/1.0") + ":data";
            if (!jcrData.equals(fieldName)) {
                return;
            }
            InternalValue typeValue = this.getValue(NameConstants.JCR_MIMETYPE);
            if (typeValue != null) {
                String type = typeValue.getString();
                String encoding = null;
                InternalValue encodingValue = this.getValue(NameConstants.JCR_ENCODING);
                if (encodingValue != null) {
                    encoding = encodingValue.getString();
                }
                InputStream stream = ((BLOBFileValue)internalValue).getStream();
                Reader reader = this.extractor.extractText(stream, type, encoding);
                doc.add((Fieldable)this.createFulltextField(reader));
            }
        }
        catch (Exception e) {
            log.warn("Exception while indexing binary property: " + e.toString());
            log.debug("Dump: ", (Throwable)e);
        }
    }

    protected InternalValue getValue(Name name) throws ItemStateException {
        try {
            PropertyId id = new PropertyId(this.node.getNodeId(), name);
            PropertyState property = (PropertyState)this.stateProvider.getItemState(id);
            InternalValue[] values = property.getValues();
            if (values.length > 0) {
                return values[0];
            }
            return null;
        }
        catch (NoSuchItemStateException e) {
            return null;
        }
    }

    protected void addBooleanValue(Document doc, String fieldName, Object internalValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, internalValue.toString(), false));
    }

    protected Field createFieldWithoutNorms(String fieldName, String internalValue, boolean store) {
        Field field = new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, internalValue), store ? Field.Store.YES : Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO);
        return field;
    }

    protected void addCalendarValue(Document doc, String fieldName, Object internalValue) {
        Calendar value = (Calendar)internalValue;
        long millis = value.getTimeInMillis();
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, DateField.timeToString(millis), false));
    }

    protected void addDoubleValue(Document doc, String fieldName, Object internalValue) {
        double doubleVal = (Double)internalValue;
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, DoubleField.doubleToString(doubleVal), false));
    }

    protected void addLongValue(Document doc, String fieldName, Object internalValue) {
        long longVal = (Long)internalValue;
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, LongField.longToString(longVal), false));
    }

    protected void addReferenceValue(Document doc, String fieldName, Object internalValue) {
        UUID value = (UUID)internalValue;
        String uuid = value.toString();
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, uuid, true));
    }

    protected void addPathValue(Document doc, String fieldName, Object internalValue) {
        Path path = (Path)internalValue;
        String pathString = path.toString();
        try {
            pathString = this.resolver.getJCRPath(path);
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, pathString, false));
    }

    protected void addStringValue(Document doc, String fieldName, Object internalValue) {
        this.addStringValue(doc, fieldName, internalValue, true, true, 1.0f);
    }

    protected void addStringValue(Document doc, String fieldName, Object internalValue, boolean tokenized) {
        this.addStringValue(doc, fieldName, internalValue, tokenized, true, 1.0f);
    }

    protected void addStringValue(Document doc, String fieldName, Object internalValue, boolean tokenized, boolean includeInNodeIndex, float boost) {
        String stringValue = (String)internalValue;
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, stringValue, false));
        if (tokenized) {
            if (stringValue.length() == 0) {
                return;
            }
            int idx = fieldName.indexOf(58);
            fieldName = fieldName.substring(0, idx + 1) + "FULL:" + fieldName.substring(idx + 1);
            Field f = new Field(fieldName, stringValue, Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO);
            f.setBoost(boost);
            doc.add((Fieldable)f);
            if (includeInNodeIndex) {
                doc.add((Fieldable)this.createFulltextField(stringValue));
            }
        }
    }

    protected void addNameValue(Document doc, String fieldName, Object internalValue) {
        try {
            Name qualiName = (Name)internalValue;
            String normValue = this.mappings.getPrefix(qualiName.getNamespaceURI()) + ":" + qualiName.getLocalName();
            doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, normValue, false));
        }
        catch (NamespaceException e) {
            // empty catch block
        }
    }

    protected Field createFulltextField(String value) {
        if (this.supportHighlighting) {
            Field.Store stored = value.length() > 16384 ? Field.Store.COMPRESS : Field.Store.YES;
            return new Field(FieldNames.FULLTEXT, value, stored, Field.Index.TOKENIZED, Field.TermVector.WITH_OFFSETS);
        }
        return new Field(FieldNames.FULLTEXT, value, Field.Store.NO, Field.Index.TOKENIZED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Field createFulltextField(Reader value) {
        if (this.supportHighlighting) {
            StringBuffer textExtract = new StringBuffer();
            char[] buffer = new char[1024];
            try {
                int len;
                while ((len = value.read(buffer)) > -1) {
                    textExtract.append(buffer, 0, len);
                }
            }
            catch (IOException e) {
                log.warn("Exception reading value for fulltext field: " + e.getMessage());
                log.debug("Dump:", (Throwable)e);
            }
            finally {
                try {
                    value.close();
                }
                catch (IOException e) {}
            }
            return this.createFulltextField(textExtract.toString());
        }
        return new Field(FieldNames.FULLTEXT, value);
    }

    protected boolean isIndexed(Name propertyName) {
        if (this.indexingConfig == null) {
            return true;
        }
        return this.indexingConfig.isIndexed(this.node, propertyName);
    }

    protected boolean isIncludedInNodeIndex(Name propertyName) {
        if (this.indexingConfig == null) {
            return true;
        }
        return this.indexingConfig.isIncludedInNodeScopeIndex(this.node, propertyName);
    }

    protected float getPropertyBoost(Name propertyName) {
        if (this.indexingConfig == null) {
            return 1.0f;
        }
        return this.indexingConfig.getPropertyBoost(this.node, propertyName);
    }

    protected float getNodeBoost() {
        if (this.indexingConfig == null) {
            return 1.0f;
        }
        return this.indexingConfig.getNodeBoost(this.node);
    }
}

