/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.ExecutablePreparedQuery;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.lucene.JQOM2LuceneQueryBuilder;
import org.apache.jackrabbit.core.query.lucene.QueryResultImpl;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.qom.BindVariableValueImpl;
import org.apache.jackrabbit.core.query.qom.ColumnImpl;
import org.apache.jackrabbit.core.query.qom.DefaultTraversingQOMTreeVisitor;
import org.apache.jackrabbit.core.query.qom.OrderingImpl;
import org.apache.jackrabbit.core.query.qom.QueryObjectModelTree;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.search.Query;

public class PreparedQueryImpl
extends AbstractQueryImpl
implements ExecutablePreparedQuery {
    private final QueryObjectModelTree qomTree;
    private final Set variableNames = new HashSet();
    private final Map bindValues = new HashMap();

    public PreparedQueryImpl(SessionImpl session, ItemManager itemMgr, SearchIndex index, PropertyTypeRegistry propReg, QueryObjectModelTree qomTree) {
        super(session, itemMgr, index, propReg);
        this.qomTree = qomTree;
        this.extractBindVariableNames(qomTree, this.variableNames);
    }

    public boolean needsSystemTree() {
        return true;
    }

    public QueryResult execute(long offset, long limit) throws RepositoryException {
        Query query = JQOM2LuceneQueryBuilder.createQuery(this.qomTree, this.session, this.index.getContext().getItemStateManager(), this.index.getNamespaceMappings(), this.index.getTextAnalyzer(), this.propReg, this.index.getSynonymProvider(), this.bindValues);
        ColumnImpl[] columns = this.qomTree.getColumns();
        Name[] selectProps = new Name[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            selectProps[i] = columns[i].getPropertyQName();
        }
        OrderingImpl[] orderings = this.qomTree.getOrderings();
        Name[] orderProps = new Name[orderings.length];
        boolean[] orderSpecs = new boolean[orderings.length];
        for (int i = 0; i < orderings.length; ++i) {
            orderSpecs[i] = orderings[i].getOrder() == 301;
        }
        return new QueryResultImpl(this.index, this.itemMgr, this.session.getNamePathResolver(), this.session.getAccessManager(), this, query, null, selectProps, orderProps, orderSpecs, this.getRespectDocumentOrder(), offset, limit);
    }

    public void bindValue(Name varName, Value value) throws IllegalArgumentException, RepositoryException {
        if (!this.variableNames.contains(varName)) {
            throw new IllegalArgumentException("not a valid variable in this query");
        }
        this.bindValues.put(varName, value);
    }

    private void extractBindVariableNames(QueryObjectModelTree qomTree, final Set bindVariableNames) {
        try {
            qomTree.accept(new DefaultTraversingQOMTreeVisitor(){

                public Object visit(BindVariableValueImpl node, Object data) {
                    bindVariableNames.add(node.getBindVariableQName());
                    return data;
                }
            }, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

