/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.core.query.AndQueryNode;
import org.apache.jackrabbit.core.query.DefaultQueryNodeVisitor;
import org.apache.jackrabbit.core.query.LocationStepQueryNode;
import org.apache.jackrabbit.core.query.NodeTypeQueryNode;
import org.apache.jackrabbit.core.query.OrderQueryNode;
import org.apache.jackrabbit.core.query.PathQueryNode;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.QueryNodeFactory;
import org.apache.jackrabbit.core.query.QueryParser;
import org.apache.jackrabbit.core.query.QueryRootNode;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryBuilder;
import org.apache.jackrabbit.core.query.lucene.QueryResultImpl;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.SpellSuggestion;
import org.apache.jackrabbit.core.query.lucene.WorkspaceTraversalResult;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
extends AbstractQueryImpl {
    private static final Logger log = LoggerFactory.getLogger((Class)QueryImpl.class);
    protected final QueryRootNode allNodesQueryNode;
    protected final QueryRootNode root;

    public QueryImpl(SessionImpl session, ItemManager itemMgr, SearchIndex index, PropertyTypeRegistry propReg, String statement, String language, QueryNodeFactory factory) throws InvalidQueryException {
        super(session, itemMgr, index, propReg);
        this.root = QueryParser.parse(statement, language, (NameResolver)session.getNamePathResolver(), factory);
        this.allNodesQueryNode = QueryImpl.createMatchAllNodesQuery(factory);
    }

    public QueryResult execute(long offset, long limit) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug("Executing query: \n" + this.root.dump());
        }
        if (this.allNodesQueryNode.equals(this.root)) {
            return new WorkspaceTraversalResult((Session)this.session, new Name[]{NameConstants.JCR_PRIMARYTYPE, NameConstants.JCR_PATH, NameConstants.JCR_SCORE}, this.session.getNamePathResolver());
        }
        Query query = LuceneQueryBuilder.createQuery(this.root, this.session, this.index.getContext().getItemStateManager(), this.index.getNamespaceMappings(), this.index.getTextAnalyzer(), this.propReg, this.index.getSynonymProvider(), this.index.getIndexFormatVersion());
        OrderQueryNode orderNode = this.root.getOrderNode();
        OrderQueryNode.OrderSpec[] orderSpecs = orderNode != null ? orderNode.getOrderSpecs() : new OrderQueryNode.OrderSpec[]{};
        Name[] orderProperties = new Name[orderSpecs.length];
        boolean[] ascSpecs = new boolean[orderSpecs.length];
        for (int i = 0; i < orderSpecs.length; ++i) {
            orderProperties[i] = orderSpecs[i].getProperty();
            ascSpecs[i] = orderSpecs[i].isAscending();
        }
        return new QueryResultImpl(this.index, this.itemMgr, this.session.getNamePathResolver(), this.session.getAccessManager(), this, query, new SpellSuggestion(this.index.getSpellChecker(), this.root), this.getSelectProperties(), orderProperties, ascSpecs, this.getRespectDocumentOrder(), offset, limit);
    }

    protected Name[] getSelectProperties() throws RepositoryException {
        ArrayList<Name> selectProps = new ArrayList<Name>();
        selectProps.addAll(Arrays.asList(this.root.getSelectProperties()));
        if (selectProps.size() == 0) {
            LocationStepQueryNode[] steps = this.root.getLocationNode().getPathSteps();
            final Name[] ntName = new Name[1];
            steps[steps.length - 1].acceptOperands(new DefaultQueryNodeVisitor(){

                public Object visit(AndQueryNode node, Object data) {
                    return node.acceptOperands(this, data);
                }

                public Object visit(NodeTypeQueryNode node, Object data) {
                    ntName[0] = node.getValue();
                    return data;
                }
            }, null);
            if (ntName[0] == null) {
                ntName[0] = NameConstants.NT_BASE;
            }
            NodeTypeImpl nt = this.session.getNodeTypeManager().getNodeType(ntName[0]);
            PropertyDefinition[] propDefs = nt.getPropertyDefinitions();
            for (int i = 0; i < propDefs.length; ++i) {
                PropertyDefinitionImpl propDef = (PropertyDefinitionImpl)propDefs[i];
                if (propDef.definesResidual() || propDef.isMultiple()) continue;
                selectProps.add(propDef.getQName());
            }
        }
        if (!selectProps.contains(NameConstants.JCR_PATH)) {
            selectProps.add(NameConstants.JCR_PATH);
        }
        if (!selectProps.contains(NameConstants.JCR_SCORE)) {
            selectProps.add(NameConstants.JCR_SCORE);
        }
        return selectProps.toArray(new Name[selectProps.size()]);
    }

    public boolean needsSystemTree() {
        return this.root.needsSystemTree();
    }

    private static QueryRootNode createMatchAllNodesQuery(QueryNodeFactory factory) {
        QueryRootNode allNodesQueryNode = factory.createQueryRootNode();
        PathQueryNode pathNode = factory.createPathQueryNode(allNodesQueryNode);
        LocationStepQueryNode lsNode = factory.createLocationStepQueryNode(pathNode);
        lsNode.setNameTest(null);
        lsNode.setIncludeDescendants(true);
        pathNode.addPathStep(lsNode);
        pathNode.setAbsolute(true);
        allNodesQueryNode.setLocationNode(pathNode);
        return allNodesQueryNode;
    }
}

