/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.jackrabbit.core.query.lucene.TextExtractorReader;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger log = LoggerFactory.getLogger((Class)Util.class);

    public static void disposeDocument(Document old) {
        Enumeration e = old.fields();
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            if (f.readerValue() == null) continue;
            try {
                f.readerValue().close();
            }
            catch (IOException ex) {
                log.warn("Exception while disposing index document: " + ex);
            }
        }
    }

    public static boolean isDocumentReady(Document doc) {
        Enumeration fields = doc.fields();
        while (fields.hasMoreElements()) {
            TextExtractorReader r;
            Field f = (Field)fields.nextElement();
            if (!(f.readerValue() instanceof TextExtractorReader) || (r = (TextExtractorReader)f.readerValue()).isExtractorFinished()) continue;
            return false;
        }
        return true;
    }
}

