/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.qom;

import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.core.query.qom.AbstractQOMNode;
import org.apache.jackrabbit.core.query.qom.ColumnImpl;
import org.apache.jackrabbit.core.query.qom.ConstraintImpl;
import org.apache.jackrabbit.core.query.qom.OrderingImpl;
import org.apache.jackrabbit.core.query.qom.QOMTreeVisitor;
import org.apache.jackrabbit.core.query.qom.SourceImpl;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

public class QueryObjectModelTree
extends AbstractQOMNode {
    private final SourceImpl source;
    private final ConstraintImpl constraint;
    private final OrderingImpl[] orderings;
    private final ColumnImpl[] columns;

    public QueryObjectModelTree(NamePathResolver resolver, SourceImpl source, ConstraintImpl constraint, OrderingImpl[] orderings, ColumnImpl[] columns) throws InvalidQueryException {
        super(resolver);
        this.source = source;
        this.constraint = constraint;
        this.orderings = orderings;
        this.columns = columns;
        this.checkQuery();
    }

    public SourceImpl getSource() {
        return this.source;
    }

    public ConstraintImpl getConstraint() {
        return this.constraint;
    }

    public OrderingImpl[] getOrderings() {
        OrderingImpl[] temp = new OrderingImpl[this.orderings.length];
        System.arraycopy(this.orderings, 0, temp, 0, this.orderings.length);
        return temp;
    }

    public ColumnImpl[] getColumns() {
        ColumnImpl[] temp = new ColumnImpl[this.columns.length];
        System.arraycopy(this.columns, 0, temp, 0, this.columns.length);
        return temp;
    }

    public Object accept(QOMTreeVisitor visitor, Object data) throws Exception {
        return visitor.visit(this, data);
    }

    private void checkQuery() throws InvalidQueryException {
    }
}

