/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.workflow.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.comment.workflow.CommentWorkflowFilter;
import org.nuxeo.ecm.platform.comment.workflow.services.CommentsModerationService;
import org.nuxeo.ecm.platform.jbpm.JbpmListFilter;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.runtime.api.Framework;

public class CommentsModerationServiceImpl
implements CommentsModerationService {
    private static final Log log = LogFactory.getLog(CommentsModerationService.class);

    public void startModeration(CoreSession session, DocumentModel doc, String commentID, ArrayList<String> moderators) throws ClientException {
        JbpmService jbpmService = CommentsModerationServiceImpl.getJbpmService();
        if (moderators == null || moderators.isEmpty()) {
            throw new ClientException("No moderators defined");
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put(JbpmService.VariableName.participants.name(), moderators);
        vars.put("commentId", commentID);
        jbpmService.createProcessInstance((NuxeoPrincipal)session.getPrincipal(), "comments_moderation", doc, vars, null);
    }

    public ProcessInstance getModerationProcess(JbpmService jbpmService, CoreSession session, DocumentModel doc, String commentId) throws ClientException {
        List processes = jbpmService.getProcessInstances(doc, (NuxeoPrincipal)session.getPrincipal(), (JbpmListFilter)new CommentWorkflowFilter(commentId));
        if (processes != null && !processes.isEmpty()) {
            if (processes.size() > 1) {
                log.error((Object)"There are several moderation workflows running, taking only first found");
            }
            return (ProcessInstance)processes.get(0);
        }
        return null;
    }

    public void approveComent(CoreSession session, DocumentModel doc, String commentId) throws ClientException {
        JbpmService jbpmService = CommentsModerationServiceImpl.getJbpmService();
        TaskInstance moderationTask = this.getModerationTask(jbpmService, session, doc, commentId);
        if (moderationTask == null) {
            session.followTransition((DocumentRef)new IdRef(commentId), "moderation_publish");
        } else {
            jbpmService.endTask(Long.valueOf(moderationTask.getId()), "moderation_publish", null, null, null, (NuxeoPrincipal)session.getPrincipal());
        }
        HashMap<String, String> eventInfo = new HashMap<String, String>();
        eventInfo.put("emailDetails", "test");
        this.notifyEvent(session, "commentPublished", null, null, null, doc);
    }

    public void rejectComment(CoreSession session, DocumentModel doc, String commentId) throws ClientException {
        JbpmService jbpmService = CommentsModerationServiceImpl.getJbpmService();
        TaskInstance moderationTask = this.getModerationTask(jbpmService, session, doc, commentId);
        if (moderationTask == null) {
            session.followTransition((DocumentRef)new IdRef(commentId), "moderation_reject");
        } else {
            jbpmService.endTask(Long.valueOf(moderationTask.getId()), "moderation_reject", null, null, null, (NuxeoPrincipal)session.getPrincipal());
        }
    }

    protected TaskInstance getModerationTask(JbpmService jbpmService, CoreSession session, DocumentModel doc, String commentId) throws ClientException {
        Collection tasks;
        ProcessInstance process = this.getModerationProcess(jbpmService, session, doc, commentId);
        if (process != null && (tasks = process.getTaskMgmtInstance().getTaskInstances()) != null && !tasks.isEmpty()) {
            if (tasks.size() > 1) {
                log.error((Object)"There are several moderation tasks, taking only first found");
            }
            TaskInstance task = (TaskInstance)tasks.iterator().next();
            return task;
        }
        return null;
    }

    public void publishComment(CoreSession session, DocumentModel comment) throws ClientException {
        session.followTransition(comment.getRef(), "moderation_publish");
        this.notifyEvent(session, "commentPublished", null, null, null, comment);
    }

    protected static JbpmService getJbpmService() throws ClientException {
        try {
            return (JbpmService)Framework.getService(JbpmService.class);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new ClientException((Throwable)e);
        }
    }

    protected void notifyEvent(CoreSession session, String eventId, Map<String, Serializable> properties, String comment, String category, DocumentModel dm) throws ClientException {
        if (category == null) {
            category = "eventDocumentCategory";
        }
        if (properties == null) {
            properties = new HashMap<String, Serializable>();
        }
        properties.put("repositoryName", (Serializable)((Object)session.getRepositoryName()));
        properties.put("sessionId", (Serializable)((Object)session.getSessionId()));
        properties.put("documentLifeCycle", (Serializable)((Object)dm.getCurrentLifeCycleState()));
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), dm);
        ctx.setProperties(properties);
        ctx.setComment(comment);
        ctx.setCategory(category);
        EventProducer evtProducer = null;
        try {
            evtProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        catch (Exception e) {
            log.error((Object)"Unable to access EventProducer", (Throwable)e);
            return;
        }
        Event event = ctx.newEvent(eventId);
        try {
            evtProducer.fireEvent(event);
        }
        catch (Exception e) {
            log.error((Object)"Error while sending event", (Throwable)e);
        }
    }
}

